/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.processing.internal;

import com.openexchange.exception.ExceptionUtils;
import com.openexchange.processing.Processor;
import com.openexchange.processing.internal.DefaultTaskManager;
import com.openexchange.processing.internal.ProcessorThreadPoolExecutor;
import com.openexchange.processing.internal.TaskManager;
import com.openexchange.threadpool.ThreadPools;
import com.openexchange.timer.TimerService;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoundRobinProcessor
implements Processor {
    static final Logger LOGGER = LoggerFactory.getLogger(RoundRobinProcessor.class);
    private final ExecutorService pool;
    private final int numThreads;
    final BlockingDeque<TaskManager> roundRobinQueue;
    final Map<Object, TaskManager> taskManagers;
    final AtomicInteger numberOfActiveSelectors;
    final AtomicBoolean stopped;

    public RoundRobinProcessor(String name, int numThreads) {
        if (numThreads <= 0) {
            throw new IllegalArgumentException("numThreads must not be equal to/less than zero");
        }
        this.numThreads = numThreads;
        ProcessorThreadPoolExecutor newPool = new ProcessorThreadPoolExecutor(name, numThreads);
        newPool.prestartAllCoreThreads();
        this.pool = newPool;
        this.taskManagers = new HashMap<Object, TaskManager>(256);
        this.roundRobinQueue = new LinkedBlockingDeque<TaskManager>();
        this.stopped = new AtomicBoolean(false);
        this.numberOfActiveSelectors = new AtomicInteger();
        int i = numThreads;
        while (i-- > 0) {
            newPool.execute(new Selector());
            this.numberOfActiveSelectors.incrementAndGet();
        }
    }

    @Override
    public void stop() {
        if (!this.stopped.compareAndSet(false, true)) {
            return;
        }
        int i = this.numThreads;
        while (i-- > 0) {
            this.roundRobinQueue.offerFirst(TaskManager.POISON);
        }
        try {
            this.pool.shutdownNow();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected Runnable getNextTaskFrom(TaskManager manager) {
        return manager.remove();
    }

    protected boolean allowNewTask(Runnable task) {
        return true;
    }

    protected void scheduleNewSelectorIfNeeded() {
        int num;
        do {
            if ((num = this.numberOfActiveSelectors.get()) < this.numThreads) continue;
            return;
        } while (!this.numberOfActiveSelectors.compareAndSet(num, num + 1));
        this.pool.execute(new Selector());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(Object optKey, Runnable task) {
        if (this.stopped.get()) {
            return false;
        }
        if (!this.allowNewTask(task)) {
            return false;
        }
        try {
            this.scheduleNewSelectorIfNeeded();
        }
        catch (RejectedExecutionException x) {
            return false;
        }
        Object key = null == optKey ? Thread.currentThread() : optKey;
        DefaultTaskManager newManager = null;
        Map<Object, TaskManager> map = this.taskManagers;
        synchronized (map) {
            TaskManager existingManager = this.taskManagers.get(key);
            if (existingManager == null) {
                newManager = new DefaultTaskManager(task, key);
                this.taskManagers.put(key, newManager);
            } else {
                existingManager.add(task);
            }
        }
        if (null != newManager) {
            this.roundRobinQueue.offerLast(newManager);
        }
        return true;
    }

    public final class Selector
    implements Runnable {
        Selector() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            Thread currentThread;
            block25: {
                currentThread = Thread.currentThread();
                if (RoundRobinProcessor.this.stopped.get()) {
                    LOGGER.info("Processor selector '{}' terminated", (Object)currentThread.getName());
                    return;
                }
                boolean decrementCount = true;
                try {
                    boolean proceed = true;
                    while (proceed) {
                        block24: {
                            block22: {
                                block23: {
                                    Runnable task;
                                    TaskManager manager;
                                    block21: {
                                        manager = RoundRobinProcessor.this.roundRobinQueue.takeFirst();
                                        if (TaskManager.POISON != manager) break block21;
                                        LOGGER.info("Processor selector '{}' terminated", (Object)currentThread.getName());
                                        if (!decrementCount) return;
                                        RoundRobinProcessor.this.numberOfActiveSelectors.decrementAndGet();
                                        return;
                                    }
                                    Map<Object, TaskManager> map = RoundRobinProcessor.this.taskManagers;
                                    synchronized (map) {
                                        task = RoundRobinProcessor.this.getNextTaskFrom(manager);
                                        if (null == task) {
                                            RoundRobinProcessor.this.taskManagers.remove(manager.getExecuterKey());
                                        }
                                        if (null == task) break block22;
                                    }
                                    RoundRobinProcessor.this.roundRobinQueue.offerLast(manager);
                                    task.run();
                                    if (!Thread.interrupted()) break block22;
                                    if (!RoundRobinProcessor.this.stopped.get()) break block23;
                                    LOGGER.info("Processor selector '{}' terminated", (Object)currentThread.getName());
                                    if (!decrementCount) return;
                                    RoundRobinProcessor.this.numberOfActiveSelectors.decrementAndGet();
                                    return;
                                }
                                proceed = false;
                                LOGGER.info("Processor selector '{}' terminated. Going to schedule a new selector for further processing.", (Object)currentThread.getName());
                                RoundRobinProcessor.this.numberOfActiveSelectors.decrementAndGet();
                                decrementCount = false;
                                TimerService optService = ThreadPools.getTimerService();
                                if (null != optService) {
                                    optService.schedule(new SelectorAdder(), 250L, TimeUnit.MILLISECONDS);
                                }
                                if (!decrementCount) return;
                                RoundRobinProcessor.this.numberOfActiveSelectors.decrementAndGet();
                                return;
                            }
                            if (!RoundRobinProcessor.this.stopped.get()) break block24;
                            LOGGER.info("Processor selector '{}' terminated", (Object)currentThread.getName());
                            if (!decrementCount) return;
                            RoundRobinProcessor.this.numberOfActiveSelectors.decrementAndGet();
                            return;
                        }
                        continue;
                        catch (InterruptedException e) {
                            throw e;
                        }
                        catch (RuntimeException e) {
                            LOGGER.info("Processing failed.", (Throwable)e);
                            continue;
                        }
                        catch (StackOverflowError e) {
                            LOGGER.info("Processing failed.", (Throwable)e);
                            continue;
                        }
                        catch (Throwable t) {
                            ExceptionUtils.handleThrowable((Throwable)t);
                            LOGGER.info("Processing failed", t);
                        }
                    }
                    if (!decrementCount) break block25;
                    RoundRobinProcessor.this.numberOfActiveSelectors.decrementAndGet();
                }
                catch (InterruptedException e) {
                    try {
                        currentThread.interrupt();
                        LOGGER.info("Processor selector '{}' interrupted", (Object)currentThread.getName(), (Object)e);
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        if (decrementCount) {
                            RoundRobinProcessor.this.numberOfActiveSelectors.decrementAndGet();
                        }
                    }
                }
            }
            LOGGER.info("Processor selector '{}' terminated", (Object)currentThread.getName());
        }
    }

    private final class SelectorAdder
    implements Runnable {
        SelectorAdder() {
        }

        @Override
        public void run() {
            try {
                RoundRobinProcessor.this.scheduleNewSelectorIfNeeded();
            }
            catch (Exception e) {
                LOGGER.warn("Failed to accept new Selector for execution", (Throwable)e);
            }
        }
    }
}

