/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.processing.internal;

import com.openexchange.processing.internal.ProcessorUncaughtExceptionhandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

final class ProcessorThreadFactory
implements ThreadFactory {
    private final AtomicInteger threadNumber = new AtomicInteger();
    private final String namePrefix;

    ProcessorThreadFactory(String name) {
        this.namePrefix = null == name ? "ProcessorThread-" : name + '-';
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread t = new Thread(r, ProcessorThreadFactory.getThreadName(this.threadNumber.incrementAndGet(), this.namePrefix));
        t.setUncaughtExceptionHandler(ProcessorUncaughtExceptionhandler.getInstance());
        return t;
    }

    private static String getThreadName(int threadNumber, String namePrefix) {
        StringBuilder retval = new StringBuilder(namePrefix.length() + 7);
        retval.append(namePrefix);
        for (int i = threadNumber; i < 1000000; i *= 10) {
            retval.append('0');
        }
        retval.append(threadNumber);
        return retval.toString();
    }
}

