/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.processing.internal;

import com.openexchange.processing.internal.RoundRobinProcessor;
import com.openexchange.processing.internal.TaskManager;
import java.util.concurrent.atomic.AtomicInteger;

public class BoundedRoundRobinProcessor
extends RoundRobinProcessor {
    private final int maxTasks;
    private final AtomicInteger numberOfPendingTasks;

    public BoundedRoundRobinProcessor(String name, int numThreads, int maxTasks) {
        super(name, numThreads);
        if (maxTasks <= 0) {
            throw new IllegalArgumentException("maxTask must not be equal to/less than zero");
        }
        this.maxTasks = maxTasks;
        this.numberOfPendingTasks = new AtomicInteger();
    }

    @Override
    protected boolean allowNewTask(Runnable task) {
        int count;
        do {
            if ((count = this.numberOfPendingTasks.get()) <= this.maxTasks) continue;
            return false;
        } while (!this.numberOfPendingTasks.compareAndSet(count, count + 1));
        return true;
    }

    @Override
    protected Runnable getNextTaskFrom(TaskManager manager) {
        Runnable task = super.getNextTaskFrom(manager);
        if (null != task) {
            this.numberOfPendingTasks.decrementAndGet();
        }
        return task;
    }
}

