/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.subscribe;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.subscribe.SubscribeService;
import com.openexchange.subscribe.SubscriptionSource;
import com.openexchange.subscribe.SubscriptionSourceDiscoveryService;
import com.openexchange.subscribe.helpers.FilteredSubscriptionSourceDiscoveryService;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class SubscriptionSourceCollector
implements SubscriptionSourceDiscoveryService {
    private final ConcurrentMap<String, SubscribeService> services = new ConcurrentHashMap<String, SubscribeService>();
    private final ConcurrentMap<String, SortedSet<SubscribeService>> shelvedServices = new ConcurrentHashMap<String, SortedSet<SubscribeService>>();

    @Override
    public SubscriptionSource getSource(String identifier) {
        SubscribeService subscribeService = (SubscribeService)this.services.get(identifier);
        return null == subscribeService ? null : subscribeService.getSubscriptionSource();
    }

    @Override
    public List<SubscriptionSource> getSources(int folderModule) {
        LinkedList<SubscriptionSource> sources = new LinkedList<SubscriptionSource>();
        for (SubscribeService subscriber : this.services.values()) {
            if (folderModule != -1 && !subscriber.handles(folderModule)) continue;
            sources.add(subscriber.getSubscriptionSource());
        }
        return sources;
    }

    @Override
    public List<SubscriptionSource> getSources() {
        return this.getSources(-1);
    }

    @Override
    public boolean knowsSource(String identifier) {
        return this.services.containsKey(identifier);
    }

    @Override
    public SubscriptionSourceDiscoveryService filter(int user, int context) throws OXException {
        return new FilteredSubscriptionSourceDiscoveryService(user, context, this);
    }

    public void addSubscribeService(SubscribeService service) {
        SubscribeService oldService = this.services.putIfAbsent(service.getSubscriptionSource().getId(), service);
        if (oldService != null) {
            if (oldService.getSubscriptionSource().getPriority() < service.getSubscriptionSource().getPriority()) {
                this.shelfService(oldService);
                this.services.put(service.getSubscriptionSource().getId(), service);
            } else {
                this.shelfService(service);
            }
        }
    }

    public void removeSubscribeService(String identifier) {
        this.services.remove(identifier);
        this.resurrectFromShelf(identifier);
    }

    @Override
    public SubscriptionSource getSource(Context context, int subscriptionId) throws OXException {
        for (SubscribeService source : this.services.values()) {
            if (!source.knows(context, subscriptionId)) continue;
            return source.getSubscriptionSource();
        }
        return null;
    }

    private void shelfService(SubscribeService service) {
        TreeSet<SubscribeService> newset;
        String identifier = service.getSubscriptionSource().getId();
        TreeSet<SubscribeService> set = (TreeSet<SubscribeService>)this.shelvedServices.get(identifier);
        if (set == null && null == (set = (SortedSet)this.shelvedServices.putIfAbsent(identifier, newset = new TreeSet<SubscribeService>(new Comparator<SubscribeService>(){

            @Override
            public int compare(SubscribeService o1, SubscribeService o2) {
                return o1.getSubscriptionSource().getPriority() - o2.getSubscriptionSource().getPriority();
            }
        })))) {
            set = newset;
        }
        set.add(service);
    }

    private void resurrectFromShelf(String identifier) {
        SortedSet set = (SortedSet)this.shelvedServices.get(identifier);
        if (set != null && !set.isEmpty()) {
            this.services.put(identifier, (SubscribeService)set.first());
            set.remove(set.first());
        }
    }
}

