/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.subscribe.internal;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.generic.TargetFolderDefinition;
import com.openexchange.subscribe.internal.FolderUpdaterStrategy;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class SimFolderUpdaterStrategy
implements FolderUpdaterStrategy<String> {
    private Set<String> dataSet;
    private final Set<String> savedElements = new HashSet<String>();
    private final Map<String, String> updatedElements = new HashMap<String, String>();

    public boolean handles(FolderObject folder) {
        return true;
    }

    public void setDataSet(String ... data) {
        this.dataSet = new HashSet<String>(Arrays.asList(data));
    }

    public boolean wasUpdated(String orig, String update) {
        if (!this.updatedElements.containsKey(orig)) {
            return false;
        }
        return this.updatedElements.get(orig).equals(update);
    }

    public boolean wasCreated(String string) {
        return this.savedElements.contains(string);
    }

    public int calculateSimilarityScore(String original, String candidate, Object session) throws OXException {
        int counter = 0;
        int size = Math.min(original.length(), candidate.length());
        for (int i = 0; i < size; ++i) {
            char cC;
            char cO = original.charAt(i);
            if (cO == (cC = candidate.charAt(i))) {
                ++counter;
                continue;
            }
            return counter;
        }
        return counter;
    }

    public void closeSession(Object session) throws OXException {
    }

    public Collection<String> getData(TargetFolderDefinition target, Object session) throws OXException {
        return this.dataSet;
    }

    public int getThreshold(Object session) throws OXException {
        return 3;
    }

    public void save(String newElement, Object session, Collection<OXException> errors) throws OXException {
        this.savedElements.add(newElement);
    }

    public Object startSession(TargetFolderDefinition target) throws OXException {
        return null;
    }

    public void update(String original, String update, Object session) throws OXException {
        this.updatedElements.put(original, update);
    }
}

