/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav.action;

import com.openexchange.tools.stream.UnsynchronizedByteArrayOutputStream;
import com.openexchange.webdav.action.WebdavResponse;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public class CapturingWebdavResponse
implements WebdavResponse {
    private final WebdavResponse delegate;
    private CapturingOutputStream stream;

    public CapturingWebdavResponse(WebdavResponse delegate) {
        this.delegate = delegate;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        if (this.stream != null) {
            return this.stream;
        }
        this.stream = new CapturingOutputStream(this.delegate.getOutputStream());
        return this.stream;
    }

    @Override
    public int getStatus() {
        return this.delegate.getStatus();
    }

    @Override
    public void setHeader(String header, String value) {
        this.delegate.setHeader(header, value);
    }

    @Override
    public void setStatus(int status) {
        this.delegate.setStatus(status);
    }

    public String getBodyAsString() {
        if (this.stream == null) {
            return "No Body";
        }
        try {
            return new String(this.stream.getCapture().toByteArray(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return e.toString();
        }
    }

    @Override
    public void setContentType(String s) {
        this.delegate.setContentType(s);
    }

    @Override
    public void sendString(String notFound) throws IOException {
        byte[] bytes = notFound.getBytes("UTF-8");
        this.setHeader("Content-Length", String.valueOf(bytes.length));
        this.getOutputStream().write(bytes);
    }

    private static final class CapturingOutputStream
    extends OutputStream {
        private final OutputStream delegate;
        private final ByteArrayOutputStream capture;

        public CapturingOutputStream(OutputStream delegate) {
            this.delegate = delegate;
            this.capture = new UnsynchronizedByteArrayOutputStream();
        }

        @Override
        public void close() throws IOException {
            this.delegate.close();
        }

        public boolean equals(Object arg0) {
            return this.delegate.equals(arg0);
        }

        @Override
        public void flush() throws IOException {
            this.delegate.flush();
        }

        public int hashCode() {
            return this.delegate.hashCode();
        }

        public String toString() {
            return this.delegate.toString();
        }

        @Override
        public void write(byte[] arg0, int arg1, int arg2) throws IOException {
            this.delegate.write(arg0, arg1, arg2);
            this.capture.write(arg0, arg1, arg2);
        }

        @Override
        public void write(byte[] arg0) throws IOException {
            this.delegate.write(arg0);
            this.capture.write(arg0);
        }

        @Override
        public void write(int arg0) throws IOException {
            this.delegate.write(arg0);
            this.capture.write(arg0);
        }

        public ByteArrayOutputStream getCapture() {
            return this.capture;
        }
    }
}

