/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.tnef;

import com.openexchange.i18n.LocaleTools;
import com.openexchange.i18n.tools.StringHelper;
import com.openexchange.tools.tnef.TNEF2ICalUtility;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Locale;
import java.util.TimeZone;
import java.util.regex.Pattern;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.model.Component;
import net.fortuna.ical4j.model.Date;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.Parameter;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.PropertyList;
import net.fortuna.ical4j.model.component.VAlarm;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.parameter.Cn;
import net.fortuna.ical4j.model.parameter.CuType;
import net.fortuna.ical4j.model.parameter.PartStat;
import net.fortuna.ical4j.model.parameter.Role;
import net.fortuna.ical4j.model.parameter.Rsvp;
import net.fortuna.ical4j.model.property.Action;
import net.fortuna.ical4j.model.property.Attendee;
import net.fortuna.ical4j.model.property.Categories;
import net.fortuna.ical4j.model.property.Clazz;
import net.fortuna.ical4j.model.property.Created;
import net.fortuna.ical4j.model.property.Description;
import net.fortuna.ical4j.model.property.DtEnd;
import net.fortuna.ical4j.model.property.DtStamp;
import net.fortuna.ical4j.model.property.DtStart;
import net.fortuna.ical4j.model.property.Location;
import net.fortuna.ical4j.model.property.Method;
import net.fortuna.ical4j.model.property.Organizer;
import net.fortuna.ical4j.model.property.Priority;
import net.fortuna.ical4j.model.property.ProdId;
import net.fortuna.ical4j.model.property.Summary;
import net.fortuna.ical4j.model.property.Trigger;
import net.fortuna.ical4j.model.property.Uid;
import net.fortuna.ical4j.model.property.Version;
import net.freeutils.tnef.Attr;
import net.freeutils.tnef.MAPIProp;
import net.freeutils.tnef.MAPIProps;
import net.freeutils.tnef.Message;
import net.freeutils.tnef.RawInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TNEF2ICal {
    private static final Logger LOG = LoggerFactory.getLogger(TNEF2ICal.class);
    private static final Pattern SPLIT_SEMICOLON = Pattern.compile(" *; *");

    private TNEF2ICal() {
    }

    public static boolean isVPart(Message message) {
        try {
            Attr messageClass = message.getAttribute(32776);
            return TNEF2ICal.isVPart(messageClass == null ? "" : ((String)messageClass.getValue()).toUpperCase(Locale.ENGLISH));
        }
        catch (IOException e) {
            LOG.error("", (Throwable)e);
            return false;
        }
    }

    public static boolean isVPart(String messageClassName) {
        if (null == messageClassName) {
            return false;
        }
        String mcn = messageClassName.toUpperCase(Locale.ENGLISH);
        return mcn.startsWith("IPM.MICROSOFT SCHEDULE.") || mcn.startsWith("IPM.SCHEDULE.") || "IPM.APPOINTMENT".equals(mcn);
    }

    public static Calendar tnef2VPart(Message message) {
        try {
            Locale locale;
            RawInputStream ris;
            String tzid;
            String tmp;
            String[] attendees;
            String organizer;
            MAPIProp prop;
            Attr messageClass = message.getAttribute(32776);
            String messageClassName = messageClass == null ? (null == (prop = message.getMAPIProps().getProp(26)) ? "" : prop.getValue().toString().toUpperCase(Locale.ENGLISH)) : ((String)messageClass.getValue()).toUpperCase(Locale.ENGLISH);
            MAPIProps mapiProps = message.getMAPIProps();
            if (mapiProps == null) {
                return null;
            }
            boolean bCompatMethodRequest = false;
            boolean bCompatMethodCancled = false;
            boolean bCompatMethodAccepted = false;
            boolean bCompatMethodAcceptedCond = false;
            boolean bCompatMethodDeclined = false;
            if (!TNEF2ICal.isVPart(messageClassName)) {
                return null;
            }
            Calendar calendar2 = new Calendar();
            if (messageClassName.endsWith(".MTGREQ")) {
                bCompatMethodRequest = true;
            }
            if (messageClassName.endsWith(".MTGCNCL")) {
                bCompatMethodCancled = true;
            }
            if (messageClassName.endsWith(".MTGRESPP")) {
                bCompatMethodAccepted = true;
            }
            if (messageClassName.endsWith(".MTGRESPA")) {
                bCompatMethodAcceptedCond = true;
            }
            if (messageClassName.endsWith(".MTGRESPN")) {
                bCompatMethodDeclined = true;
            }
            PropertyList propertyList = calendar2.getProperties();
            propertyList.add((Property)new ProdId("-//Microsoft Corporation//Outlook " + TNEF2ICalUtility.findNamedProp("0x8554", "9.0", mapiProps) + " MIMEDIR//EN"));
            propertyList.add((Property)Version.VERSION_2_0);
            String sSenderName = (String)TNEF2ICalUtility.findProp(3098, mapiProps);
            String sSenderSearchKeyEmail = TNEF2ICalUtility.getEmailAddress(TNEF2ICalUtility.findPropString(3103, mapiProps));
            boolean bIsReply = false;
            if (bCompatMethodAccepted || bCompatMethodAcceptedCond || bCompatMethodDeclined) {
                bIsReply = true;
                calendar2.getProperties().add((Property)Method.REPLY);
            } else if ("1".equals(TNEF2ICalUtility.findProp(3095, mapiProps))) {
                bIsReply = true;
                calendar2.getProperties().add((Property)Method.REPLY);
            } else {
                calendar2.getProperties().add((Property)Method.REQUEST);
            }
            VEvent event = new VEvent();
            PropertyList eventPropertyList = event.getProperties();
            eventPropertyList.add((Property)Clazz.PUBLIC);
            String s = TNEF2ICalUtility.getEmailAddress(TNEF2ICalUtility.findPropString(3103, mapiProps));
            if (TNEF2ICalUtility.isEmpty(s) && !bIsReply) {
                s = sSenderSearchKeyEmail;
            }
            if (!TNEF2ICalUtility.isEmpty(s)) {
                organizer = s;
                Organizer property = new Organizer(organizer);
                if (null != sSenderName) {
                    property.getParameters().add((Parameter)new Cn(sSenderName));
                }
                eventPropertyList.add((Property)property);
            } else {
                organizer = null;
            }
            s = (String)TNEF2ICalUtility.findProp(3588, mapiProps);
            String[] stringArray = attendees = null == s ? new String[]{} : SPLIT_SEMICOLON.split(s, 0);
            if (attendees.length > 0) {
                for (String sAttendee : attendees) {
                    String addr = TNEF2ICalUtility.getEmailAddress(sAttendee);
                    if (null == addr) continue;
                    s = addr;
                    Attendee attendee = TNEF2ICal.generateAttendee(bCompatMethodAccepted, bCompatMethodAcceptedCond, bCompatMethodDeclined, bIsReply, s);
                    eventPropertyList.add((Property)attendee);
                }
            } else {
                s = sSenderSearchKeyEmail;
                if (!TNEF2ICalUtility.isEmpty(s)) {
                    Attendee attendee = TNEF2ICal.generateAttendee(bCompatMethodAccepted, bCompatMethodAcceptedCond, bCompatMethodDeclined, bIsReply, s);
                    eventPropertyList.add((Property)attendee);
                }
            }
            if (null == (tmp = (String)TNEF2ICalUtility.findNamedProp("0x8234", mapiProps))) {
                tzid = "GMT";
            } else {
                try {
                    int p1 = tmp.indexOf(40) + 1;
                    int p2 = tmp.indexOf(41, p1);
                    if (p1 >= 0 && p2 > 0) {
                        tmp = tmp.substring(p1, p2);
                        tzid = TimeZone.getTimeZone(tmp).getID();
                    } else {
                        LOG.warn("Cannot parse time zone information from: \"{}\"", (Object)tmp);
                        tzid = "GMT";
                    }
                }
                catch (Exception e) {
                    LOG.warn("Cannot parse time zone information from: \"{}\"", (Object)tmp, (Object)e);
                    tzid = "GMT";
                }
            }
            java.util.Date d = (java.util.Date)TNEF2ICalUtility.findProp(12295, mapiProps);
            if (d != null) {
                eventPropertyList.add((Property)new Created(TNEF2ICalUtility.toDateTime(d, tzid)));
            }
            if ((d = (java.util.Date)TNEF2ICalUtility.findProp(96, mapiProps)) != null) {
                eventPropertyList.add((Property)new DtStart((Date)TNEF2ICalUtility.toDateTime(d, tzid)));
            }
            if ((d = (java.util.Date)TNEF2ICalUtility.findProp(97, mapiProps)) != null) {
                eventPropertyList.add((Property)new DtEnd((Date)TNEF2ICalUtility.toDateTime(d, tzid)));
            }
            if (!TNEF2ICalUtility.isEmpty(s = (String)TNEF2ICalUtility.findNamedProp("0x8208", mapiProps))) {
                eventPropertyList.add((Property)new Location(s));
            }
            if ((ris = (RawInputStream)TNEF2ICalUtility.findNamedProp("0x23", mapiProps)) == null) {
                ris = (RawInputStream)TNEF2ICalUtility.findNamedProp("0x3", mapiProps);
            }
            if (ris != null) {
                s = TNEF2ICalUtility.toHexString(ris.toByteArray());
                eventPropertyList.add((Property)new Uid(s));
            }
            if ((d = (java.util.Date)TNEF2ICalUtility.findNamedProp("0x8202", mapiProps)) != null) {
                eventPropertyList.add((Property)new DtStamp(TNEF2ICalUtility.toDateTime(d, tzid)));
            }
            if (!TNEF2ICalUtility.isEmpty(s = TNEF2ICalUtility.findPropString(14859, mapiProps))) {
                eventPropertyList.add((Property)new Categories(s));
            }
            if (!TNEF2ICalUtility.isEmpty(s = TNEF2ICalUtility.findPropString(4096, mapiProps))) {
                eventPropertyList.add((Property)new Description(s));
            }
            if (!TNEF2ICalUtility.isEmpty(s = TNEF2ICalUtility.findPropString(112, mapiProps))) {
                eventPropertyList.add((Property)new Summary(s));
            }
            if (!TNEF2ICalUtility.isEmpty(s = TNEF2ICalUtility.findPropString(38, mapiProps))) {
                eventPropertyList.add((Property)new Priority(Integer.parseInt(s.trim())));
            }
            if ((s = TNEF2ICalUtility.findNamedPropString("acceptlanguage", mapiProps)) == null) {
                locale = Locale.ENGLISH;
            } else {
                Locale tmp2 = LocaleTools.getLocale((String)s.replaceAll("-", "_"));
                Locale locale2 = locale = tmp2 == null ? Locale.ENGLISH : tmp2;
            }
            if (!TNEF2ICalUtility.isEmpty(TNEF2ICalUtility.findNamedPropString("0x8503", mapiProps))) {
                VAlarm vAlarm = new VAlarm();
                vAlarm.getProperties().add((Property)Action.DISPLAY);
                java.util.Date highNoonTime = d = (java.util.Date)TNEF2ICalUtility.findNamedProp("0x8502", mapiProps);
                d = (java.util.Date)TNEF2ICalUtility.findNamedProp("0x8560", mapiProps);
                if (null != d) {
                    vAlarm.getProperties().add((Property)new Trigger(new DateTime(d)));
                }
                vAlarm.getProperties().add((Property)new Description(StringHelper.valueOf(locale).getString("Reminder")));
                event.getAlarms().add((Component)vAlarm);
            }
            calendar2.getComponents().add((Component)event);
            return calendar2;
        }
        catch (NumberFormatException e) {
            LOG.error("", (Throwable)e);
            return null;
        }
        catch (IOException e) {
            LOG.error("", (Throwable)e);
            return null;
        }
        catch (URISyntaxException e) {
            LOG.error("", (Throwable)e);
            return null;
        }
    }

    private static Attendee generateAttendee(boolean bCompatMethodAccepted, boolean bCompatMethodAcceptedCond, boolean bCompatMethodDeclined, boolean bIsReply, String s) throws URISyntaxException {
        Attendee attendee = new Attendee(s);
        if (bIsReply) {
            if (bCompatMethodAccepted) {
                attendee.getParameters().add((Parameter)PartStat.ACCEPTED);
                attendee.getParameters().add((Parameter)Role.REQ_PARTICIPANT);
            }
            if (bCompatMethodDeclined) {
                attendee.getParameters().add((Parameter)PartStat.DECLINED);
                attendee.getParameters().add((Parameter)Role.REQ_PARTICIPANT);
            }
            if (bCompatMethodAcceptedCond) {
                attendee.getParameters().add((Parameter)PartStat.TENTATIVE);
                attendee.getParameters().add((Parameter)Role.REQ_PARTICIPANT);
            }
        } else {
            attendee.getParameters().add((Parameter)PartStat.NEEDS_ACTION);
            attendee.getParameters().add((Parameter)Role.REQ_PARTICIPANT);
            attendee.getParameters().add((Parameter)Rsvp.TRUE);
        }
        attendee.getParameters().add((Parameter)CuType.INDIVIDUAL);
        return attendee;
    }
}

