/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.io;

import com.openexchange.java.Streams;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Scanner;

public class IOTools {
    private IOTools() {
    }

    public static final void reallyBloodySkip(InputStream is, long bytes) throws IOException {
        while (bytes > 0L) {
            long skipped = is.skip(bytes);
            if (skipped < 0L) {
                return;
            }
            bytes -= skipped;
        }
    }

    public static final void copy(InputStream in, OutputStream out) throws IOException {
        int i;
        InputStream inputStream = Streams.bufferedInputStreamFor((InputStream)in);
        OutputStream outputStream = Streams.bufferedOutputStreamFor((OutputStream)out);
        while ((i = inputStream.read()) >= 0) {
            outputStream.write(i);
        }
        outputStream.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final byte[] getBytes(InputStream stream) throws IOException {
        try (InputStream in = Streams.bufferedInputStreamFor((InputStream)stream);){
            int i;
            ByteArrayOutputStream out = Streams.newByteArrayOutputStream();
            while ((i = in.read()) >= 0) {
                out.write(i);
            }
            byte[] byArray = out.toByteArray();
            return byArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String getFileContents(File file) throws FileNotFoundException {
        StringBuilder sb = new StringBuilder();
        Scanner scanner = null;
        try {
            scanner = new Scanner(file, "UTF-8");
            while (scanner.hasNextLine()) {
                sb.append(scanner.nextLine());
                sb.append('\n');
            }
        }
        finally {
            if (null != scanner) {
                scanner.close();
            }
        }
        return sb.toString();
    }
}

