/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.images.transformations;

import com.openexchange.imagetransformation.ImageInformation;
import com.openexchange.imagetransformation.ScaleType;
import com.openexchange.imagetransformation.TransformationContext;
import com.openexchange.tools.images.impl.AutoDimensionConstrain;
import com.openexchange.tools.images.impl.ContainDimensionConstrain;
import com.openexchange.tools.images.impl.CoverDimensionConstrain;
import com.openexchange.tools.images.impl.DimensionConstrain;
import com.openexchange.tools.images.transformations.ImageTransformation;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.io.IOException;
import org.imgscalr.Scalr;

public class ScaleTransformation
implements ImageTransformation {
    private final int maxWidth;
    private final int maxHeight;
    private final ScaleType scaleType;

    public ScaleTransformation(int maxWidth, int maxHeight, ScaleType scaleType) {
        this.maxWidth = maxWidth;
        this.maxHeight = maxHeight;
        this.scaleType = scaleType;
    }

    @Override
    public BufferedImage perform(BufferedImage sourceImage, TransformationContext transformationContext, ImageInformation imageInformation) throws IOException {
        DimensionConstrain constrain;
        switch (this.scaleType) {
            case COVER: {
                constrain = new CoverDimensionConstrain(this.maxWidth, this.maxHeight);
                break;
            }
            case CONTAIN: {
                if (null != sourceImage && this.maxWidth >= sourceImage.getWidth() && this.maxHeight >= sourceImage.getHeight()) {
                    return sourceImage;
                }
                constrain = new ContainDimensionConstrain(this.maxWidth, this.maxHeight);
                break;
            }
            default: {
                constrain = new AutoDimensionConstrain(this.maxWidth, this.maxHeight);
            }
        }
        transformationContext.addExpense(3);
        Dimension dimension = constrain.getDimension(new Dimension(sourceImage.getWidth(), sourceImage.getHeight()));
        int targetWidth = (int)dimension.getWidth();
        int targetHeight = (int)dimension.getHeight();
        return Scalr.resize((BufferedImage)sourceImage, (Scalr.Method)Scalr.Method.AUTOMATIC, (int)targetWidth, (int)targetHeight, (BufferedImageOp[])new BufferedImageOp[0]);
    }

    @Override
    public boolean needsImageInformation() {
        return false;
    }

    @Override
    public boolean supports(String formatName) {
        return true;
    }
}

