/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.server.impl;

import com.openexchange.tools.OXCloneable;
import java.io.Serializable;
import java.security.acl.Permission;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OCLPermission
implements Permission,
Cloneable,
Serializable,
OXCloneable<OCLPermission> {
    private static final String STR_USER = "User";
    private static final String STR_GROUP = "Group";
    private static final String STR_EMPTY = "";
    private static final String STR_FOLDER_ADMIN = "_FolderAdmin";
    private static final String STR_SYSTEM = "system";
    private static final long serialVersionUID = 3740098766897625419L;
    private static final transient Logger LOG = LoggerFactory.getLogger(OCLPermission.class);
    public static final int NO_PERMISSIONS = 0;
    public static final int ADMIN_PERMISSION = 128;
    public static final int READ_FOLDER = 2;
    public static final int CREATE_OBJECTS_IN_FOLDER = 4;
    public static final int CREATE_SUB_FOLDERS = 8;
    public static final int READ_OWN_OBJECTS = 2;
    public static final int READ_ALL_OBJECTS = 4;
    public static final int WRITE_OWN_OBJECTS = 2;
    public static final int WRITE_ALL_OBJECTS = 4;
    public static final int DELETE_OWN_OBJECTS = 2;
    public static final int DELETE_ALL_OBJECTS = 4;
    public static final int ALL_GROUPS_AND_USERS = 0;
    public static final int ALL_GUESTS = Integer.MAX_VALUE;
    public static final int SYSTEM_SYSTEM = 1;
    private String name;
    private int fuid;
    private int entity = -1;
    private int fp = 0;
    private int orp = 0;
    private int owp = 0;
    private int odp = 0;
    private int system;
    private boolean folderAdmin;
    private boolean groupPermission;

    public OCLPermission() {
    }

    public OCLPermission(int entity, int fuid) {
        this.entity = entity;
        this.fuid = fuid;
    }

    public void reset() {
        this.name = null;
        this.fuid = 0;
        this.entity = -1;
        this.fp = 0;
        this.orp = 0;
        this.owp = 0;
        this.odp = 0;
        this.folderAdmin = false;
        this.groupPermission = false;
        this.system = 0;
    }

    public void setSystem(int system) {
        this.system = system;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setEntity(int entity) {
        this.entity = entity;
        if (this.name == null) {
            this.name = entity + (this.folderAdmin ? STR_FOLDER_ADMIN : STR_EMPTY) + (this.groupPermission ? STR_GROUP : STR_USER);
        }
    }

    public void setFolderAdmin(boolean folderAdmin) {
        this.folderAdmin = folderAdmin;
        if (this.name == null) {
            this.name = this.entity + (folderAdmin ? STR_FOLDER_ADMIN : STR_EMPTY) + (this.groupPermission ? STR_GROUP : STR_USER);
        }
    }

    public void setGroupPermission(boolean groupPermission) {
        this.groupPermission = groupPermission;
        if (this.name == null) {
            this.name = this.entity + (this.folderAdmin ? STR_FOLDER_ADMIN : STR_EMPTY) + (groupPermission ? STR_GROUP : STR_USER);
        }
    }

    public boolean setFolderPermission(int p) {
        if (this.validatePermission(p)) {
            this.fp = p;
            return true;
        }
        return false;
    }

    public boolean setReadObjectPermission(int p) {
        if (this.validatePermission(p)) {
            this.orp = p;
            return true;
        }
        return false;
    }

    public boolean setWriteObjectPermission(int p) {
        if (this.validatePermission(p)) {
            this.owp = p;
            return true;
        }
        return false;
    }

    public boolean setDeleteObjectPermission(int p) {
        if (this.validatePermission(p)) {
            this.odp = p;
            return true;
        }
        return false;
    }

    public boolean setAllObjectPermission(int pr, int pw, int pd) {
        if (this.validatePermission(pr) && this.validatePermission(pw) && this.validatePermission(pd)) {
            this.orp = pr;
            this.owp = pw;
            this.odp = pd;
            return true;
        }
        return false;
    }

    public boolean setAllPermission(int fp, int opr, int opw, int opd) {
        if (this.validatePermission(fp) && this.validatePermission(opr) && this.validatePermission(opw) && this.validatePermission(opd)) {
            this.fp = fp;
            this.orp = opr;
            this.owp = opw;
            this.odp = opd;
            return true;
        }
        return false;
    }

    private final boolean validatePermission(int p) {
        return p % 2 == 0 && p <= 128 && p >= 0;
    }

    public void setFuid(int fuid) {
        this.fuid = fuid;
    }

    public boolean isFolderAdmin() {
        return this.folderAdmin;
    }

    public boolean isGroupPermission() {
        return this.groupPermission;
    }

    public int getFolderPermission() {
        return this.fp;
    }

    public int getReadPermission() {
        return this.orp;
    }

    public int getWritePermission() {
        return this.owp;
    }

    public int getDeletePermission() {
        return this.odp;
    }

    public boolean isFolderVisible() {
        if (this.isFolderAdmin()) {
            return true;
        }
        return this.getFolderPermission() >= 2;
    }

    public boolean canCreateObjects() {
        return this.getFolderPermission() >= 4;
    }

    public boolean canCreateSubfolders() {
        return this.getFolderPermission() >= 8;
    }

    public boolean canReadOwnObjects() {
        return this.getReadPermission() >= 2;
    }

    public boolean canReadAllObjects() {
        return this.getReadPermission() >= 4;
    }

    public boolean canWriteOwnObjects() {
        return this.getWritePermission() >= 2;
    }

    public boolean canWriteAllObjects() {
        return this.getWritePermission() >= 4;
    }

    public boolean canDeleteOwnObjects() {
        return this.getDeletePermission() >= 2;
    }

    public boolean canDeleteAllObjects() {
        return this.getDeletePermission() >= 4;
    }

    public String getName() {
        return this.name;
    }

    public int getEntity() {
        return this.entity;
    }

    public int getFuid() {
        return this.fuid;
    }

    public int getSystem() {
        return this.system;
    }

    public boolean isSystem() {
        return (this.system & 1) == 1;
    }

    public boolean equalsPermission(OCLPermission op) {
        if (this == op) {
            return true;
        }
        if (op == null) {
            return false;
        }
        return this.fp == op.fp && this.orp == op.orp && this.owp == op.owp && this.odp == op.odp && this.folderAdmin == op.folderAdmin && this.groupPermission == op.groupPermission;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !(other instanceof OCLPermission)) {
            return false;
        }
        OCLPermission op = (OCLPermission)other;
        return this.entity == op.entity && this.fuid == op.fuid && this.fp == op.fp && this.orp == op.orp && this.owp == op.owp && this.odp == op.odp && this.folderAdmin == op.folderAdmin && this.groupPermission == op.groupPermission && this.system == op.system;
    }

    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + this.entity;
        hash = 31 * hash + this.fuid;
        hash = 31 * hash + this.fp;
        hash = 31 * hash + this.orp;
        hash = 31 * hash + this.owp;
        hash = 31 * hash + this.odp;
        hash = 31 * hash + (this.folderAdmin ? 1 : 0);
        hash = 31 * hash + (this.groupPermission ? 1 : 0);
        hash = 31 * hash + this.system;
        return hash;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(50);
        sb.append(this.folderAdmin ? STR_FOLDER_ADMIN : STR_EMPTY).append(this.groupPermission ? STR_GROUP : STR_USER).append(this.entity).append('@').append(this.fp).append('.').append(this.orp).append('.').append(this.owp).append('.').append(this.odp).append(' ').append(STR_SYSTEM).append('=').append(this.system);
        return sb.toString();
    }

    public Object clone() throws CloneNotSupportedException {
        OCLPermission clone = (OCLPermission)super.clone();
        return clone;
    }

    @Override
    public OCLPermission deepClone() {
        try {
            return (OCLPermission)super.clone();
        }
        catch (CloneNotSupportedException e) {
            LOG.error(STR_EMPTY, (Throwable)e);
            return null;
        }
    }
}

