/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.resource.json.actions;

import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.documentation.RequestMethod;
import com.openexchange.documentation.annotations.Action;
import com.openexchange.documentation.annotations.Parameter;
import com.openexchange.exception.OXException;
import com.openexchange.resource.Resource;
import com.openexchange.resource.ResourceService;
import com.openexchange.resource.internal.ResourceServiceImpl;
import com.openexchange.resource.json.ResourceAJAXRequest;
import com.openexchange.resource.json.actions.AbstractResourceAction;
import com.openexchange.resource.json.actions.AllAction;
import com.openexchange.server.ServiceExceptionCode;
import com.openexchange.server.ServiceLookup;
import java.util.Date;
import java.util.LinkedList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Action(method=RequestMethod.PUT, name="search", description="Search for resources", parameters={@Parameter(name="session", description="A session ID previously obtained from the login module.")}, requestBody="An object with search parameters as described in Participant search.", responseDescription="An array of resource objects as described in Resource response.")
public final class SearchAction
extends AbstractResourceAction {
    private static final Logger LOG = LoggerFactory.getLogger(SearchAction.class);

    public SearchAction(ServiceLookup services) {
        super(services);
    }

    @Override
    protected AJAXRequestResult perform(ResourceAJAXRequest req) throws OXException, JSONException {
        Date timestamp;
        ResourceServiceImpl resourceService = ResourceServiceImpl.getInstance();
        if (null == resourceService) {
            throw ServiceExceptionCode.SERVICE_UNAVAILABLE.create(new Object[]{ResourceService.class.getName()});
        }
        if (!req.getSession().getUserPermissionBits().hasGroupware()) {
            return new AJAXRequestResult((Object)new JSONArray(0), "json");
        }
        JSONObject jData = (JSONObject)req.getData();
        if (!jData.hasAndNotNull("pattern")) {
            LOG.warn("Missing field \"{}\" in JSON data. Searching for all as fallback", (Object)"pattern");
            return new AllAction(this.services).perform(req);
        }
        String searchpattern = jData.getString("pattern");
        Resource[] resources = resourceService.searchResources(searchpattern, req.getSession().getContext());
        LinkedList<Resource> list = new LinkedList<Resource>();
        if (resources.length > 0) {
            long lastModified = Long.MIN_VALUE;
            for (Resource resource : resources) {
                if (lastModified < resource.getLastModified().getTime()) {
                    lastModified = resource.getLastModified().getTime();
                }
                list.add(resource);
            }
            timestamp = new Date(lastModified);
        } else {
            timestamp = new Date(0L);
        }
        return new AJAXRequestResult(list, timestamp, "resource");
    }
}

