/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.uuencode;

import com.openexchange.java.Charsets;
import com.openexchange.java.Streams;
import com.openexchange.mail.mime.datasource.StreamDataSource;
import com.openexchange.mail.uuencode.UUEncodedMultiPart;
import com.openexchange.tools.stream.UnsynchronizedByteArrayInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.MessagingException;
import javax.mail.internet.MimeUtility;
import org.slf4j.LoggerFactory;

public class UUEncodedPart
extends UUEncodedMultiPart {
    private final String sPossibleFileName;
    private final byte[] bodyPart;
    private final int startIndex;
    private final int endIndex;

    UUEncodedPart(int startIndex, int endIndex, String bodyPart, String filename) {
        this.startIndex = startIndex;
        this.endIndex = endIndex;
        this.bodyPart = Charsets.toAsciiBytes((String)bodyPart);
        this.sPossibleFileName = filename;
    }

    public String getFileName() {
        return this.sPossibleFileName;
    }

    public int getFileSize() {
        try {
            return this.bodyPart.length;
        }
        catch (NumberFormatException nfe) {
            return -1;
        }
    }

    public int getIndexStart() {
        return this.startIndex;
    }

    public int getIndexEnd() {
        return this.endIndex;
    }

    public InputStream getInputStream() {
        UnsynchronizedByteArrayInputStream bStream = new UnsynchronizedByteArrayInputStream(this.bodyPart);
        try {
            InputStream inStreamPart = MimeUtility.decode((InputStream)bStream, (String)"uuencode");
            return inStreamPart;
        }
        catch (Exception e) {
            LoggerFactory.getLogger(UUEncodedPart.class).error("", (Throwable)e);
            return null;
        }
    }

    public DataHandler getDataHandler(String contentType) {
        final byte[] data = this.bodyPart;
        StreamDataSource.InputStreamProvider isp = new StreamDataSource.InputStreamProvider(){

            @Override
            public InputStream getInputStream() throws IOException {
                try {
                    return MimeUtility.decode((InputStream)new UnsynchronizedByteArrayInputStream(data), (String)"uuencode");
                }
                catch (MessagingException e) {
                    IOException io = new IOException(e.getMessage());
                    io.initCause(e);
                    throw io;
                }
            }

            @Override
            public String getName() {
                return null;
            }
        };
        return new DataHandler((DataSource)new StreamDataSource(isp, contentType));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StringBuilder getPart() {
        StringBuilder encodedPart = new StringBuilder();
        try {
            BufferedReader br = null;
            try {
                br = new BufferedReader(new InputStreamReader(this.getInputStream()));
                String line = null;
                while ((line = br.readLine()) != null) {
                    encodedPart.append(line).append('\n');
                }
            }
            catch (Throwable throwable) {
                Streams.close(br);
                throw throwable;
            }
            Streams.close((Closeable)br);
        }
        catch (Exception e) {
            LoggerFactory.getLogger(UUEncodedPart.class).error("", (Throwable)e);
        }
        return encodedPart;
    }

    public void writeTo(OutputStream out) throws IOException {
        BufferedOutputStream bos = null;
        InputStream in = this.getInputStream();
        try {
            int iChar;
            bos = new BufferedOutputStream(out);
            while ((iChar = in.read()) != -1) {
                bos.write(iChar);
            }
        }
        catch (IOException ioe) {
            try {
                LoggerFactory.getLogger(UUEncodedPart.class).error("", (Throwable)ioe);
                throw ioe;
            }
            catch (Throwable throwable) {
                Streams.close(bos);
                throw throwable;
            }
        }
        Streams.close((Closeable)bos);
    }
}

