/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.transport;

import com.openexchange.json.io.Jsonable;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import javax.mail.Address;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class MtaStatusInfo
implements Jsonable {
    private final List<Address> sentAddresses = new LinkedList<Address>();
    private final List<Address> unsentAddresses = new LinkedList<Address>();
    private final List<Address> invalidAddresses = new LinkedList<Address>();
    private int returnCode;

    public Object toJson() throws IOException {
        try {
            JSONArray jAddresses;
            JSONObject jMtaInfo = new JSONObject(6);
            jMtaInfo.put("return_code", this.returnCode);
            int size = this.sentAddresses.size();
            if (size > 0) {
                jAddresses = new JSONArray(size);
                for (Address address : this.sentAddresses) {
                    jAddresses.put((Object)address.toString());
                }
                jMtaInfo.put("sent_addresses", (Object)jAddresses);
            }
            size = this.unsentAddresses.size();
            if (!this.unsentAddresses.isEmpty()) {
                jAddresses = new JSONArray(size);
                for (Address address : this.unsentAddresses) {
                    jAddresses.put((Object)address.toString());
                }
                jMtaInfo.put("unsent_addresses", (Object)jAddresses);
            }
            size = this.invalidAddresses.size();
            if (!this.invalidAddresses.isEmpty()) {
                jAddresses = new JSONArray(size);
                for (Address address : this.invalidAddresses) {
                    jAddresses.put((Object)address.toString());
                }
                jMtaInfo.put("invalid_addresses", (Object)jAddresses);
            }
            return jMtaInfo;
        }
        catch (JSONException e) {
            throw new IOException(e);
        }
    }

    public List<Address> getSentAddresses() {
        return this.sentAddresses;
    }

    public List<Address> getUnsentAddresses() {
        return this.unsentAddresses;
    }

    public List<Address> getInvalidAddresses() {
        return this.invalidAddresses;
    }

    public int getReturnCode() {
        return this.returnCode;
    }

    public void setReturnCode(int returnCode) {
        this.returnCode = returnCode;
    }
}

