/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.text;

import com.openexchange.ajax.AJAXUtility;
import com.openexchange.exception.OXException;
import com.openexchange.image.ImageLocation;
import com.openexchange.mail.MailPath;
import com.openexchange.mail.conversion.InlineImageDataSource;
import com.openexchange.mail.text.HtmlProcessing;
import com.openexchange.mail.text.ImageUriGenerator;
import com.openexchange.mail.utils.MailFolderUtility;
import com.openexchange.mailaccount.UnifiedInboxManagement;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;

public class DefaultImageUriGenerator
implements ImageUriGenerator {
    private static final String EVENT_RESTRICTIONS = "onmousedown=\"return false;\" oncontextmenu=\"return false;\"";
    private static final DefaultImageUriGenerator INSTANCE = new DefaultImageUriGenerator();

    public static DefaultImageUriGenerator getInstance() {
        return INSTANCE;
    }

    private DefaultImageUriGenerator() {
    }

    @Override
    public void generateImageUri(StringBuilder linkBuilder, String prefix, String optAppendix, String imageIdentifier, MailPath mailPath, Session session) throws OXException {
        String tmp;
        int unifiedINBOXAccountID;
        String mailId = mailPath.getMailID();
        if (mailId.indexOf(37) >= 0 && ((unifiedINBOXAccountID = ServerServiceRegistry.getInstance().getService(UnifiedInboxManagement.class).getUnifiedINBOXAccountID(session)) < 0 || mailPath.getAccountId() != unifiedINBOXAccountID) && (tmp = AJAXUtility.decodeUrl(mailId, null)).startsWith("default")) {
            try {
                mailId = new MailPath(tmp).getMailID();
            }
            catch (OXException e) {
                // empty catch block
            }
        }
        ImageLocation imageLocation = new ImageLocation.Builder(imageIdentifier).folder(MailFolderUtility.prepareFullname(mailPath.getAccountId(), mailPath.getFolder())).id(mailId).optImageHost(HtmlProcessing.imageHost()).build();
        InlineImageDataSource imgSource = InlineImageDataSource.getInstance();
        String imageURL = imgSource.generateUrl(imageLocation, session);
        linkBuilder.append(prefix).append('\"').append(imageURL).append('\"').append(" id=\"").append(imageIdentifier).append("\" ").append(EVENT_RESTRICTIONS);
        if (null != optAppendix) {
            linkBuilder.append(optAppendix);
        }
    }

    @Override
    public String getPlainImageUri(String imageIdentifier, MailPath mailPath, Session session) throws OXException {
        String tmp;
        int unifiedINBOXAccountID;
        String mailId = mailPath.getMailID();
        if (mailId.indexOf(37) >= 0 && ((unifiedINBOXAccountID = ServerServiceRegistry.getInstance().getService(UnifiedInboxManagement.class).getUnifiedINBOXAccountID(session)) < 0 || mailPath.getAccountId() != unifiedINBOXAccountID) && (tmp = AJAXUtility.decodeUrl(mailId, null)).startsWith("default")) {
            try {
                mailId = new MailPath(tmp).getMailID();
            }
            catch (OXException e) {
                // empty catch block
            }
        }
        ImageLocation imageLocation = new ImageLocation.Builder(imageIdentifier).folder(MailFolderUtility.prepareFullname(mailPath.getAccountId(), mailPath.getFolder())).id(mailId).optImageHost(HtmlProcessing.imageHost()).build();
        InlineImageDataSource imgSource = InlineImageDataSource.getInstance();
        return imgSource.generateUrl(imageLocation, session);
    }
}

