/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.search;

import com.openexchange.exception.OXException;
import com.openexchange.java.Strings;
import com.openexchange.mail.MailField;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.mime.utils.MimeMessageUtility;
import com.openexchange.mail.search.AbstractAddressTerm;
import com.openexchange.mail.search.SearchTermVisitor;
import com.openexchange.mail.utils.StorageUtility;
import java.util.Collection;
import javax.mail.FetchProfile;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.InternetAddress;
import javax.mail.search.RecipientStringTerm;
import javax.mail.search.SearchTerm;
import org.slf4j.LoggerFactory;

public final class ToTerm
extends AbstractAddressTerm {
    private static final long serialVersionUID = 116199790983674520L;

    public ToTerm(String pattern) {
        super(pattern);
    }

    @Override
    public void accept(SearchTermVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public String getPattern() {
        return this.addr;
    }

    @Override
    public void addMailField(Collection<MailField> col) {
        col.add(MailField.TO);
    }

    @Override
    public boolean matches(MailMessage mailMessage) {
        if (this.containsWildcard()) {
            return ToTerm.toRegex(this.addr).matcher(StorageUtility.getAllAddresses(mailMessage.getTo())).find();
        }
        return Strings.asciiLowerCase((String)StorageUtility.getAllAddresses(mailMessage.getTo())).indexOf(this.getLowerCaseAddr()) >= 0;
    }

    @Override
    public boolean matches(Message msg) throws OXException {
        try {
            String[] headers = msg.getHeader("To");
            if (null == headers || headers.length == 0) {
                return false;
            }
            InternetAddress[] addresses = MimeMessageUtility.parseAddressList(MimeMessageUtility.decodeMultiEncodedHeader(headers[0]), false, false);
            if (this.containsWildcard()) {
                return ToTerm.toRegex(this.addr).matcher(StorageUtility.getAllAddresses(addresses)).find();
            }
            return Strings.asciiLowerCase((String)StorageUtility.getAllAddresses(addresses)).indexOf(this.getLowerCaseAddr()) >= 0;
        }
        catch (MessagingException e) {
            LoggerFactory.getLogger(ToTerm.class).warn("Error during search.", (Throwable)e);
            return false;
        }
    }

    @Override
    public SearchTerm getJavaMailSearchTerm() {
        return new RecipientStringTerm(Message.RecipientType.TO, this.addr);
    }

    @Override
    public SearchTerm getNonWildcardJavaMailSearchTerm() {
        return new RecipientStringTerm(Message.RecipientType.TO, ToTerm.getNonWildcardPart(this.addr));
    }

    @Override
    public void contributeTo(FetchProfile fetchProfile) {
        if (!fetchProfile.contains(FetchProfile.Item.ENVELOPE)) {
            fetchProfile.add(FetchProfile.Item.ENVELOPE);
        }
    }

    @Override
    public boolean isAscii() {
        return ToTerm.isAscii(this.addr);
    }

    @Override
    public boolean containsWildcard() {
        return null == this.addr ? false : this.addr.indexOf(42) >= 0 || this.addr.indexOf(63) >= 0;
    }
}

