/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.search;

import com.openexchange.exception.OXException;
import com.openexchange.java.Strings;
import com.openexchange.mail.MailField;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.mime.utils.MimeMessageUtility;
import com.openexchange.mail.search.AbstractAddressTerm;
import com.openexchange.mail.search.SearchTermVisitor;
import com.openexchange.mail.utils.StorageUtility;
import java.util.Collection;
import javax.mail.FetchProfile;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.InternetAddress;
import javax.mail.search.RecipientStringTerm;
import javax.mail.search.SearchTerm;
import org.slf4j.LoggerFactory;

public final class CcTerm
extends AbstractAddressTerm {
    private static final long serialVersionUID = 4340549452409949555L;

    public CcTerm(String pattern) {
        super(pattern);
    }

    @Override
    public void accept(SearchTermVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public String getPattern() {
        return this.addr;
    }

    @Override
    public void addMailField(Collection<MailField> col) {
        col.add(MailField.CC);
    }

    @Override
    public boolean matches(MailMessage mailMessage) {
        if (this.containsWildcard()) {
            return CcTerm.toRegex(this.addr).matcher(StorageUtility.getAllAddresses(mailMessage.getCc())).find();
        }
        return Strings.asciiLowerCase((String)StorageUtility.getAllAddresses(mailMessage.getCc())).indexOf(this.getLowerCaseAddr()) >= 0;
    }

    @Override
    public boolean matches(Message msg) throws OXException {
        try {
            String[] headers = msg.getHeader("Cc");
            if (null == headers || headers.length == 0) {
                return false;
            }
            InternetAddress[] addresses = MimeMessageUtility.parseAddressList(MimeMessageUtility.decodeMultiEncodedHeader(headers[0]), false, false);
            if (this.containsWildcard()) {
                return CcTerm.toRegex(this.addr).matcher(StorageUtility.getAllAddresses(addresses)).find();
            }
            return Strings.asciiLowerCase((String)StorageUtility.getAllAddresses(addresses)).indexOf(this.getLowerCaseAddr()) >= 0;
        }
        catch (MessagingException e) {
            LoggerFactory.getLogger(CcTerm.class).warn("Error during search.", (Throwable)e);
            return false;
        }
    }

    @Override
    public SearchTerm getJavaMailSearchTerm() {
        return new RecipientStringTerm(Message.RecipientType.CC, this.addr);
    }

    @Override
    public SearchTerm getNonWildcardJavaMailSearchTerm() {
        return new RecipientStringTerm(Message.RecipientType.CC, CcTerm.getNonWildcardPart(this.addr));
    }

    @Override
    public void contributeTo(FetchProfile fetchProfile) {
        if (!fetchProfile.contains(FetchProfile.Item.ENVELOPE)) {
            fetchProfile.add(FetchProfile.Item.ENVELOPE);
        }
    }

    @Override
    public boolean isAscii() {
        return CcTerm.isAscii(this.addr);
    }

    @Override
    public boolean containsWildcard() {
        return null == this.addr ? false : this.addr.indexOf(42) >= 0 || this.addr.indexOf(63) >= 0;
    }
}

