/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.mime.converters;

import com.openexchange.java.Streams;
import com.openexchange.mail.mime.MimeCleanUp;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.SharedInputStream;
import javax.mail.util.SharedFileInputStream;

public class FileBackedMimeMessage
extends MimeMessage
implements MimeCleanUp {
    private File tempFile;
    private final Date receivedDate;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeToFile(InputStream in, File tempFile) throws IOException {
        FileOutputStream out = null;
        try {
            int read;
            out = new FileOutputStream(tempFile);
            int len = 8192;
            byte[] buf = new byte[len];
            while ((read = in.read(buf, 0, len)) > 0) {
                out.write(buf, 0, read);
            }
            out.flush();
        }
        catch (Throwable throwable) {
            Streams.close(out);
            throw throwable;
        }
        Streams.close((Closeable)out);
    }

    public FileBackedMimeMessage(Session session, File tempFile) throws MessagingException, IOException {
        this(session, tempFile, null);
    }

    public FileBackedMimeMessage(Session session, File tempFile, Date receivedDate) throws MessagingException, IOException {
        super(session, (InputStream)new SharedFileInputStream(tempFile));
        this.tempFile = tempFile;
        this.receivedDate = receivedDate;
    }

    public FileBackedMimeMessage(Session session, SharedInputStream sharedIn) throws MessagingException {
        this(session, sharedIn, null);
    }

    public FileBackedMimeMessage(Session session, SharedInputStream sharedIn, Date receivedDate) throws MessagingException {
        super(session, (InputStream)sharedIn);
        this.tempFile = null;
        this.receivedDate = receivedDate;
    }

    public Date getReceivedDate() throws MessagingException {
        return null == this.receivedDate ? super.getReceivedDate() : this.receivedDate;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.cleanUp();
    }

    public File getTempFile() {
        return this.tempFile;
    }

    @Override
    public final synchronized void cleanUp() {
        File tempFile = this.tempFile;
        if (null != tempFile) {
            tempFile.delete();
            this.tempFile = null;
        }
    }
}

