/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.json.converters;

import com.openexchange.ajax.container.Response;
import com.openexchange.ajax.helper.ParamContainer;
import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestDataTools;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.ajax.requesthandler.Converter;
import com.openexchange.ajax.requesthandler.ResultConverter;
import com.openexchange.exception.OXException;
import com.openexchange.java.Strings;
import com.openexchange.json.OXJSONWriter;
import com.openexchange.json.cache.JsonCacheService;
import com.openexchange.json.cache.JsonCaches;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.MailField;
import com.openexchange.mail.MailFields;
import com.openexchange.mail.MailJSONField;
import com.openexchange.mail.MailListField;
import com.openexchange.mail.MailServletInterface;
import com.openexchange.mail.config.MailProperties;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.dataobjects.ThreadedStructure;
import com.openexchange.mail.json.Column;
import com.openexchange.mail.json.MailActionConstants;
import com.openexchange.mail.json.MailRequest;
import com.openexchange.mail.json.MailRequestSha1Calculator;
import com.openexchange.mail.json.actions.AbstractMailAction;
import com.openexchange.mail.json.writer.MessageWriter;
import com.openexchange.mail.mime.MimeFilter;
import com.openexchange.mail.mime.MimeMailException;
import com.openexchange.mail.usersetting.UserSettingMail;
import com.openexchange.mail.utils.DisplayMode;
import com.openexchange.tools.TimeZoneUtils;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import com.openexchange.tools.session.ServerSession;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TimeZone;
import java.util.regex.Pattern;
import javax.mail.MessageRemovedException;
import javax.mail.MessagingException;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MailConverter
implements ResultConverter,
MailActionConstants {
    private static final Logger LOG = LoggerFactory.getLogger(MailConverter.class);
    private static final MailConverter INSTANCE = new MailConverter();
    private static final MessageWriter.MailFieldWriter[] WRITER_IDS = MessageWriter.getMailFieldWriters(new MailListField[]{MailListField.ID, MailListField.FOLDER_ID});
    private static final Pattern SPLIT = Pattern.compile(" *, *");

    public static MailConverter getInstance() {
        return INSTANCE;
    }

    private MailConverter() {
    }

    @Override
    public String getInputFormat() {
        return "mail";
    }

    @Override
    public String getOutputFormat() {
        return "apiResponse";
    }

    @Override
    public ResultConverter.Quality getQuality() {
        return ResultConverter.Quality.GOOD;
    }

    @Override
    public void convert(AJAXRequestData requestData, AJAXRequestResult result, ServerSession session, Converter converter) throws OXException {
        this.convert2JSON(requestData, result, session);
        Response response = new Response(session);
        response.setData(result.getResultObject());
        response.setTimestamp(result.getTimestamp());
        response.setProperties(result.getResponseProperties());
        Collection<OXException> warnings = result.getWarnings();
        if (null != warnings && !warnings.isEmpty()) {
            for (OXException warning : warnings) {
                response.addWarning(warning);
            }
        }
        result.setResultObject(response);
    }

    public void convert2JSON(AJAXRequestData requestData, AJAXRequestResult result, ServerSession session) throws OXException {
        try {
            Object resultObject = result.getResultObject();
            if (null == resultObject) {
                LOG.warn("Result object is null.");
                result.setResultObject(JSONObject.NULL, "json");
                return;
            }
            String action = requestData.getParameter("action");
            if (resultObject instanceof MailMessage) {
                MailMessage mail = (MailMessage)resultObject;
                if ("get".equals(action)) {
                    this.convertSingle4Get(mail, requestData, result, session);
                } else {
                    this.convertSingle(mail, requestData, result, session);
                }
            } else if (resultObject instanceof ThreadedStructure) {
                this.convertThreadStructure((ThreadedStructure)resultObject, requestData, result, session);
            } else {
                Collection mails = (Collection)resultObject;
                if ("all".equalsIgnoreCase(action)) {
                    this.convertMultiple4All(mails, requestData, result, session);
                } else if ("list".equalsIgnoreCase(action)) {
                    this.convertMultiple4List(mails, requestData, result, session);
                } else {
                    this.convertMultiple4List(mails, requestData, result, session);
                }
            }
        }
        catch (JSONException e) {
            throw AjaxExceptionCodes.JSON_ERROR.create(e, e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void convertThreadStructure(ThreadedStructure structure, AJAXRequestData requestData, AJAXRequestResult result, ServerSession session) throws OXException, JSONException {
        List<Column> columns = MailRequest.requireColumnsAndHeaders(requestData).getColumns();
        String tmp = requestData.getParameter("timezone");
        TimeZone timeZone = Strings.isEmpty((String)tmp) ? TimeZoneUtils.getTimeZone(session.getUser().getTimeZone()) : TimeZoneUtils.getTimeZone(tmp.trim());
        tmp = null;
        MailFields mailFields = new MailFields();
        ArrayList<MessageWriter.MailFieldWriter> writers = new ArrayList<MessageWriter.MailFieldWriter>(columns.size());
        for (Column column : columns) {
            MessageWriter.MailFieldWriter fieldWriter;
            if (column.getField() > 0) {
                fieldWriter = MessageWriter.getMailFieldWriter(MailListField.getField(column.getField()));
                MailField mailField = MailField.getField(column.getField());
                if (null != mailField) {
                    mailFields.add(mailField);
                }
            } else {
                fieldWriter = MessageWriter.getHeaderFieldWriter(column.getHeader());
            }
            writers.add(fieldWriter);
        }
        OXJSONWriter jsonWriter = new OXJSONWriter();
        boolean writeThreadAsObjects = !requestData.isSet("writeThreadAsObjects") || AJAXRequestDataTools.parseBoolParameter("writeThreadAsObjects", requestData);
        boolean containsMultipleFolders = MailConverter.containsMultipleFolders(structure, new HashSet<String>(2));
        jsonWriter.array();
        try {
            int userId = session.getUserId();
            int contextId = session.getContextId();
            for (List<MailMessage> mails : structure.getMails()) {
                if (mails == null || mails.isEmpty()) continue;
                JSONObject jo = new JSONObject(32);
                this.writeThreadSortedMail(mails, jo, writers, mailFields, containsMultipleFolders, writeThreadAsObjects, userId, contextId, timeZone);
                jsonWriter.value(jo);
            }
        }
        finally {
            jsonWriter.endArray();
        }
        JSONValue newJsonValue = jsonWriter.getObject();
        result.setResultObject(newJsonValue, "json");
        MailRequest req = new MailRequest(requestData, session);
        boolean cache = req.optBool("cache", false);
        if (cache) {
            JsonCacheService jsonCache = JsonCaches.getCache();
            MailRequestSha1Calculator sha1Calculator = (MailRequestSha1Calculator)req.getRequest().getProperty("mail.sha1calc");
            if (null != jsonCache && null != sha1Calculator) {
                String sha1Sum = sha1Calculator.getSha1For(req);
                String id = "com.openexchange.mail." + sha1Sum;
                JSONValue jsonValue = (JSONValue)requestData.getProperty(id);
                if (!JsonCaches.areEqual((JSONValue)jsonValue, (JSONValue)newJsonValue)) {
                    ServerSession ses = req.getSession();
                    if (null == jsonValue) {
                        jsonCache.setIfDifferent(id, newJsonValue, result.getDuration(), ses.getUserId(), ses.getContextId());
                    } else {
                        jsonCache.set(id, newJsonValue, result.getDuration(), ses.getUserId(), ses.getContextId());
                    }
                }
            }
        }
    }

    private static boolean containsMultipleFolders(ThreadedStructure structure, Set<String> fullNames) {
        for (List<MailMessage> mails : structure.getMails()) {
            for (MailMessage mailMessage : mails) {
                if (!fullNames.add(mailMessage.getFolder()) || fullNames.size() <= 1) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean writeThreadAsObjects() {
        return false;
    }

    private void writeThreadSortedMail(List<MailMessage> mails, JSONObject jMail, List<MessageWriter.MailFieldWriter> writers, MailFields mailFields, boolean containsMultipleFolders, boolean writeThreadAsObjects, int userId, int contextId, TimeZone optTimeZone) throws OXException, JSONException {
        MailMessage rootMessage = mails.get(0);
        int accountId = rootMessage.getAccountId();
        for (MessageWriter.MailFieldWriter writer : writers) {
            writer.writeField((JSONValue)jMail, rootMessage, 0, true, accountId, userId, contextId, optTimeZone);
        }
        int unreadCount = 0;
        JSONArray jChildMessages = new JSONArray(mails.size());
        if (writeThreadAsObjects) {
            for (MailMessage child : mails) {
                if (!this.seemsValid(child, mailFields)) continue;
                JSONObject jChild = new JSONObject(writers.size());
                accountId = child.getAccountId();
                for (MessageWriter.MailFieldWriter writer : writers) {
                    writer.writeField((JSONValue)jChild, child, 0, true, accountId, userId, contextId, optTimeZone);
                }
                jChildMessages.put((Object)jChild);
                if (child.isSeen()) continue;
                ++unreadCount;
            }
        } else if (containsMultipleFolders) {
            StringBuilder sb = new StringBuilder(16);
            char defaultSeparator = MailProperties.getInstance().getDefaultSeparator();
            for (MailMessage child : mails) {
                if (!this.seemsValid(child, mailFields)) continue;
                sb.setLength(0);
                jChildMessages.put((Object)sb.append(child.getFolder()).append(defaultSeparator).append(child.getMailId()).toString());
                if (child.isSeen()) continue;
                ++unreadCount;
            }
        } else {
            for (MailMessage child : mails) {
                if (!this.seemsValid(child, mailFields)) continue;
                jChildMessages.put((Object)child.getMailId());
                if (child.isSeen()) continue;
                ++unreadCount;
            }
        }
        jMail.put("thread", (Object)jChildMessages);
        jMail.put("unreadCount", unreadCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void convertMultiple4List(Collection<MailMessage> mails, AJAXRequestData requestData, AJAXRequestResult result, ServerSession session) throws OXException, JSONException {
        List<Column> columns = MailRequest.requireColumnsAndHeaders(requestData).getColumns();
        String tmp = requestData.getParameter("timezone");
        TimeZone timeZone = Strings.isEmpty((String)tmp) ? TimeZoneUtils.getTimeZone(session.getUser().getTimeZone()) : TimeZoneUtils.getTimeZone(tmp.trim());
        tmp = null;
        MailFields mailFields = new MailFields();
        ArrayList<MessageWriter.MailFieldWriter> writers = new ArrayList<MessageWriter.MailFieldWriter>(columns.size());
        for (Column column : columns) {
            MessageWriter.MailFieldWriter fieldWriter;
            if (column.getField() > 0) {
                fieldWriter = MessageWriter.getMailFieldWriter(MailListField.getField(column.getField()));
                MailField mailField = MailField.getField(column.getField());
                if (null != mailField) {
                    mailFields.add(mailField);
                }
            } else {
                fieldWriter = MessageWriter.getHeaderFieldWriter(column.getHeader());
            }
            writers.add(fieldWriter);
        }
        OXJSONWriter jsonWriter = new OXJSONWriter();
        jsonWriter.array();
        try {
            int userId = session.getUserId();
            int contextId = session.getContextId();
            for (MailMessage mail : mails) {
                if (!this.seemsValid(mail, mailFields)) continue;
                JSONArray ja = new JSONArray(writers.size());
                int accountId = mail.getAccountId();
                for (MessageWriter.MailFieldWriter writer : writers) {
                    writer.writeField((JSONValue)ja, mail, 0, false, accountId, userId, contextId, timeZone);
                }
                jsonWriter.value(ja);
            }
        }
        finally {
            jsonWriter.endArray();
        }
        result.setResultObject(jsonWriter.getObject(), "json");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void convertMultiple4All(Collection<MailMessage> mails, AJAXRequestData requestData, AJAXRequestResult result, ServerSession session) throws OXException, JSONException {
        List<Column> columns = MailRequest.requireColumnsAndHeaders(requestData).getColumns();
        String sort = requestData.getParameter("sort");
        String tmp = requestData.getParameter("timezone");
        TimeZone timeZone = Strings.isEmpty((String)tmp) ? TimeZoneUtils.getTimeZone(session.getUser().getTimeZone()) : TimeZoneUtils.getTimeZone(tmp.trim());
        tmp = null;
        this.getMailInterface(requestData, session);
        MailFields mailFields = new MailFields();
        ArrayList<MessageWriter.MailFieldWriter> writers = new ArrayList<MessageWriter.MailFieldWriter>(columns.size());
        for (Column column : columns) {
            MessageWriter.MailFieldWriter fieldWriter;
            if (column.getField() > 0) {
                fieldWriter = MessageWriter.getMailFieldWriter(MailListField.getField(column.getField()));
                MailField mailField = MailField.getField(column.getField());
                if (null != mailField) {
                    mailFields.add(mailField);
                }
            } else {
                fieldWriter = MessageWriter.getHeaderFieldWriter(column.getHeader());
            }
            writers.add(fieldWriter);
        }
        int userId = session.getUserId();
        int contextId = session.getContextId();
        OXJSONWriter jsonWriter = new OXJSONWriter();
        jsonWriter.array();
        try {
            int accountId;
            JSONArray ja;
            if ("thread".equalsIgnoreCase(sort)) {
                for (MailMessage mail : mails) {
                    if (!this.seemsValid(mail, mailFields)) continue;
                    ja = new JSONArray(writers.size());
                    accountId = mail.getAccountId();
                    for (MessageWriter.MailFieldWriter writer : writers) {
                        writer.writeField((JSONValue)ja, mail, mail.getThreadLevel(), false, accountId, userId, contextId, timeZone);
                    }
                    jsonWriter.value(ja);
                }
            } else {
                for (MailMessage mail : mails) {
                    if (!this.seemsValid(mail, mailFields)) continue;
                    ja = new JSONArray(writers.size());
                    accountId = mail.getAccountId();
                    for (MessageWriter.MailFieldWriter writer : writers) {
                        writer.writeField((JSONValue)ja, mail, 0, false, accountId, userId, contextId, timeZone);
                    }
                    jsonWriter.value(ja);
                }
            }
        }
        finally {
            jsonWriter.endArray();
        }
        JSONValue newJsonValue = jsonWriter.getObject();
        result.setResultObject(newJsonValue, "json");
        MailRequest req = new MailRequest(requestData, session);
        boolean cache = req.optBool("cache", false);
        if (cache) {
            JsonCacheService jsonCache = JsonCaches.getCache();
            MailRequestSha1Calculator sha1Calculator = (MailRequestSha1Calculator)req.getRequest().getProperty("mail.sha1calc");
            if (null != jsonCache && null != sha1Calculator) {
                String sha1Sum = sha1Calculator.getSha1For(req);
                String id = "com.openexchange.mail." + sha1Sum;
                JSONValue jsonValue = (JSONValue)requestData.getProperty(id);
                if (!JsonCaches.areEqual((JSONValue)jsonValue, (JSONValue)newJsonValue)) {
                    ServerSession ses = req.getSession();
                    if (null == jsonValue) {
                        jsonCache.setIfDifferent(id, newJsonValue, result.getDuration(), ses.getUserId(), ses.getContextId());
                    } else {
                        jsonCache.set(id, newJsonValue, result.getDuration(), ses.getUserId(), ses.getContextId());
                    }
                }
            }
        }
    }

    private void convertSingle4Get(MailMessage mail, AJAXRequestData requestData, AJAXRequestResult result, ServerSession session) throws OXException {
        JSONObject jMail = this.convertSingle4Get(mail, ParamContainer.getInstance(requestData), session, this.getMailInterface(requestData, session));
        if (null == jMail) {
            result.setResultObject(null, "native");
            result.setType(AJAXRequestResult.ResultType.DIRECT);
        } else {
            result.setResultObject(jMail, "json");
        }
    }

    public JSONObject convertSingle4Get(MailMessage mail, ParamContainer paramContainer, ServerSession session, MailServletInterface mailInterface) throws OXException {
        HttpServletResponse resp;
        JSONObject jMail;
        boolean doUnseen;
        MimeFilter mimeFilter;
        int ttlMillis;
        String tmp = paramContainer.getStringParam("edit");
        boolean editDraft = "1".equals(tmp) || Boolean.parseBoolean(tmp);
        tmp = paramContainer.getStringParam("view");
        String view = null == tmp ? null : tmp.toLowerCase(Locale.ENGLISH);
        tmp = paramContainer.getStringParam("unseen");
        boolean unseen = tmp != null && ("1".equals(tmp) || Boolean.parseBoolean(tmp));
        tmp = paramContainer.getStringParam("timezone");
        TimeZone timeZone = Strings.isEmpty((String)tmp) ? TimeZoneUtils.getTimeZone(session.getUser().getTimeZone()) : TimeZoneUtils.getTimeZone(tmp.trim());
        tmp = paramContainer.getStringParam("token");
        boolean token = tmp != null && ("1".equals(tmp) || Boolean.parseBoolean(tmp));
        tmp = paramContainer.getStringParam("ttlMillis");
        try {
            ttlMillis = tmp == null ? -1 : Integer.parseInt(tmp.trim());
        }
        catch (NumberFormatException e) {
            ttlMillis = -1;
        }
        tmp = paramContainer.getStringParam("embedded");
        boolean embedded = tmp != null && ("1".equals(tmp) || Boolean.parseBoolean(tmp));
        tmp = paramContainer.getStringParam("ignorable");
        if (Strings.isEmpty((String)tmp)) {
            mimeFilter = null;
        } else {
            MimeFilter mf;
            String[] strings = SPLIT.split(tmp, 0);
            int length = strings.length;
            if (1 == length && (mf = MimeFilter.filterFor(strings[0])) != null) {
                mimeFilter = mf;
            } else {
                ArrayList<String> ignorableContentTypes = new ArrayList<String>(length);
                for (int i = 0; i < length; ++i) {
                    String cts = strings[i];
                    if ("ics".equalsIgnoreCase(cts)) {
                        ignorableContentTypes.add("text/calendar");
                        ignorableContentTypes.add("application/ics");
                        continue;
                    }
                    ignorableContentTypes.add(cts);
                }
                mimeFilter = MimeFilter.filterFor(ignorableContentTypes);
            }
        }
        tmp = null;
        UserSettingMail usmNoSave = session.getUserSettingMail().clone();
        usmNoSave.setNoSave(true);
        DisplayMode displayMode = AbstractMailAction.detectDisplayMode(editDraft, view, usmNoSave);
        String folderPath = paramContainer.checkStringParam("folder");
        boolean wasUnseen = mail.containsPrevSeen() && !mail.isPrevSeen();
        boolean bl = doUnseen = unseen && wasUnseen;
        if (doUnseen) {
            mail.setFlag(32, false);
            int unreadMsgs = mail.getUnreadMessages();
            mail.setUnreadMessages(unreadMsgs < 0 ? 0 : unreadMsgs + 1);
        }
        ArrayList<OXException> warnings = new ArrayList<OXException>(2);
        int maxContentSize = AJAXRequestDataTools.parseIntParameter(paramContainer.getStringParam("max_size"), -1);
        String str = paramContainer.getStringParam("allow_nested_messages");
        boolean allowNestedMessages = null == str ? true : AJAXRequestDataTools.parseBoolParameter(str);
        boolean exactLength = AJAXRequestDataTools.parseBoolParameter(paramContainer.getStringParam("exact_length"));
        try {
            jMail = MessageWriter.writeMailMessage(mail.getAccountId(), mail, displayMode, embedded, session, usmNoSave, warnings, token, ttlMillis, mimeFilter, timeZone, exactLength, maxContentSize, allowNestedMessages ? -1 : 1);
        }
        catch (OXException e) {
            if (MailExceptionCode.MESSAGING_ERROR.equals(e)) {
                Throwable cause = e.getCause();
                if (cause instanceof MessageRemovedException) {
                    throw MailExceptionCode.MAIL_NOT_FOUND.create(cause, mail.getMailId(), mail.getFolder());
                }
                if (cause instanceof MessagingException) {
                    throw MimeMailException.handleMessagingException((MessagingException)cause, null, session);
                }
            } else if (MailExceptionCode.MAIL_NOT_FOUND.equals(e) || MailExceptionCode.MAIL_NOT_FOUND_SIMPLE.equals(e)) {
                LOG.warn("Requested mail could not be found  (folder={}, id={}, user={}, context={}). Most likely this is caused by concurrent access of multiple clients while one performed a delete on affected mail.", new Object[]{paramContainer.getStringParam("folder"), paramContainer.getStringParam("id"), session.getUserId(), session.getContextId(), e});
            }
            throw e;
        }
        if (mail.containsPrevSeen()) {
            try {
                jMail.put("unseen", wasUnseen);
            }
            catch (JSONException e) {
                LOG.warn("Couldn't set \"unseen\" field in JSON mail representation.", (Throwable)e);
            }
        }
        if (DisplayMode.DOCUMENT.isIncluded(displayMode) && (resp = paramContainer.getHttpServletResponse()) != null) {
            try {
                String htmlContent = jMail.getJSONArray(MailJSONField.ATTACHMENTS.getKey()).getJSONObject(0).getString(MailJSONField.CONTENT.getKey());
                resp.setContentType("text/html; charset=UTF-8");
                resp.setHeader("Content-Disposition", "inline");
                PrintWriter writer = resp.getWriter();
                writer.write(htmlContent);
                writer.flush();
                jMail = null;
            }
            catch (JSONException e) {
                throw AjaxExceptionCodes.JSON_ERROR.create(e, e.getMessage());
            }
            catch (IOException e) {
                throw AjaxExceptionCodes.IO_ERROR.create(e, e.getMessage());
            }
        }
        if (doUnseen) {
            String uid;
            String tmp2 = paramContainer.getStringParam("id");
            if (null == tmp2) {
                tmp2 = paramContainer.getStringParam("message_id");
                if (null == tmp2) {
                    throw AjaxExceptionCodes.MISSING_PARAMETER.create("id");
                }
                uid = mailInterface.getMailIDByMessageID(folderPath, tmp2);
            } else {
                uid = tmp2;
            }
            mailInterface.updateMessageFlags(folderPath, new String[]{uid}, 32, false);
        }
        return jMail;
    }

    private void convertSingle(MailMessage mail, AJAXRequestData requestData, AJAXRequestResult result, ServerSession session) throws OXException {
        String view = requestData.getParameter("view");
        view = null == view ? null : view.toLowerCase(Locale.US);
        String tmp = requestData.getParameter("embedded");
        boolean embedded = tmp != null && ("1".equals(tmp) || Boolean.parseBoolean(tmp));
        tmp = null;
        UserSettingMail usmNoSave = session.getUserSettingMail().clone();
        usmNoSave.setNoSave(true);
        DisplayMode displayMode = AbstractMailAction.detectDisplayMode(true, view, usmNoSave);
        int maxContentSize = AJAXRequestDataTools.parseIntParameter(requestData.getParameter("max_size"), -1);
        boolean allowNestedMessages = AJAXRequestDataTools.parseBoolParameter("allow_nested_messages", requestData, true);
        ArrayList<OXException> warnings = new ArrayList<OXException>(2);
        JSONObject jsonObject = MessageWriter.writeMailMessage(mail.getAccountId(), mail, displayMode, embedded, session, usmNoSave, warnings, false, -1, null, null, false, maxContentSize, allowNestedMessages ? -1 : 1);
        String csid = (String)result.getParameter("csid");
        if (null != csid) {
            try {
                jsonObject.put("csid", (Object)csid);
            }
            catch (JSONException e) {
                throw AjaxExceptionCodes.JSON_ERROR.create(e, e.getMessage());
            }
        }
        result.addWarnings(warnings);
        result.setResultObject(jsonObject, "json");
    }

    private MailServletInterface getMailInterface(AJAXRequestData request, ServerSession session) throws OXException {
        MailServletInterface mailInterface = (MailServletInterface)request.getState().optProperty("com.openexchange.mail.json.mailInterface");
        if (mailInterface == null) {
            MailServletInterface newMailInterface = MailServletInterface.getInstance(session);
            mailInterface = request.getState().putProperty("com.openexchange.mail.json.mailInterface", newMailInterface);
            if (null == mailInterface) {
                mailInterface = newMailInterface;
            } else {
                newMailInterface.close(true);
            }
        }
        return mailInterface;
    }

    private boolean seemsValid(MailMessage mail, MailFields mailFields) {
        if (null == mail) {
            return false;
        }
        boolean valid = true;
        if (mailFields.contains(MailField.SUBJECT)) {
            if (mail.containsSubject()) {
                return true;
            }
            valid = false;
        }
        if (mailFields.contains(MailField.FROM)) {
            if (mail.containsFrom()) {
                return true;
            }
            valid = false;
        }
        if (mailFields.contains(MailField.TO)) {
            if (mail.containsTo()) {
                return true;
            }
            valid = false;
        }
        if (mailFields.contains(MailField.SIZE)) {
            if (mail.containsSize()) {
                return true;
            }
            valid = false;
        }
        if (mailFields.contains(MailField.SENT_DATE)) {
            if (mail.containsSentDate()) {
                return true;
            }
            valid = false;
        }
        return valid;
    }
}

