/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.json.actions;

import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.documentation.RequestMethod;
import com.openexchange.documentation.annotations.Action;
import com.openexchange.documentation.annotations.Parameter;
import com.openexchange.exception.OXException;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.MailServletInterface;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.dataobjects.compose.ComposeType;
import com.openexchange.mail.dataobjects.compose.ContentAwareComposedMailMessage;
import com.openexchange.mail.json.MailRequest;
import com.openexchange.mail.json.actions.AbstractMailAction;
import com.openexchange.mail.mime.MimeMailException;
import com.openexchange.mail.mime.converters.MimeMessageConverter;
import com.openexchange.mail.mime.dataobjects.MimeMailMessage;
import com.openexchange.mail.mime.utils.MimeMessageUtility;
import com.openexchange.mail.transport.MailTransport;
import com.openexchange.mail.usersetting.UserSettingMail;
import com.openexchange.server.ServiceLookup;
import com.openexchange.session.Session;
import com.openexchange.tools.session.ServerSession;
import java.util.ArrayList;
import javax.mail.IllegalWriteException;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Action(method=RequestMethod.GET, name="bounce", description="Bounces a mail.", parameters={@Parameter(name="session", description="A session ID previously obtained from the login module."), @Parameter(name="id", description="Object ID of the requested Message."), @Parameter(name="folder", description="Object ID of the folder, whose contents are queried."), @Parameter(name="view", optional=true, description="(available with SP6) - \"text\" forces the server to deliver a text-only version of the requested mail's body, even if content is HTML. \"html\" to allow a possible HTML mail body being transferred as it is (but white-list filter applied).NOTE: if set, the corresponding gui config setting will be ignored.")}, responseDescription="(not IMAP: with timestamp): An object containing all data of the requested mail. The fields of the object are listed in Detailed mail data. The fields id and attachment are not included.")
public final class BounceAction
extends AbstractMailAction {
    private static final Logger LOG = LoggerFactory.getLogger(BounceAction.class);

    public BounceAction(ServiceLookup services) {
        super(services);
    }

    @Override
    protected AJAXRequestResult perform(MailRequest req) throws OXException, JSONException {
        JSONArray paths = (JSONArray)req.getRequest().getData();
        if (null == paths) {
            return new AJAXRequestResult((Object)this.performBounce(req, req.checkParameter("folder"), req.checkParameter("id")), "mail");
        }
        int length = paths.length();
        ArrayList<MailMessage> ret = new ArrayList<MailMessage>(length);
        for (int i = 0; i < length; ++i) {
            JSONObject jo = paths.getJSONObject(i);
            ret.add(this.performBounce(req, jo.getString("folder"), jo.getString("id")));
        }
        return new AJAXRequestResult(ret, "mail");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private MailMessage performBounce(MailRequest req, String folderPath, String uid) throws OXException {
        try {
            MailServletInterface mailInterface;
            MailMessage message;
            ServerSession session = req.getSession();
            String view = req.getParameter("view");
            UserSettingMail usmNoSave = session.getUserSettingMail().clone();
            usmNoSave.setNoSave(true);
            BounceAction.detectDisplayMode(true, view, usmNoSave);
            if (Boolean.parseBoolean(req.getParameter("dropPrefix"))) {
                usmNoSave.setDropReplyForwardPrefix(true);
            }
            if (null == (message = (mailInterface = this.getMailInterface(req)).getMessage(folderPath, uid, false))) {
                throw MailExceptionCode.MAIL_NOT_FOUND.create(uid, folderPath);
            }
            try (MailTransport transport = MailTransport.getInstance(session, mailInterface.getAccountID());){
                MimeMessage mimeMessage;
                if (message instanceof MimeMailMessage) {
                    MimeMessage mm = ((MimeMailMessage)message).getMimeMessage();
                    boolean readOnly = false;
                    try {
                        mm.setHeader("X-Ignore", "Ignore");
                        mm.removeHeader("X-Ignore");
                    }
                    catch (IllegalWriteException e) {
                        readOnly = true;
                    }
                    catch (MessagingException e) {
                        throw MimeMailException.handleMessagingException(e);
                    }
                    mimeMessage = readOnly ? MimeMessageUtility.mimeMessageFrom((Message)mm) : mm;
                } else {
                    mimeMessage = (MimeMessage)MimeMessageConverter.convertMailMessage(message, false);
                }
                mimeMessage.setHeader("Reply-To", session.getUser().getMail());
                MailMessage sentMail = transport.sendMailMessage(new ContentAwareComposedMailMessage(mimeMessage, (Session)session, null), ComposeType.NEW);
                if (!sentMail.containsAccountId()) {
                    sentMail.setAccountId(mailInterface.getAccountID());
                }
                MailMessage mailMessage = sentMail;
                return mailMessage;
            }
        }
        catch (RuntimeException e) {
            throw MailExceptionCode.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
    }
}

