/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.tasks;

import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.PerformParameters;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTaskAdapter;
import com.openexchange.groupware.update.tasks.UnifiedINBOXRenamerTask;
import com.openexchange.tools.sql.DBUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class DropDuplicateEntryFromUpdateTaskTable
extends UpdateTaskAdapter {
    @Override
    public void perform(PerformParameters params) throws OXException {
        Connection con = Database.getNoTimeout(params.getContextId(), true);
        boolean rb = false;
        try {
            DBUtils.startTransaction(con);
            rb = true;
            this.checkNamingForUnifiedMailRenamerTask(con);
            con.commit();
            rb = false;
        }
        catch (SQLException e) {
            throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
        }
        catch (RuntimeException e) {
            throw UpdateExceptionCodes.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
        finally {
            if (rb) {
                DBUtils.rollback(con);
            }
            DBUtils.autocommit(con);
            Database.backNoTimeout(params.getContextId(), true, con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkNamingForUnifiedMailRenamerTask(Connection con) throws SQLException {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.createStatement();
            rs = stmt.executeQuery("SELECT 1 FROM updateTask WHERE BINARY taskName='com.openexchange.groupware.update.tasks.UnifiedInboxRenamerTask'");
            boolean wrongEntryExists = rs.next();
            DBUtils.closeSQLStuff(rs, stmt);
            rs = null;
            stmt = null;
            stmt = con.createStatement();
            rs = stmt.executeQuery("SELECT 1 FROM updateTask WHERE BINARY taskName='com.openexchange.groupware.update.tasks.UnifiedINBOXRenamerTask'");
            boolean correctEntryExists = rs.next();
            DBUtils.closeSQLStuff(rs, stmt);
            rs = null;
            stmt = null;
            if (correctEntryExists) {
                if (wrongEntryExists) {
                    stmt = con.createStatement();
                    stmt.execute("DELETE FROM updateTask WHERE BINARY taskName='com.openexchange.groupware.update.tasks.UnifiedInboxRenamerTask'");
                    DBUtils.closeSQLStuff(stmt);
                    stmt = null;
                }
            } else if (wrongEntryExists) {
                stmt = con.createStatement();
                stmt.execute("UPDATE updateTask SET taskName='com.openexchange.groupware.update.tasks.UnifiedINBOXRenamerTask' WHERE BINARY taskName='com.openexchange.groupware.update.tasks.UnifiedInboxRenamerTask'");
                DBUtils.closeSQLStuff(stmt);
                stmt = null;
            }
        }
        catch (Throwable throwable) {
            DBUtils.closeSQLStuff(rs, stmt);
            throw throwable;
        }
        DBUtils.closeSQLStuff(rs, stmt);
    }

    @Override
    public String[] getDependencies() {
        return new String[]{UnifiedINBOXRenamerTask.class.getName()};
    }
}

