/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.tasks;

import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.PerformParameters;
import com.openexchange.groupware.update.ProgressState;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTaskAdapter;
import com.openexchange.java.util.UUIDs;
import com.openexchange.tools.sql.DBUtils;
import com.openexchange.tools.update.Column;
import com.openexchange.tools.update.Tools;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.UUID;

public class AddUUIDForUpdateTaskTable
extends UpdateTaskAdapter {
    @Override
    public void perform(PerformParameters params) throws OXException {
        int ctxId = params.getContextId();
        ProgressState progress = params.getProgressState();
        Connection con = Database.getNoTimeout(ctxId, true);
        try {
            DBUtils.startTransaction(con);
            progress.setTotal(AddUUIDForUpdateTaskTable.getTotalRows(con));
            if (!Tools.columnExists(con, "updateTask", "uuid")) {
                Tools.addColumns(con, "updateTask", new Column("uuid", "BINARY(16) DEFAULT NULL"));
                AddUUIDForUpdateTaskTable.fillUUIDs(con, progress);
            }
            con.commit();
        }
        catch (SQLException e) {
            DBUtils.rollback(con);
            throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
        }
        catch (RuntimeException e) {
            DBUtils.rollback(con);
            throw UpdateExceptionCodes.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
        finally {
            DBUtils.autocommit(con);
            Database.backNoTimeout(ctxId, true, con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fillUUIDs(Connection con, ProgressState progress) throws SQLException {
        Statement stmt1 = null;
        ResultSet result = null;
        PreparedStatement stmt2 = null;
        try {
            stmt1 = con.createStatement();
            result = stmt1.executeQuery("SELECT cid, taskName FROM updateTask WHERE uuid IS NULL");
            stmt2 = con.prepareStatement("UPDATE updateTask SET uuid=? WHERE cid=? AND taskName=?");
            while (result.next()) {
                int cid = result.getInt(1);
                String taskName = result.getString(2);
                stmt2.setBytes(1, UUIDs.toByteArray((UUID)UUID.randomUUID()));
                stmt2.setInt(2, cid);
                stmt2.setString(3, taskName);
                stmt2.addBatch();
                progress.incrementState();
            }
            stmt2.executeBatch();
        }
        catch (Throwable throwable) {
            DBUtils.closeSQLStuff(result, stmt1);
            DBUtils.closeSQLStuff(stmt2);
            throw throwable;
        }
        DBUtils.closeSQLStuff(result, stmt1);
        DBUtils.closeSQLStuff(stmt2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getTotalRows(Connection con) throws SQLException {
        Statement stmt = null;
        ResultSet rs = null;
        int rows = 0;
        try {
            stmt = con.createStatement();
            rs = stmt.executeQuery("SELECT COUNT(taskName) FROM updateTask");
            while (rs.next()) {
                rows += rs.getInt(1);
            }
        }
        catch (Throwable throwable) {
            DBUtils.closeSQLStuff(rs, stmt);
            throw throwable;
        }
        DBUtils.closeSQLStuff(rs, stmt);
        return rows;
    }

    @Override
    public String[] getDependencies() {
        return new String[0];
    }
}

