/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.osgi;

import com.openexchange.groupware.update.UpdateTaskProviderService;
import com.openexchange.groupware.update.UpdateTaskV2;
import com.openexchange.groupware.update.internal.DynamicList;
import java.util.Collection;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UpdateTaskCustomizer
implements ServiceTrackerCustomizer<UpdateTaskProviderService, UpdateTaskProviderService> {
    private static final Logger LOG = LoggerFactory.getLogger(UpdateTaskCustomizer.class);
    private final BundleContext context;

    public UpdateTaskCustomizer(BundleContext context) {
        this.context = context;
    }

    public UpdateTaskProviderService addingService(ServiceReference<UpdateTaskProviderService> reference) {
        UpdateTaskProviderService providerService = (UpdateTaskProviderService)this.context.getService(reference);
        DynamicList registry = DynamicList.getInstance();
        Collection<? extends UpdateTaskV2> collection = providerService.getUpdateTasks();
        boolean error = false;
        for (UpdateTaskV2 updateTaskV2 : collection) {
            if (registry.addUpdateTask(updateTaskV2)) continue;
            LOG.error("Update task \"{}\" could not be registered.", (Object)updateTaskV2.getClass().getName(), (Object)new Exception());
            error = true;
            break;
        }
        if (!error) {
            return providerService;
        }
        for (UpdateTaskV2 updateTaskV2 : collection) {
            registry.removeUpdateTask(updateTaskV2);
        }
        this.context.ungetService(reference);
        return null;
    }

    public void modifiedService(ServiceReference<UpdateTaskProviderService> reference, UpdateTaskProviderService service) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removedService(ServiceReference<UpdateTaskProviderService> reference, UpdateTaskProviderService service) {
        if (null != service) {
            try {
                DynamicList registry = DynamicList.getInstance();
                UpdateTaskProviderService providerService = service;
                Collection<? extends UpdateTaskV2> collection = providerService.getUpdateTasks();
                for (UpdateTaskV2 updateTaskV2 : collection) {
                    registry.removeUpdateTask(updateTaskV2);
                }
            }
            finally {
                this.context.ungetService(reference);
            }
        }
    }
}

