/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update;

import com.openexchange.caching.CacheService;
import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.update.ExecutedTask;
import com.openexchange.groupware.update.Schema;
import com.openexchange.groupware.update.SchemaUpdateState;
import com.openexchange.groupware.update.internal.SchemaExceptionCodes;
import com.openexchange.groupware.update.internal.SchemaStoreImpl;
import com.openexchange.tools.sql.DBUtils;
import java.sql.Connection;
import java.sql.SQLException;

public abstract class SchemaStore {
    private static final SchemaStoreImpl SINGLETON = new SchemaStoreImpl();

    protected SchemaStore() {
    }

    public static SchemaStore getInstance() {
        return SINGLETON;
    }

    protected abstract SchemaUpdateState getSchema(int var1, String var2, Connection var3) throws OXException;

    public abstract void lockSchema(Schema var1, int var2, boolean var3) throws OXException;

    public abstract void unlockSchema(Schema var1, int var2, boolean var3) throws OXException;

    public final Schema getSchema(Context ctx) throws OXException {
        return this.getSchema(ctx.getContextId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final SchemaUpdateState getSchema(int contextId) throws OXException {
        Connection con = Database.get(contextId, true);
        try {
            SchemaUpdateState schemaUpdateState = this.getSchema(Database.resolvePool(contextId, true), Database.getSchema(contextId), con);
            return schemaUpdateState;
        }
        finally {
            Database.backAfterReading(contextId, con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final SchemaUpdateState getSchema(int poolId, String schemaName) throws OXException {
        Connection con = Database.get(poolId, schemaName);
        try {
            SchemaUpdateState schemaUpdateState = this.getSchema(poolId, schemaName, con);
            return schemaUpdateState;
        }
        finally {
            Database.back(poolId, con);
        }
    }

    public abstract ExecutedTask[] getExecutedTasks(int var1, String var2) throws OXException;

    public final void addExecutedTask(int contextId, String taskName, boolean success, int poolId, String schema) throws OXException {
        Connection con = Database.get(contextId, true);
        try {
            con.setAutoCommit(false);
            this.addExecutedTask(con, taskName, success, poolId, schema);
            con.commit();
        }
        catch (SQLException e) {
            DBUtils.rollback(con);
            throw SchemaExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
        }
        catch (OXException e) {
            DBUtils.rollback(con);
            throw e;
        }
        finally {
            DBUtils.autocommit(con);
            Database.back(contextId, true, con);
        }
    }

    public abstract void addExecutedTask(Connection var1, String var2, boolean var3, int var4, String var5) throws OXException;

    public abstract void setCacheService(CacheService var1);

    public abstract void removeCacheService();
}

