/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.infostore.facade.impl;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.infostore.DocumentMetadata;
import com.openexchange.groupware.infostore.facade.impl.MetadataLoader;
import com.openexchange.groupware.infostore.webdav.EntityLockManager;
import com.openexchange.groupware.infostore.webdav.Lock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class LockedUntilLoader
extends MetadataLoader<List<Lock>> {
    private final EntityLockManager lockManager;

    public LockedUntilLoader(EntityLockManager lockManager) {
        this.lockManager = lockManager;
    }

    @Override
    protected DocumentMetadata set(DocumentMetadata document, List<Lock> metadata) {
        if (null != metadata && 0 < metadata.size()) {
            long maximumTimeout = 0L;
            for (Lock lock : metadata) {
                maximumTimeout = Math.max(maximumTimeout, lock.getTimeout());
            }
            document.setLockedUntil(new Date(System.currentTimeMillis() + maximumTimeout));
        }
        return document;
    }

    @Override
    public Map<Integer, List<Lock>> load(Collection<Integer> ids, Context context) throws OXException {
        if (null == ids || 0 == ids.size()) {
            return Collections.emptyMap();
        }
        return this.lockManager.findLocks(new ArrayList<Integer>(ids), context);
    }
}

