/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.infostore.database.impl;

import com.openexchange.database.DBPoolingExceptionCodes;
import com.openexchange.database.Databases;
import com.openexchange.database.provider.DBProvider;
import com.openexchange.database.tx.AbstractDBAction;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.infostore.DocumentMetadata;
import com.openexchange.groupware.infostore.InfostoreExceptionCodes;
import com.openexchange.groupware.infostore.database.impl.AbstractDocumentListAction;
import com.openexchange.groupware.infostore.database.impl.InfostoreQueryCatalog;
import com.openexchange.java.Autoboxing;
import com.openexchange.session.Session;
import java.sql.SQLException;
import java.util.List;

public class CreateVersionAction
extends AbstractDocumentListAction {
    public CreateVersionAction(Session session) {
        super(session);
    }

    public CreateVersionAction(DBProvider provider, InfostoreQueryCatalog queryCatalog, Context context, List<DocumentMetadata> versions, Session session) {
        super(provider, queryCatalog, context, versions, session);
    }

    protected void undoAction() throws OXException {
        AbstractDBAction.Update update = new AbstractDBAction.Update(this.getQueryCatalog().getVersionDelete(InfostoreQueryCatalog.Table.INFOSTORE_DOCUMENT, this.getDocuments())){

            @Override
            public void fillStatement() throws SQLException {
                this.stmt.setInt(1, CreateVersionAction.this.getContext().getContextId());
            }
        };
        this.doUpdates(update);
    }

    public void perform() throws OXException {
        this.assureExistence();
        List<DocumentMetadata> documents = this.getDocuments();
        try {
            InfostoreQueryCatalog queryCatalog = this.getQueryCatalog();
            this.doUpdates(queryCatalog.getVersionInsert(), queryCatalog.getWritableVersionFields(), documents);
        }
        catch (OXException e) {
            if (!DBPoolingExceptionCodes.SQL_ERROR.equals(e) || !(e.getCause() instanceof SQLException)) {
                throw e;
            }
            SQLException sqle = (SQLException)e.getCause();
            if (Databases.isPrimaryKeyConflictInMySQL((SQLException)sqle)) {
                DocumentMetadata document = documents.get(0);
                throw InfostoreExceptionCodes.CONCURRENT_VERSION_CREATION.create(sqle, document.getVersion(), document.getId());
            }
            throw e;
        }
    }

    @Override
    protected Object[] getAdditionals(DocumentMetadata doc) {
        return new Object[]{Autoboxing.I((int)this.getContext().getContextId())};
    }
}

