/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.infostore.database.impl;

import com.openexchange.database.provider.DBProvider;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.infostore.DocumentMetadata;
import com.openexchange.groupware.infostore.InfostoreExceptionCodes;
import com.openexchange.groupware.infostore.database.impl.InfostoreQueryCatalog;
import com.openexchange.groupware.infostore.utils.GetSwitch;
import com.openexchange.groupware.infostore.utils.Metadata;
import com.openexchange.java.Charsets;
import com.openexchange.tools.exceptions.SimpleTruncatedAttribute;
import com.openexchange.tools.sql.DBUtils;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckSizeSwitch {
    private static final Logger LOG = LoggerFactory.getLogger(CheckSizeSwitch.class);
    private static Map<Metadata, Integer> SIZES = new HashMap<Metadata, Integer>();
    private final DBProvider provider;
    private final Context ctx;
    private static final Set<Metadata> FIELDS_TO_CHECK = new HashSet<Metadata>(){
        {
            this.add(Metadata.CATEGORIES_LITERAL);
            this.add(Metadata.FILE_MIMETYPE_LITERAL);
            this.add(Metadata.FILENAME_LITERAL);
            this.add(Metadata.URL_LITERAL);
            this.add(Metadata.DESCRIPTION_LITERAL);
            this.add(Metadata.TITLE_LITERAL);
            this.add(Metadata.VERSION_COMMENT_LITERAL);
        }
    };

    public CheckSizeSwitch(DBProvider provider, Context ctx) {
        this.provider = provider;
        this.ctx = ctx;
    }

    public static void checkSizes(DocumentMetadata metadata, DBProvider provider, Context ctx) throws OXException {
        CheckSizeSwitch checkSize = new CheckSizeSwitch(provider, ctx);
        GetSwitch get = new GetSwitch(metadata);
        for (Metadata m : Metadata.VALUES) {
            int valueLength;
            if (!FIELDS_TO_CHECK.contains(m)) continue;
            Object value = m.doSwitch(get);
            int maxSize = checkSize.getSize(m);
            if (maxSize >= (valueLength = value instanceof String ? Charsets.getBytes((String)((String)value), (Charset)Charsets.UTF_8).length : 0)) continue;
            OXException x = InfostoreExceptionCodes.TOO_LONG_VALUES.create();
            x.addProblematic((OXException.ProblematicAttribute)new SimpleTruncatedAttribute(m.getId(), maxSize, valueLength));
            throw x;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSize(Metadata field) {
        if (SIZES.containsKey(field)) {
            return SIZES.get(field);
        }
        Connection con = null;
        try {
            con = this.provider.getWriteConnection(this.ctx);
            String[] tuple = InfostoreQueryCatalog.getInstance().getFieldTuple(field, new InfostoreQueryCatalog.VersionWins());
            int size = DBUtils.getColumnSize(con, tuple[0], tuple[1]);
            SIZES.put(field, size);
            int n = size;
            return n;
        }
        catch (SQLException e) {
            LOG.error("", (Throwable)e);
            int n = 0;
            return n;
        }
        catch (OXException e) {
            LOG.error("", (Throwable)e);
            int n = 0;
            return n;
        }
        finally {
            this.provider.releaseWriteConnectionAfterReading(this.ctx, con);
        }
    }
}

