/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.folderstorage.osgi;

import com.openexchange.exception.OXException;
import com.openexchange.server.ServiceExceptionCode;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class FolderStorageServices
implements ServiceTrackerCustomizer<Object, Object> {
    private static final FolderStorageServices INSTANCE = new FolderStorageServices();
    private final ConcurrentMap<Class<?>, Object> services = new ConcurrentHashMap();
    private final AtomicReference<BundleContext> contextRef = new AtomicReference();
    private final AtomicReference<Class<?>[]> serviceClassesRef = new AtomicReference();

    public static <T> T getService(Class<T> clazz) {
        return (T)FolderStorageServices.INSTANCE.services.get(clazz);
    }

    public static <T> T requireService(Class<T> clazz) throws OXException {
        Object service = FolderStorageServices.INSTANCE.services.get(clazz);
        if (service == null) {
            throw ServiceExceptionCode.SERVICE_UNAVAILABLE.create(new Object[]{clazz.getName()});
        }
        return (T)service;
    }

    private FolderStorageServices() {
    }

    static FolderStorageServices init(BundleContext context, Class<?>[] services) {
        FolderStorageServices.INSTANCE.contextRef.set(context);
        FolderStorageServices.INSTANCE.serviceClassesRef.set(services);
        return INSTANCE;
    }

    public Object addingService(ServiceReference<Object> reference) {
        Class<?>[] serviceClasses;
        BundleContext context = this.contextRef.get();
        if (context == null) {
            return null;
        }
        Object service = context.getService(reference);
        if (service == null) {
            context.ungetService(reference);
            return null;
        }
        for (Class<?> clazz : serviceClasses = this.serviceClassesRef.get()) {
            if (!clazz.isAssignableFrom(service.getClass())) continue;
            this.services.put(clazz, service);
            return service;
        }
        context.ungetService(reference);
        return null;
    }

    public void modifiedService(ServiceReference<Object> reference, Object service) {
    }

    public void removedService(ServiceReference<Object> reference, Object service) {
        BundleContext context;
        Class<?>[] serviceClasses;
        for (Class<?> clazz : serviceClasses = this.serviceClassesRef.get()) {
            if (!clazz.isAssignableFrom(service.getClass())) continue;
            this.services.remove(clazz, service);
            break;
        }
        if ((context = this.contextRef.get()) != null) {
            context.ungetService(reference);
        }
    }
}

