/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.folderstorage.internal.performers;

import com.openexchange.concurrent.CallerRunsCompletionService;
import com.openexchange.exception.Category;
import com.openexchange.exception.OXException;
import com.openexchange.exception.OXExceptions;
import com.openexchange.folderstorage.AbstractFolder;
import com.openexchange.folderstorage.Folder;
import com.openexchange.folderstorage.FolderExceptionErrorMessage;
import com.openexchange.folderstorage.FolderServiceDecorator;
import com.openexchange.folderstorage.FolderStorage;
import com.openexchange.folderstorage.FolderStorageDiscoverer;
import com.openexchange.folderstorage.FolderType;
import com.openexchange.folderstorage.Permission;
import com.openexchange.folderstorage.SortableId;
import com.openexchange.folderstorage.StorageParameters;
import com.openexchange.folderstorage.UserizedFolder;
import com.openexchange.folderstorage.internal.CalculatePermission;
import com.openexchange.folderstorage.internal.performers.AbstractUserizedFolderPerformer;
import com.openexchange.folderstorage.internal.performers.InstanceStorageParametersProvider;
import com.openexchange.folderstorage.internal.performers.SessionStorageParametersProvider;
import com.openexchange.folderstorage.internal.performers.StorageParametersProvider;
import com.openexchange.folderstorage.mail.MailFolderType;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.mail.FullnameArgument;
import com.openexchange.mail.config.MailProperties;
import com.openexchange.mail.utils.MailFolderUtility;
import com.openexchange.mailaccount.internal.RdbMailAccountStorage;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.threadpool.ThreadPoolCompletionService;
import com.openexchange.threadpool.ThreadPoolService;
import com.openexchange.threadpool.ThreadPools;
import com.openexchange.tools.session.ServerSession;
import gnu.trove.list.TIntList;
import gnu.trove.list.array.TIntArrayList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletionService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ListPerformer
extends AbstractUserizedFolderPerformer {
    private static final Logger LOG = LoggerFactory.getLogger(ListPerformer.class);
    protected static final FolderType FOLDER_TYPE_MAIL = MailFolderType.getInstance();
    private static final Folder MISSING_FOLDER = new AbstractFolder(){
        private static final long serialVersionUID = -2248191704180825606L;

        @Override
        public boolean isGlobalID() {
            return false;
        }
    };

    public ListPerformer(ServerSession session, FolderServiceDecorator decorator) throws OXException {
        super(session, decorator);
    }

    public ListPerformer(User user, Context context, FolderServiceDecorator decorator) {
        super(user, context, decorator);
    }

    public ListPerformer(ServerSession session, FolderServiceDecorator decorator, FolderStorageDiscoverer folderStorageDiscoverer) throws OXException {
        super(session, decorator, folderStorageDiscoverer);
    }

    public ListPerformer(User user, Context context, FolderServiceDecorator decorator, FolderStorageDiscoverer folderStorageDiscoverer) {
        super(user, context, decorator, folderStorageDiscoverer);
    }

    public UserizedFolder[] doList(String treeId, String parentId, boolean all) throws OXException {
        return this.doList(treeId, parentId, all, false);
    }

    protected UserizedFolder[] doList(String treeId, String parentId, boolean all, boolean checkOnly) throws OXException {
        FolderStorage folderStorage = this.folderStorageDiscoverer.getFolderStorage(treeId, parentId);
        if (null == folderStorage) {
            throw FolderExceptionErrorMessage.NO_STORAGE_FOR_ID.create(treeId, parentId);
        }
        ArrayList<FolderStorage> openedStorages = new ArrayList<FolderStorage>(4);
        if (folderStorage.startTransaction(this.storageParameters, false)) {
            openedStorages.add(folderStorage);
        }
        try {
            UserizedFolder[] ret;
            for (UserizedFolder userizedFolder : ret = this.doList(treeId, parentId, all, openedStorages, checkOnly)) {
                userizedFolder.setParentID(parentId);
            }
            for (FolderStorage fs : openedStorages) {
                fs.commitTransaction(this.storageParameters);
            }
            return ret;
        }
        catch (OXException e) {
            for (FolderStorage fs : openedStorages) {
                fs.rollback(this.storageParameters);
            }
            throw e;
        }
        catch (RuntimeException e) {
            for (FolderStorage fs : openedStorages) {
                fs.rollback(this.storageParameters);
            }
            throw FolderExceptionErrorMessage.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
    }

    private Folder checkParentFolder(String treeId, String parentId, Collection<FolderStorage> openedStorages) throws OXException {
        FolderStorage folderStorage = this.getOpenedStorage(parentId, treeId, this.storageParameters, openedStorages);
        Folder parent = folderStorage.getFolder(treeId, parentId, this.storageParameters);
        Permission parentPermission = CalculatePermission.calculate(parent, this, this.getAllowedContentTypes());
        if (!parentPermission.isVisible()) {
            throw FolderExceptionErrorMessage.FOLDER_NOT_VISIBLE.create(this.getFolderInfo4Error(parent), this.getUserInfo4Error(), this.getContextInfo4Error());
        }
        return parent;
    }

    UserizedFolder[] doList(String treeId, String parentId, boolean all, Collection<FolderStorage> openedStorages, boolean checkOnly) throws OXException {
        Folder parent = this.checkParentFolder(treeId, parentId, openedStorages);
        try {
            String[] subfolderIds = parent.getSubfolderIDs();
            if (null == subfolderIds) {
                return this.getSubfoldersFromStorages(treeId, parentId, all, checkOnly);
            }
            if (0 == (subfolderIds = this.filterPOP3SubfolderIds(parentId, subfolderIds)).length) {
                return new UserizedFolder[0];
            }
            return this.loadFolders(treeId, subfolderIds, all, checkOnly);
        }
        catch (RuntimeException e) {
            throw FolderExceptionErrorMessage.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
    }

    private List<SortableId> filterPOP3SubfolderIds(FolderStorage neededStorage, String treeId, String parentId, SortableId[] subfolderIds, StorageParameters newParameters) throws OXException {
        List<SortableId> l;
        if (MailProperties.getInstance().isHidePOP3StorageFolders() && FOLDER_TYPE_MAIL.servesFolderId(parentId)) {
            l = new ArrayList<SortableId>(Arrays.asList(neededStorage.getSubfolders(treeId, parentId, newParameters)));
            FullnameArgument argument = MailFolderUtility.prepareMailFolderParam(parentId);
            if (0 == argument.getAccountId()) {
                Set<String> pop3StorageFolders = this.session == null ? RdbMailAccountStorage.getPOP3StorageFolders(this.user, this.context) : RdbMailAccountStorage.getPOP3StorageFolders(this.session);
                Iterator<SortableId> it = l.iterator();
                while (it.hasNext()) {
                    if (!pop3StorageFolders.contains(it.next().getId())) continue;
                    it.remove();
                }
            }
        } else {
            l = Arrays.asList(neededStorage.getSubfolders(treeId, parentId, newParameters));
        }
        return l;
    }

    private String[] filterPOP3SubfolderIds(String parentId, String[] subfolderIds) throws OXException {
        FullnameArgument argument;
        if (MailProperties.getInstance().isHidePOP3StorageFolders() && FOLDER_TYPE_MAIL.servesFolderId(parentId) && 0 == (argument = MailFolderUtility.prepareMailFolderParam(parentId)).getAccountId()) {
            ArrayList<String> l = new ArrayList<String>(Arrays.asList(subfolderIds));
            Set<String> pop3StorageFolders = this.session == null ? RdbMailAccountStorage.getPOP3StorageFolders(this.user, this.context) : RdbMailAccountStorage.getPOP3StorageFolders(this.session);
            Iterator it = l.iterator();
            while (it.hasNext()) {
                if (!pop3StorageFolders.contains(it.next())) continue;
                it.remove();
            }
            return l.toArray(new String[l.size()]);
        }
        return subfolderIds;
    }

    private Map<FolderStorage, TIntList> mapStoragesToIndexes(String treeId, String[] subfolderIds) throws OXException {
        HashMap<FolderStorage, TIntList> map = new HashMap<FolderStorage, TIntList>(4);
        for (int i = 0; i < subfolderIds.length; ++i) {
            String id = subfolderIds[i];
            FolderStorage tmp = this.folderStorageDiscoverer.getFolderStorage(treeId, id);
            if (null == tmp) {
                throw FolderExceptionErrorMessage.NO_STORAGE_FOR_ID.create(treeId, id);
            }
            TIntList list = (TIntList)map.get(tmp);
            if (null == list) {
                list = new TIntArrayList();
                map.put(tmp, list);
            }
            list.add(i);
        }
        return map;
    }

    private List<List<SortableId>> getAllVisibleSubfolderIds(FolderStorage[] neededStorages, final String parentId, final String treeId) throws OXException {
        ThreadPoolService threadPool = ServerServiceRegistry.getInstance().getService(ThreadPoolService.class, true);
        ThreadPoolCompletionService completionService = new ThreadPoolCompletionService(threadPool);
        for (final FolderStorage neededStorage : neededStorages) {
            completionService.submit(new ThreadPools.TrackableCallable<List<SortableId>>(){

                public List<SortableId> call() throws OXException {
                    StorageParameters newParameters = ListPerformer.this.newStorageParameters();
                    boolean started = neededStorage.startTransaction(newParameters, false);
                    try {
                        List l = ListPerformer.this.filterPOP3SubfolderIds(neededStorage, treeId, parentId, neededStorage.getSubfolders(treeId, parentId, newParameters), newParameters);
                        if (started) {
                            neededStorage.commitTransaction(newParameters);
                        }
                        return l;
                    }
                    catch (OXException e) {
                        if (started) {
                            neededStorage.rollback(newParameters);
                        }
                        ListPerformer.this.addWarning(e);
                        return Collections.emptyList();
                    }
                    catch (RuntimeException e) {
                        if (started) {
                            neededStorage.rollback(newParameters);
                        }
                        OXException OXException2 = FolderExceptionErrorMessage.UNEXPECTED_ERROR.create(e, e.getMessage());
                        ListPerformer.this.addWarning(OXException2);
                        return Collections.emptyList();
                    }
                }
            });
        }
        List results = ThreadPools.takeCompletionService((CompletionService)completionService, (int)neededStorages.length, (ThreadPools.ExpectedExceptionFactory)FACTORY);
        return results;
    }

    private UserizedFolder[] getSubfoldersFromStorages(String treeId, String parentId, boolean all, boolean checkOnly) throws OXException {
        String[] subfolderIds = this.collectAndSortSubfolderIds(treeId, parentId);
        if (subfolderIds.length == 0) {
            return new UserizedFolder[0];
        }
        return this.loadFolders(treeId, subfolderIds, all, checkOnly);
    }

    /*
     * Unable to fully structure code
     */
    private String[] collectAndSortSubfolderIds(String treeId, String parentId) throws OXException {
        neededStorages = this.folderStorageDiscoverer.getFolderStoragesForParent(treeId, parentId);
        if (null == neededStorages || 0 == neededStorages.length) {
            return new String[0];
        }
        if (1 == neededStorages.length) {
            neededStorage = neededStorages[0];
            started = neededStorage.startTransaction(this.storageParameters, false);
            try {
                allSubfolderIds = Arrays.asList(neededStorage.getSubfolders(treeId, parentId, this.storageParameters));
                if (!started) ** GOTO lbl31
                neededStorage.commitTransaction(this.storageParameters);
            }
            catch (OXException e) {
                if (started) {
                    neededStorage.rollback(this.storageParameters);
                }
                throw e;
            }
            catch (RuntimeException e) {
                if (started) {
                    neededStorage.rollback(this.storageParameters);
                }
                throw FolderExceptionErrorMessage.UNEXPECTED_ERROR.create(e, new Object[]{e.getMessage()});
            }
        } else {
            allSubfolderIds = new ArrayList<E>(neededStorages.length * 8);
            results = this.getAllVisibleSubfolderIds(neededStorages, parentId, treeId);
            for (List<SortableId> result : results) {
                allSubfolderIds.addAll(result);
            }
            if (!results.isEmpty() && results.size() == this.getNumOfWarnings()) {
                e = this.getWarnings().iterator().next();
                e.addCategory(Category.CATEGORY_ERROR);
                throw e;
            }
        }
lbl31:
        // 4 sources

        Collections.sort(allSubfolderIds);
        subfolderIds = new String[allSubfolderIds.size()];
        for (i = 0; i < subfolderIds.length; ++i) {
            subfolderId = (SortableId)allSubfolderIds.get(i);
            subfolderIds[i] = subfolderId.getId();
        }
        return subfolderIds;
    }

    private UserizedFolder[] loadFolders(final String treeId, final String[] subfolderIds, final boolean all, final boolean checkOnly) throws OXException {
        StorageParametersProvider paramsProvider;
        ThreadPoolCompletionService completionService;
        final UserizedFolder[] subfolders = new UserizedFolder[subfolderIds.length];
        Map<FolderStorage, TIntList> map = this.mapStoragesToIndexes(treeId, subfolderIds);
        if (1 == map.size()) {
            completionService = new CallerRunsCompletionService();
            paramsProvider = new InstanceStorageParametersProvider(this.storageParameters);
        } else {
            completionService = new ThreadPoolCompletionService(ServerServiceRegistry.getInstance().getService(ThreadPoolService.class, true));
            paramsProvider = null == this.session ? new SessionStorageParametersProvider(this.user, this.context) : new SessionStorageParametersProvider(this.session);
        }
        int taskCount = 0;
        for (Map.Entry<FolderStorage, TIntList> entry : map.entrySet()) {
            final FolderStorage folderStorage = entry.getKey();
            final int[] indexes = entry.getValue().toArray();
            completionService.submit(new ThreadPools.TrackableCallable<Object>(){

                public Object call() throws Exception {
                    ListPerformer.this.loadFoldersFromStorage(folderStorage, paramsProvider, treeId, subfolderIds, all, checkOnly, subfolders, indexes);
                    return null;
                }
            });
            ++taskCount;
        }
        ThreadPools.takeCompletionService((CompletionService)completionService, (int)taskCount, (ThreadPools.ExpectedExceptionFactory)FACTORY);
        return ListPerformer.trimArray(subfolders);
    }

    private void loadFoldersFromStorage(FolderStorage folderStorage, StorageParametersProvider paramsProvider, String treeId, String[] subfolderIds, boolean all, boolean checkOnly, UserizedFolder[] subfolders, int[] indexes) throws Exception {
        StorageParameters newParameters = paramsProvider.getStorageParameters();
        ArrayList<FolderStorage> openedStorages = new ArrayList<FolderStorage>(2);
        if (folderStorage.startTransaction(newParameters, false)) {
            openedStorages.add(folderStorage);
        }
        try {
            List<Folder> folders2 = this.getFolders(folderStorage, newParameters, treeId, subfolderIds, indexes);
            if (null == folders2) {
                folders2 = this.getFoldersOneByOne(folderStorage, newParameters, treeId, subfolderIds, indexes, openedStorages);
            }
            int size = folders2.size();
            int j = 0;
            for (int index : indexes) {
                Folder subfolder;
                if (j >= size || null == (subfolder = folders2.get(j++))) continue;
                this.setSubfolder(subfolders, subfolder, index, all, checkOnly, treeId, newParameters, openedStorages);
            }
            for (FolderStorage fs : openedStorages) {
                fs.commitTransaction(newParameters);
            }
        }
        catch (OXException e) {
            for (FolderStorage fs : openedStorages) {
                fs.rollback(newParameters);
            }
            throw e;
        }
        catch (RuntimeException e) {
            for (FolderStorage fs : openedStorages) {
                fs.rollback(newParameters);
            }
            throw FolderExceptionErrorMessage.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
    }

    private List<Folder> getFolders(FolderStorage folderStorage, StorageParameters newParameters, String treeId, String[] subfolderIds, int[] indexes) {
        List<Folder> folders2;
        try {
            ArrayList<String> ids = new ArrayList<String>(indexes.length);
            for (int index : indexes) {
                ids.add(subfolderIds[index]);
            }
            folders2 = folderStorage.getFolders(treeId, ids, newParameters);
            Set<OXException> warnings = newParameters.getWarnings();
            if (!warnings.isEmpty()) {
                this.addWarning(warnings.iterator().next());
            }
        }
        catch (OXException e) {
            if (OXExceptions.isUserInput((OXException)e) || OXExceptions.isPermissionDenied((OXException)e)) {
                LOG.debug("Batch loading of folder failed. Fall-back to one-by-one loading.", (Throwable)e);
            } else {
                LOG.warn("Batch loading of folder failed. Fall-back to one-by-one loading.", (Throwable)e);
            }
            folders2 = null;
        }
        return folders2;
    }

    private List<Folder> getFoldersOneByOne(FolderStorage folderStorage, StorageParameters newParameters, String treeId, String[] subfolderIds, int[] indexes, List<FolderStorage> openedStorages) throws OXException {
        ArrayList<Folder> folders2 = new ArrayList<Folder>(indexes.length);
        for (int index : indexes) {
            String id = subfolderIds[index];
            Folder subfolder = null;
            try {
                subfolder = folderStorage.getFolder(treeId, id, newParameters);
            }
            catch (OXException e) {
                if (OXExceptions.isUserInput((OXException)e) || OXExceptions.isPermissionDenied((OXException)e)) {
                    LOG.debug("The folder with ID \"{}\" in tree \"{}\" could not be fetched from storage \"{}\"", new Object[]{id, treeId, folderStorage.getClass().getSimpleName(), e});
                } else {
                    LOG.warn("The folder with ID \"{}\" in tree \"{}\" could not be fetched from storage \"{}\"", new Object[]{id, treeId, folderStorage.getClass().getSimpleName()});
                }
                this.addWarning(e);
            }
            if (subfolder == null) {
                folders2.add(MISSING_FOLDER);
                continue;
            }
            folders2.add(subfolder);
        }
        return folders2;
    }

    private void setSubfolder(UserizedFolder[] subfolders, Folder subfolder, int index, boolean all, boolean checkOnly, String treeId, StorageParameters newParameters, List<FolderStorage> openedStorages) throws OXException {
        Permission userPermission;
        if (subfolder == MISSING_FOLDER) {
            return;
        }
        if ((all || subfolder.isSubscribed() || subfolder.hasSubscribedSubfolders()) && (userPermission = CalculatePermission.calculate(subfolder, this, this.getAllowedContentTypes())).isVisible()) {
            subfolders[index] = this.getUserizedFolder(subfolder, userPermission, treeId, all, true, newParameters, openedStorages, checkOnly);
        }
    }
}

