/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.folderstorage.internal.performers;

import com.openexchange.ajax.requesthandler.AJAXRequestDataTools;
import com.openexchange.exception.OXException;
import com.openexchange.folderstorage.ContentType;
import com.openexchange.folderstorage.Folder;
import com.openexchange.folderstorage.FolderExceptionErrorMessage;
import com.openexchange.folderstorage.FolderServiceDecorator;
import com.openexchange.folderstorage.FolderStorage;
import com.openexchange.folderstorage.FolderStorageDiscoverer;
import com.openexchange.folderstorage.GuestPermission;
import com.openexchange.folderstorage.Permission;
import com.openexchange.folderstorage.Permissions;
import com.openexchange.folderstorage.SortableId;
import com.openexchange.folderstorage.StorageParameters;
import com.openexchange.folderstorage.StorageParametersUtility;
import com.openexchange.folderstorage.Type;
import com.openexchange.folderstorage.UserizedFolder;
import com.openexchange.folderstorage.database.contentType.CalendarContentType;
import com.openexchange.folderstorage.database.contentType.ContactContentType;
import com.openexchange.folderstorage.database.contentType.InfostoreContentType;
import com.openexchange.folderstorage.database.contentType.TaskContentType;
import com.openexchange.folderstorage.filestorage.contentType.FileStorageContentType;
import com.openexchange.folderstorage.internal.CalculatePermission;
import com.openexchange.folderstorage.internal.FolderI18nNamesServiceImpl;
import com.openexchange.folderstorage.internal.UserizedFolderImpl;
import com.openexchange.folderstorage.internal.performers.AbstractPerformer;
import com.openexchange.folderstorage.internal.performers.ComparedFolderPermissions;
import com.openexchange.folderstorage.internal.performers.ListPerformer;
import com.openexchange.folderstorage.osgi.FolderStorageServices;
import com.openexchange.folderstorage.type.PrivateType;
import com.openexchange.folderstorage.type.PublicType;
import com.openexchange.folderstorage.type.SharedType;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.modules.Module;
import com.openexchange.java.Autoboxing;
import com.openexchange.objectusecount.IncrementArguments;
import com.openexchange.objectusecount.ObjectUseCountService;
import com.openexchange.session.Session;
import com.openexchange.share.CreatedShares;
import com.openexchange.share.GuestInfo;
import com.openexchange.share.ShareInfo;
import com.openexchange.share.ShareService;
import com.openexchange.share.ShareTarget;
import com.openexchange.share.recipient.RecipientType;
import com.openexchange.share.recipient.ShareRecipient;
import com.openexchange.threadpool.ThreadPools;
import com.openexchange.tools.TimeZoneUtils;
import com.openexchange.tools.session.ServerSession;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class AbstractUserizedFolderPerformer
extends AbstractPerformer {
    protected static final String RECURSION_MARKER = AbstractUserizedFolderPerformer.class.getName() + ".RECURSION_MARKER";
    private static final String DUMMY_ID = "dummyId";
    private static final Pattern IS_NUMBERED_PARENTHESIS = Pattern.compile("\\(\\d+\\)$");
    private static final Pattern IS_NUMBERED = Pattern.compile("\\d+$");
    private final FolderServiceDecorator decorator;
    private volatile TimeZone timeZone;
    private volatile Locale locale;
    private volatile List<ContentType> allowedContentTypes;
    protected static final Set<String> PIM_CONTENT_TYPES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(CalendarContentType.getInstance().toString(), ContactContentType.getInstance().toString(), TaskContentType.getInstance().toString(), InfostoreContentType.getInstance().toString())));
    protected static final Set<String> PARENTHESIS_CAPABLE = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(CalendarContentType.getInstance().toString(), TaskContentType.getInstance().toString(), ContactContentType.getInstance().toString(), InfostoreContentType.getInstance().toString(), FileStorageContentType.getInstance().toString())));
    protected static final ThreadPools.ExpectedExceptionFactory<OXException> FACTORY = new ThreadPools.ExpectedExceptionFactory<OXException>(){

        public Class<OXException> getType() {
            return OXException.class;
        }

        public OXException newUnexpectedError(Throwable t) {
            return FolderExceptionErrorMessage.UNEXPECTED_ERROR.create(t, t.getMessage());
        }
    };

    public AbstractUserizedFolderPerformer(ServerSession session, FolderServiceDecorator decorator) throws OXException {
        super(session);
        this.decorator = decorator;
        this.storageParameters.setDecorator(decorator);
    }

    public AbstractUserizedFolderPerformer(User user, Context context, FolderServiceDecorator decorator) {
        super(user, context);
        this.decorator = decorator;
        this.storageParameters.setDecorator(decorator);
    }

    public AbstractUserizedFolderPerformer(ServerSession session, FolderServiceDecorator decorator, FolderStorageDiscoverer folderStorageDiscoverer) throws OXException {
        super(session, folderStorageDiscoverer);
        this.decorator = decorator;
        this.storageParameters.setDecorator(decorator);
    }

    public AbstractUserizedFolderPerformer(User user, Context context, FolderServiceDecorator decorator, FolderStorageDiscoverer folderStorageDiscoverer) {
        super(user, context, folderStorageDiscoverer);
        this.decorator = decorator;
        this.storageParameters.setDecorator(decorator);
    }

    protected static boolean isPublicPimFolder(Folder folder) {
        ContentType contentType;
        if (FolderStorage.PUBLIC_ID.equals(folder.getID())) {
            return true;
        }
        return PublicType.getInstance().equals(folder.getType()) && null != (contentType = folder.getContentType()) && PIM_CONTENT_TYPES.contains(contentType.toString());
    }

    protected final FolderServiceDecorator getDecorator() {
        return this.decorator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final TimeZone getTimeZone() {
        TimeZone tmp = this.timeZone;
        if (null == tmp) {
            AbstractUserizedFolderPerformer abstractUserizedFolderPerformer = this;
            synchronized (abstractUserizedFolderPerformer) {
                tmp = this.timeZone;
                if (null == tmp) {
                    TimeZone tz = null == this.decorator ? null : this.decorator.getTimeZone();
                    tmp = tz == null ? TimeZoneUtils.getTimeZone(this.getUser().getTimeZone()) : tz;
                    this.timeZone = tmp;
                }
            }
        }
        return tmp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Locale getLocale() {
        Locale tmp = this.locale;
        if (null == tmp) {
            AbstractUserizedFolderPerformer abstractUserizedFolderPerformer = this;
            synchronized (abstractUserizedFolderPerformer) {
                tmp = this.locale;
                if (null == tmp) {
                    Locale l = null == this.decorator ? null : this.decorator.getLocale();
                    tmp = l == null ? this.getUser().getLocale() : l;
                    this.locale = tmp;
                }
            }
        }
        return tmp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final List<ContentType> getAllowedContentTypes() {
        List<ContentType> tmp = this.allowedContentTypes;
        if (null == tmp) {
            AbstractUserizedFolderPerformer abstractUserizedFolderPerformer = this;
            synchronized (abstractUserizedFolderPerformer) {
                tmp = this.allowedContentTypes;
                if (null == tmp) {
                    tmp = null == this.decorator ? ALL_ALLOWED : this.decorator.getAllowedContentTypes();
                    this.allowedContentTypes = tmp;
                }
            }
        }
        return tmp;
    }

    protected final <V> V getDecoratorProperty(String name) {
        if (null == name || null == this.decorator) {
            return null;
        }
        Object val = this.decorator.getProperty(name);
        return (V)(null == val ? null : val);
    }

    protected final String getDecoratorStringProperty(String name) {
        if (null == name || null == this.decorator) {
            return null;
        }
        Object val = this.decorator.getProperty(name);
        return null == val ? null : val.toString();
    }

    protected UserizedFolder getUserizedFolder(Folder folder, Permission ownPermission, String treeId, boolean all, boolean nullIsPublicAccess, StorageParameters storageParameters, Collection<FolderStorage> openedStorages) throws OXException {
        return this.getUserizedFolder(folder, ownPermission, treeId, all, nullIsPublicAccess, storageParameters, openedStorages, false);
    }

    protected UserizedFolder getUserizedFolder(Folder folder, Permission ownPermission, String treeId, boolean all, boolean nullIsPublicAccess, StorageParameters storageParameters, Collection<FolderStorage> openedStorages, boolean checkOnly) throws OXException {
        Date lm;
        Date cd;
        boolean isShared;
        UserizedFolderImpl userizedFolder;
        Folder f = folder;
        int createdBy = f.getCreatedBy();
        Type type = f.getType();
        if (SharedType.getInstance().equals(type)) {
            userizedFolder = new UserizedFolderImpl(f, storageParameters.getSession(), storageParameters.getUser(), storageParameters.getContext());
            userizedFolder.setDefault(false);
            userizedFolder.setDefaultType(0);
            isShared = true;
        } else if (createdBy >= 0 && createdBy != this.getUserId() && PrivateType.getInstance().equals(type)) {
            FolderStorage curStorage = this.folderStorageDiscoverer.getFolderStorage(treeId, f.getID());
            boolean alreadyOpened = false;
            Iterator<FolderStorage> it = openedStorages.iterator();
            for (int j = 0; !alreadyOpened && j < openedStorages.size(); ++j) {
                if (!it.next().equals(curStorage)) continue;
                alreadyOpened = true;
            }
            if (!alreadyOpened && curStorage.startTransaction(storageParameters, false)) {
                openedStorages.add(curStorage);
            }
            f = curStorage.prepareFolder(treeId, f, storageParameters);
            userizedFolder = new UserizedFolderImpl(f, storageParameters.getSession(), storageParameters.getUser(), storageParameters.getContext());
            userizedFolder.setDefault(false);
            userizedFolder.setDefaultType(0);
            userizedFolder.setType(SharedType.getInstance());
            isShared = true;
        } else {
            userizedFolder = new UserizedFolderImpl(f, storageParameters.getSession(), storageParameters.getUser(), storageParameters.getContext());
            isShared = false;
        }
        userizedFolder.setLocale(this.getLocale());
        userizedFolder.setAltNames(StorageParametersUtility.getBoolParameter("altNames", storageParameters));
        userizedFolder.setOwnPermission(ownPermission);
        CalculatePermission.calculateUserPermissions(userizedFolder, this.getContext());
        if (userizedFolder.getID().startsWith("u:")) {
            userizedFolder.setParentID(FolderStorage.SHARED_ID);
        }
        if (null != (cd = f.getCreationDate())) {
            long time = cd.getTime();
            userizedFolder.setCreationDate(new Date(AbstractUserizedFolderPerformer.addTimeZoneOffset(time, this.getTimeZone())));
            userizedFolder.setCreationDateUTC(new Date(time));
        }
        if (null != (lm = f.getLastModified())) {
            long time = lm.getTime();
            userizedFolder.setLastModified(new Date(AbstractUserizedFolderPerformer.addTimeZoneOffset(time, this.getTimeZone())));
            userizedFolder.setLastModifiedUTC(new Date(time));
        }
        if (!checkOnly) {
            if (isShared) {
                String[] visibleSubfolders = f.getSubfolderIDs();
                if (null == visibleSubfolders) {
                    String[] stringArray;
                    if (nullIsPublicAccess) {
                        String[] stringArray2 = new String[1];
                        stringArray = stringArray2;
                        stringArray2[0] = DUMMY_ID;
                    } else {
                        stringArray = new String[]{};
                    }
                    userizedFolder.setSubfolderIDs(stringArray);
                } else {
                    userizedFolder.setSubfolderIDs(visibleSubfolders);
                }
            } else {
                this.hasVisibleSubfolderIDs(f, treeId, all, userizedFolder, nullIsPublicAccess, storageParameters, openedStorages);
            }
        }
        return userizedFolder;
    }

    protected String checkForReservedName(String treeId, String targetFolderId, Folder folderToSave, ContentType contentType, boolean allowAutorename) throws OXException {
        if (!this.check4Duplicates || null == folderToSave.getName() || InfostoreContentType.getInstance().toString().equals(contentType.toString())) {
            return null;
        }
        boolean autoRename = allowAutorename ? AJAXRequestDataTools.parseBoolParameter(this.getDecoratorStringProperty("autorename")) : false;
        String lowercaseTargetName = folderToSave.getName().toLowerCase(this.getLocale());
        HashSet<String> reservedNames = new HashSet<String>();
        Set<String> i18nNames = FolderI18nNamesServiceImpl.getInstance().getI18nNamesFor(Module.SYSTEM.getFolderConstant(), Module.CALENDAR.getFolderConstant(), Module.CONTACTS.getFolderConstant(), Module.MAIL.getFolderConstant(), Module.TASK.getFolderConstant());
        for (String i18nName : i18nNames) {
            String reservedName = i18nName.toLowerCase(this.getLocale());
            if (!autoRename && lowercaseTargetName.equals(reservedName)) {
                return i18nName;
            }
            reservedNames.add(reservedName);
        }
        if (autoRename) {
            this.autoRename(reservedNames, folderToSave, contentType);
        }
        return null;
    }

    protected UserizedFolder checkForEqualName(String treeId, String targetFolderId, Folder folderToSave, ContentType contentType, boolean allowAutorename) throws OXException {
        UserizedFolder[] existingFolders;
        if (!this.check4Duplicates || null == folderToSave.getName()) {
            return null;
        }
        boolean autoRename = allowAutorename ? AJAXRequestDataTools.parseBoolParameter(this.getDecoratorStringProperty("autorename")) : false;
        String lowercaseTargetName = folderToSave.getName().toLowerCase(this.getLocale());
        HashSet<String> conflictingNames = new HashSet<String>();
        ListPerformer listPerformer = this.session == null ? new ListPerformer(this.user, this.context, null, this.folderStorageDiscoverer) : new ListPerformer(this.session, null, this.folderStorageDiscoverer);
        for (UserizedFolder existingFolder : existingFolders = listPerformer.doList(treeId, targetFolderId, true, true)) {
            if (existingFolder.getID().equals(folderToSave.getID())) continue;
            String conflictingName = existingFolder.getName().toLowerCase(this.getLocale());
            if (!autoRename && lowercaseTargetName.equals(conflictingName)) {
                return existingFolder;
            }
            conflictingNames.add(conflictingName);
            if (InfostoreContentType.getInstance().toString().equals(contentType.toString())) continue;
            String conflictingLocalizedName = existingFolder.getLocalizedName(this.getLocale()).toLowerCase(this.getLocale());
            if (!autoRename && lowercaseTargetName.equals(conflictingLocalizedName)) {
                return existingFolder;
            }
            conflictingNames.add(conflictingLocalizedName);
        }
        if (autoRename) {
            this.autoRename(conflictingNames, folderToSave, contentType);
        }
        return null;
    }

    private boolean autoRename(Set<String> conflictingNames, Folder folderToSave, ContentType contentType) {
        if (null == conflictingNames || 0 == conflictingNames.size()) {
            return false;
        }
        String targetName = folderToSave.getName();
        if (conflictingNames.contains(targetName.toLowerCase(this.getLocale()).trim())) {
            boolean useParenthesis = PARENTHESIS_CAPABLE.contains(contentType.toString());
            int counter = 0;
            while (conflictingNames.contains((targetName = AbstractUserizedFolderPerformer.enhance(targetName, ++counter, useParenthesis)).toLowerCase(this.getLocale()).trim())) {
            }
            folderToSave.setName(targetName);
            return true;
        }
        return false;
    }

    protected void processRemovedGuestPermissions(List<Permission> removedPermissions) throws OXException {
        if (this.ignoreGuestPermissions()) {
            return;
        }
        ArrayList<Integer> guestIDs = new ArrayList<Integer>(removedPermissions.size());
        for (Permission permission : removedPermissions) {
            guestIDs.add(permission.getEntity());
        }
        FolderStorageServices.requireService(ShareService.class).scheduleGuestCleanup(this.getContextId(), Autoboxing.I2i(guestIDs));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processAddedGuestPermissions(String folderID, ContentType contentType, ComparedFolderPermissions comparedPermissions, Connection connection) throws OXException {
        if (this.session == null) {
            return;
        }
        if (comparedPermissions.hasNewGuests()) {
            Map<ShareTarget, List<GuestPermission>> permissionsPerTarget = AbstractUserizedFolderPerformer.getPermissionsPerTarget(folderID, contentType, comparedPermissions.getNewGuestPermissions());
            ShareService shareService = FolderStorageServices.requireService(ShareService.class);
            ObjectUseCountService useCountService = FolderStorageServices.getService(ObjectUseCountService.class);
            CreatedShares shares = null;
            boolean sessionParameterSet = false;
            try {
                if (!this.session.containsParameter(Connection.class.getName() + '@' + Thread.currentThread().getId())) {
                    this.session.setParameter(Connection.class.getName() + '@' + Thread.currentThread().getId(), connection);
                    sessionParameterSet = true;
                }
                for (Map.Entry<ShareTarget, List<GuestPermission>> entry : permissionsPerTarget.entrySet()) {
                    List<GuestPermission> permissions = entry.getValue();
                    ArrayList<ShareRecipient> recipients = new ArrayList<ShareRecipient>(permissions.size());
                    for (GuestPermission permission : permissions) {
                        recipients.add(permission.getRecipient());
                    }
                    shares = shareService.addTarget((Session)this.session, entry.getKey(), recipients);
                    if (null == shares || shares.size() != permissions.size()) {
                        throw FolderExceptionErrorMessage.UNEXPECTED_ERROR.create("Shares not created as expected");
                    }
                    for (GuestPermission permission : permissions) {
                        ShareInfo share = shares.getShare(permission.getRecipient());
                        permission.setEntity(share.getGuest().getGuestID());
                        comparedPermissions.rememberGuestInfo(share.getGuest());
                        if (null == useCountService) continue;
                        IncrementArguments arguments = new IncrementArguments.Builder(share.getGuest().getEmailAddress()).build();
                        useCountService.incrementObjectUseCount((Session)this.session, arguments);
                    }
                }
            }
            finally {
                if (sessionParameterSet) {
                    this.session.setParameter(Connection.class.getName() + '@' + Thread.currentThread().getId(), null);
                }
            }
        }
    }

    private boolean ignoreGuestPermissions() {
        return this.decorator != null && this.decorator.getBoolProperty("com.openexchange.folderstorage.ignoreGuestPermissions");
    }

    private static Map<ShareTarget, List<GuestPermission>> getPermissionsPerTarget(String folderID, ContentType contentType, List<GuestPermission> permissions) {
        HashMap<ShareTarget, List<GuestPermission>> permissionsPerTarget = new HashMap<ShareTarget, List<GuestPermission>>();
        for (GuestPermission permission : permissions) {
            ShareTarget target = new ShareTarget(contentType.getModule(), String.valueOf(folderID));
            ArrayList<GuestPermission> exitingPermissions = (ArrayList<GuestPermission>)permissionsPerTarget.get(target);
            if (null == exitingPermissions) {
                exitingPermissions = new ArrayList<GuestPermission>();
                permissionsPerTarget.put(target, exitingPermissions);
            }
            exitingPermissions.add(permission);
        }
        return permissionsPerTarget;
    }

    protected void checkGuestPermissions(Folder folder, ComparedFolderPermissions comparedPermissions) throws OXException {
        if (comparedPermissions.hasAddedGuests()) {
            Permission addedAnonymousPermission = null;
            List addedGuests = comparedPermissions.getAddedGuests();
            for (Integer guestID : addedGuests) {
                GuestInfo guestInfo = comparedPermissions.getGuestInfo(guestID);
                Permission guestPermission = (Permission)comparedPermissions.getAddedGuestPermission(guestID);
                AbstractUserizedFolderPerformer.checkGuestPermission(folder, guestPermission, guestInfo);
                if (!AbstractUserizedFolderPerformer.isAnonymous(guestInfo)) continue;
                if (null == addedAnonymousPermission) {
                    addedAnonymousPermission = guestPermission;
                    continue;
                }
                throw AbstractUserizedFolderPerformer.invalidPermissions(folder, guestPermission);
            }
            if (null != addedAnonymousPermission && AbstractUserizedFolderPerformer.containsOriginalAnonymousPermission(comparedPermissions)) {
                throw AbstractUserizedFolderPerformer.invalidPermissions(folder, addedAnonymousPermission);
            }
        }
        if (comparedPermissions.hasModifiedGuests()) {
            for (Integer guestID : comparedPermissions.getModifiedGuests()) {
                GuestInfo guestInfo = comparedPermissions.getGuestInfo(guestID);
                Permission guestPermission = (Permission)comparedPermissions.getModifiedGuestPermission(guestID);
                AbstractUserizedFolderPerformer.checkGuestPermission(folder, guestPermission, guestInfo);
            }
        }
        if (comparedPermissions.hasNewGuests()) {
            GuestPermission newAnonymousPermission = null;
            for (GuestPermission guestPermission : comparedPermissions.getNewGuestPermissions()) {
                if (guestPermission.getRecipient().getType() == RecipientType.ANONYMOUS) {
                    AbstractUserizedFolderPerformer.checkIsLinkPermission(folder, guestPermission);
                    if (null == newAnonymousPermission) {
                        newAnonymousPermission = guestPermission;
                        continue;
                    }
                    throw AbstractUserizedFolderPerformer.invalidPermissions(folder, guestPermission);
                }
                if (!AbstractUserizedFolderPerformer.isReadOnlySharing(folder)) continue;
                AbstractUserizedFolderPerformer.checkReadOnly(folder, guestPermission);
            }
            if (null != newAnonymousPermission && AbstractUserizedFolderPerformer.containsOriginalAnonymousPermission(comparedPermissions)) {
                throw AbstractUserizedFolderPerformer.invalidPermissions(folder, newAnonymousPermission);
            }
        }
    }

    private static boolean containsOriginalAnonymousPermission(ComparedFolderPermissions comparedPermissions) throws OXException {
        Collection originalPermissions = comparedPermissions.getOriginalPermissions();
        if (null != originalPermissions && 0 < originalPermissions.size()) {
            for (Permission originalPermission : originalPermissions) {
                GuestInfo guestInfo;
                if (originalPermission.isGroup() || comparedPermissions.isSystemPermission(originalPermission) || null == (guestInfo = comparedPermissions.getGuestInfo(originalPermission.getEntity())) || !AbstractUserizedFolderPerformer.isAnonymous(guestInfo)) continue;
                return true;
            }
        }
        return false;
    }

    private static void checkGuestPermission(Folder folder, Permission permission, GuestInfo guestInfo) throws OXException {
        if (AbstractUserizedFolderPerformer.isAnonymous(guestInfo)) {
            AbstractUserizedFolderPerformer.checkIsLinkPermission(folder, permission);
            if (AbstractUserizedFolderPerformer.isNotEqualsTarget(folder, guestInfo.getLinkTarget())) {
                throw AbstractUserizedFolderPerformer.invalidPermissions(folder, permission);
            }
        } else if (AbstractUserizedFolderPerformer.isReadOnlySharing(folder)) {
            AbstractUserizedFolderPerformer.checkReadOnly(folder, permission);
        }
    }

    private static boolean isReadOnlySharing(Folder folder) {
        ContentType contentType = folder.getContentType();
        return CalendarContentType.getInstance().equals(contentType) || TaskContentType.getInstance().equals(contentType) || ContactContentType.getInstance().equals(contentType);
    }

    private static OXException invalidPermissions(Folder folder, Permission permission) {
        return FolderExceptionErrorMessage.INVALID_PERMISSIONS.create(Permissions.createPermissionBits(permission), permission.getEntity(), folder.getID() == null ? folder.getName() : folder.getID());
    }

    private static void checkReadOnly(Folder folder, Permission p) throws OXException {
        boolean deleteItems;
        boolean writeFolder = p.getFolderPermission() > 2;
        boolean writeItems = p.getWritePermission() > 0;
        boolean bl = deleteItems = p.getDeletePermission() > 0;
        if (writeFolder || writeItems || deleteItems) {
            throw AbstractUserizedFolderPerformer.invalidPermissions(folder, p);
        }
    }

    private static void checkIsLinkPermission(Folder folder, Permission p) throws OXException {
        if (p.isAdmin() || p.isGroup() || p.getFolderPermission() != 2 || p.getReadPermission() != 4 || p.getWritePermission() != 0 || p.getDeletePermission() != 0) {
            throw AbstractUserizedFolderPerformer.invalidPermissions(folder, p);
        }
    }

    private static boolean isNotEqualsTarget(Folder folder, ShareTarget target) {
        return !new ShareTarget(folder.getContentType().getModule(), folder.getID()).equals((Object)target);
    }

    private static boolean isAnonymous(GuestInfo guestInfo) {
        return guestInfo.getRecipientType() == RecipientType.ANONYMOUS;
    }

    private void hasVisibleSubfolderIDs(Folder folder, String treeId, boolean all, UserizedFolder userizedFolder, boolean nullIsPublicAccess, StorageParameters storageParameters, Collection<FolderStorage> openedStorages) throws OXException {
        String[] stringArray;
        String[] subfolders = folder.getSubfolderIDs();
        String dummyId = null;
        if (null == subfolders) {
            if (nullIsPublicAccess) {
                dummyId = DUMMY_ID;
            } else {
                String folderId = folder.getID();
                FolderStorage[] ss = this.folderStorageDiscoverer.getFolderStoragesForParent(treeId, folderId);
                for (int i = 0; null == dummyId && i < ss.length; ++i) {
                    SortableId[] visibleIds;
                    FolderStorage curStorage = ss[i];
                    boolean alreadyOpened = false;
                    Iterator<FolderStorage> it = openedStorages.iterator();
                    for (int j = 0; !alreadyOpened && j < openedStorages.size(); ++j) {
                        if (!it.next().equals(curStorage)) continue;
                        alreadyOpened = true;
                    }
                    if (!alreadyOpened && curStorage.startTransaction(storageParameters, false)) {
                        openedStorages.add(curStorage);
                    }
                    if ((visibleIds = curStorage.getSubfolders(treeId, folderId, storageParameters)).length <= 0) continue;
                    for (int j = 0; null == dummyId && j < visibleIds.length; ++j) {
                        Permission p;
                        String id = visibleIds[0].getId();
                        Folder subfolder = curStorage.getFolder(treeId, id, storageParameters);
                        if (!all && !subfolder.isSubscribed() && !subfolder.hasSubscribedSubfolders() || !(p = this.session == null ? CalculatePermission.calculate(subfolder, this.user, this.context, this.getAllowedContentTypes()) : CalculatePermission.calculate(subfolder, this.session, this.getAllowedContentTypes())).isVisible()) continue;
                        dummyId = id;
                    }
                }
            }
        } else {
            int length = subfolders.length;
            if (length > 0) {
                if (folder.isGlobalID()) {
                    for (int i = 0; null == dummyId && i < length; ++i) {
                        try {
                            String id = subfolders[i];
                            FolderStorage tmp = this.getOpenedStorage(id, treeId, storageParameters, openedStorages);
                            Folder subfolder = tmp.getFolder(treeId, id, storageParameters);
                            if (!all && !subfolder.isSubscribed() && !subfolder.hasSubscribedSubfolders() || !CalculatePermission.isVisible(subfolder, this.getUser(), this.getContext(), this.getAllowedContentTypes())) continue;
                            dummyId = id;
                            continue;
                        }
                        catch (OXException e) {
                            if ("FLD-0008".equals(e.getErrorCode())) continue;
                            throw e;
                        }
                    }
                } else if (all || folder.hasSubscribedSubfolders()) {
                    dummyId = DUMMY_ID;
                }
            }
        }
        if (null == dummyId) {
            stringArray = new String[]{};
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = dummyId;
        }
        userizedFolder.setSubfolderIDs(stringArray);
    }

    private static long addTimeZoneOffset(long date, TimeZone timeZone) {
        return date + (long)timeZone.getOffset(date);
    }

    private static String enhance(String name, int counter, boolean useParenthesis) {
        if (null == name) {
            return name;
        }
        if (useParenthesis) {
            Matcher matcher = IS_NUMBERED_PARENTHESIS.matcher(name);
            if (matcher.find()) {
                return new StringBuilder(name).replace(matcher.start(), matcher.end(), '(' + String.valueOf(counter) + ')').toString();
            }
            return name + " (" + counter + ')';
        }
        Matcher matcher = IS_NUMBERED.matcher(name);
        if (matcher.find()) {
            return new StringBuilder(name).replace(matcher.start(), matcher.end(), String.valueOf(counter)).toString();
        }
        return name + ' ' + counter;
    }

    protected static UserizedFolder[] trimArray(UserizedFolder[] userizedFolders) {
        if (null == userizedFolders) {
            return new UserizedFolder[0];
        }
        ArrayList<UserizedFolder> l = new ArrayList<UserizedFolder>(userizedFolders.length);
        for (UserizedFolder uf : userizedFolders) {
            if (null == uf) continue;
            l.add(uf);
        }
        return l.toArray(new UserizedFolder[l.size()]);
    }
}

