/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.data.conversion.ical.itip;

import com.openexchange.groupware.calendar.CalendarDataObject;
import com.openexchange.groupware.container.Appointment;
import edu.emory.mathcs.backport.java.util.Collections;
import java.util.ArrayList;
import java.util.List;

public class AppointmentWithExceptions {
    private CalendarDataObject cdao;
    private Appointment appointment;
    private final List<CalendarDataObject> exceptions = new ArrayList<CalendarDataObject>();

    public CalendarDataObject getDataObject() {
        return this.cdao;
    }

    public void setAppointment(CalendarDataObject appointment) {
        this.cdao = appointment;
    }

    public void setAppointment(Appointment appointment) {
        this.appointment = appointment;
    }

    public Appointment getAppointment() {
        if (this.appointment == null) {
            return this.cdao;
        }
        return this.appointment;
    }

    public boolean addException(CalendarDataObject exception) {
        return this.exceptions.add(exception);
    }

    public boolean addException(Appointment exception) {
        if (CalendarDataObject.class.isInstance(exception)) {
            return this.addException((CalendarDataObject)exception);
        }
        CalendarDataObject copy = new CalendarDataObject();
        for (int i : Appointment.ALL_COLUMNS) {
            if (!exception.contains(i)) continue;
            copy.set(i, exception.get(i));
        }
        return this.addException(copy);
    }

    public Iterable<CalendarDataObject> exceptions() {
        return Collections.unmodifiableList(this.exceptions);
    }

    public int numberOfExceptions() {
        return this.exceptions.size();
    }
}

