/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.consistency;

import com.openexchange.consistency.Entity;
import java.io.Serializable;

public class MBeanEntity
implements Serializable {
    private static final long serialVersionUID = -8855542292634493540L;
    private final int contextId;
    private final int userId;
    private final Entity.EntityType type;

    public MBeanEntity(int contextId) {
        this(contextId, -1);
    }

    public MBeanEntity(int contextId, int userId) {
        if (contextId <= 0) {
            throw new IllegalArgumentException("The context identifier cannot be less than or equal to 0");
        }
        this.type = userId <= 0 ? Entity.EntityType.Context : Entity.EntityType.User;
        this.contextId = contextId;
        this.userId = userId;
    }

    public int getContextId() {
        return this.contextId;
    }

    public int getUserId() {
        return this.userId;
    }

    public Entity.EntityType getType() {
        return this.type;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append((Object)this.getType()).append(": { ContextID: '").append(this.getContextId()).append("'");
        if (this.getType().equals((Object)Entity.EntityType.User)) {
            builder.append(", UserID: '").append(this.getUserId()).append("'");
        }
        builder.append("}");
        return builder.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.contextId;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + this.userId;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MBeanEntity other = (MBeanEntity)obj;
        if (this.contextId != other.contextId) {
            return false;
        }
        if (this.type != other.type) {
            return false;
        }
        return this.userId == other.userId;
    }
}

