/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.request;

import com.openexchange.exception.OXException;
import com.openexchange.filestore.FileStorages;
import com.openexchange.filestore.QuotaFileStorage;
import com.openexchange.filestore.QuotaFileStorageService;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.MailServletInterface;
import com.openexchange.server.ServiceExceptionCode;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import com.openexchange.tools.session.ServerSession;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuotaRequest {
    private static final Logger LOG = LoggerFactory.getLogger(QuotaRequest.class);
    private final QuotaFileStorage qfs;
    private final OXException fsException;
    private final ServerSession session;

    public QuotaRequest(ServerSession session) {
        QuotaFileStorage qfs = null;
        OXException fsException = null;
        try {
            qfs = this.getFileStorage(session.getUserId(), session.getContextId());
        }
        catch (OXException e) {
            fsException = e;
        }
        this.qfs = qfs;
        this.fsException = fsException;
        this.session = session;
    }

    private QuotaFileStorage getFileStorage(int userId, int contextId) throws OXException {
        QuotaFileStorageService storageService = FileStorages.getQuotaFileStorageService();
        if (null == storageService) {
            throw ServiceExceptionCode.absentService(QuotaFileStorageService.class);
        }
        return storageService.getQuotaFileStorage(userId, contextId);
    }

    public JSONValue action(String action) throws OXException, JSONException {
        if ("get".equals(action)) {
            return this.filestore();
        }
        if ("filestore".equals(action)) {
            return this.filestore();
        }
        if ("mail".equals(action)) {
            return this.mail();
        }
        throw AjaxExceptionCodes.UNKNOWN_ACTION.create(action);
    }

    private JSONObject filestore() throws OXException, JSONException {
        if (this.fsException != null) {
            throw this.fsException;
        }
        long use = this.qfs.getUsage();
        long quota = this.qfs.getQuota();
        JSONObject data = new JSONObject();
        data.put("quota", quota);
        data.put("use", use);
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JSONObject mail() throws JSONException {
        MailServletInterface mi = null;
        try {
            Object quotaInfo = null;
            try {
                mi = MailServletInterface.getInstance(this.session);
                quotaInfo = mi.getQuotas(new int[]{1, 2});
            }
            catch (OXException e) {
                if (MailExceptionCode.ACCOUNT_DOES_NOT_EXIST.equals(e)) {
                    LOG.debug("", (Throwable)e);
                } else {
                    LOG.error("", (Throwable)e);
                }
                quotaInfo = new long[][]{{-1L, -1L}, {-1L, -1L}};
            }
            JSONObject data = new JSONObject();
            data.put("quota", quotaInfo[0][0] << 10);
            data.put("use", quotaInfo[0][1] << 10);
            data.put("countquota", quotaInfo[1][0]);
            data.put("countuse", quotaInfo[1][1]);
            JSONObject jSONObject = data;
            return jSONObject;
        }
        finally {
            if (mi != null) {
                try {
                    mi.close(false);
                }
                catch (OXException e) {}
            }
        }
    }
}

