/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.login;

import com.openexchange.ajax.LoginServlet;
import com.openexchange.ajax.login.AbstractLoginRequestHandler;
import com.openexchange.ajax.login.LoginClosure;
import com.openexchange.ajax.login.LoginConfiguration;
import com.openexchange.ajax.login.LoginCookiesSetter;
import com.openexchange.ajax.login.LoginRequestImpl;
import com.openexchange.ajax.login.LoginTools;
import com.openexchange.ajax.login.ShareLoginConfiguration;
import com.openexchange.authentication.Authenticated;
import com.openexchange.authentication.BasicAuthenticationService;
import com.openexchange.authentication.LoginExceptionCodes;
import com.openexchange.authentication.LoginInfo;
import com.openexchange.authentication.ResponseEnhancement;
import com.openexchange.authentication.ResultCode;
import com.openexchange.authentication.SessionEnhancement;
import com.openexchange.authentication.service.Authentication;
import com.openexchange.authorization.Authorization;
import com.openexchange.authorization.AuthorizationService;
import com.openexchange.config.ConfigurationService;
import com.openexchange.context.ContextService;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.log.LogProperties;
import com.openexchange.login.LoginRampUpService;
import com.openexchange.login.LoginResult;
import com.openexchange.login.internal.AbstractJsonEnhancingLoginResult;
import com.openexchange.login.internal.AddSessionParameterImpl;
import com.openexchange.login.internal.LoginPerformer;
import com.openexchange.login.listener.LoginListener;
import com.openexchange.login.listener.internal.LoginListenerRegistryImpl;
import com.openexchange.server.ServiceExceptionCode;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.sessiond.AddSessionParameter;
import com.openexchange.sessiond.SessiondService;
import com.openexchange.share.AuthenticationMode;
import com.openexchange.share.GuestInfo;
import com.openexchange.share.ShareExceptionCodes;
import com.openexchange.share.ShareService;
import com.openexchange.share.ShareTarget;
import com.openexchange.share.ShareTargetPath;
import com.openexchange.share.groupware.ModuleSupport;
import com.openexchange.share.groupware.TargetProxy;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import com.openexchange.tools.servlet.http.Cookies;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class AbstractShareBasedLoginRequestHandler
extends AbstractLoginRequestHandler {
    protected final ShareLoginConfiguration conf;

    protected AbstractShareBasedLoginRequestHandler(ShareLoginConfiguration conf, Set<LoginRampUpService> rampUpServices) {
        super(rampUpServices);
        this.conf = conf;
    }

    @Override
    public void handleRequest(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        try {
            this.doLogin(req, resp);
        }
        catch (OXException e) {
            LoginServlet.logAndSendException(resp, e);
        }
    }

    protected void doLogin(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException, OXException {
        String token = httpRequest.getParameter("share");
        if (null == token) {
            throw AjaxExceptionCodes.MISSING_PARAMETER.create("share");
        }
        ShareService shareService = ServerServiceRegistry.getInstance().getService(ShareService.class);
        if (null == shareService) {
            throw ServiceExceptionCode.absentService(ShareService.class);
        }
        final GuestInfo guest = shareService.resolveGuest(token);
        if (null == guest) {
            throw ShareExceptionCodes.UNKNOWN_SHARE.create(new Object[]{token});
        }
        String targetPathParam = httpRequest.getParameter("target");
        if (targetPathParam == null) {
            throw ShareExceptionCodes.UNKNOWN_SHARE.create(new Object[]{token});
        }
        ShareTargetPath targetPath = ShareTargetPath.parse((String)targetPathParam);
        if (targetPath == null) {
            throw ShareExceptionCodes.UNKNOWN_SHARE.create(new Object[]{token});
        }
        ModuleSupport moduleSupport = ServerServiceRegistry.getInstance().getService(ModuleSupport.class);
        int contextId = guest.getContextID();
        int guestId = guest.getGuestID();
        int m = targetPath.getModule();
        String f = targetPath.getFolder();
        String i = targetPath.getItem();
        ShareTarget target = null;
        if (moduleSupport.exists(m, f, i, contextId, guestId) && moduleSupport.isVisible(m, f, i, contextId, guestId)) {
            TargetProxy targetProxy = moduleSupport.resolveTarget(targetPath, contextId, guestId);
            target = targetProxy.getTarget();
        } else {
            List otherTargets = moduleSupport.listTargets(contextId, guestId);
            if (otherTargets.isEmpty()) {
                throw ShareExceptionCodes.UNKNOWN_SHARE.create(new Object[]{token});
            }
            target = ((TargetProxy)otherTargets.get(0)).getTarget();
        }
        LoginConfiguration conf = this.conf.getLoginConfig(guest);
        ShareLoginClosure loginClosure = new ShareLoginClosure(guest, target, targetPath, conf, httpRequest);
        LoginCookiesSetter cookiesSetter = new LoginCookiesSetter(){

            @Override
            public void setLoginCookies(Session session, HttpServletRequest request, HttpServletResponse response, LoginConfiguration loginConfig) throws OXException {
                String altId;
                Map<String, Cookie> cookies;
                Cookie cookie;
                response.addCookie(LoginServlet.configureCookie(new Cookie(LoginServlet.SECRET_PREFIX + session.getHash(), session.getSecret()), request, loginConfig));
                if (loginConfig.isSessiondAutoLogin()) {
                    response.addCookie(LoginServlet.configureCookie(new Cookie(LoginServlet.getShareCookieName(request), guest.getBaseToken()), request, loginConfig));
                }
                if (null == (cookie = (cookies = Cookies.cookieMapFor(request)).get(LoginServlet.getPublicSessionCookieName(request))) && null != (altId = (String)session.getParameter(Session.PARAM_ALTERNATIVE_ID))) {
                    response.addCookie(LoginServlet.configureCookie(new Cookie(LoginServlet.getPublicSessionCookieName(request), altId), request, loginConfig));
                }
            }
        };
        this.loginOperation(httpRequest, httpResponse, loginClosure, cookiesSetter, conf);
    }

    protected abstract boolean checkAuthenticationMode(AuthenticationMode var1) throws OXException;

    protected abstract LoginInfo getLoginInfoFrom(HttpServletRequest var1) throws OXException;

    protected abstract User authenticateUser(GuestInfo var1, LoginInfo var2, Context var3) throws OXException;

    private final class ShareLoginClosure
    implements LoginClosure {
        private final GuestInfo guest;
        private final ShareTarget target;
        private final LoginConfiguration conf;
        private final HttpServletRequest httpRequest;
        private final ShareTargetPath targetPath;

        ShareLoginClosure(GuestInfo guest, ShareTarget target, ShareTargetPath targetPath, LoginConfiguration conf, HttpServletRequest httpRequest) {
            this.guest = guest;
            this.target = target;
            this.conf = conf;
            this.httpRequest = httpRequest;
            this.targetPath = targetPath;
        }

        @Override
        public LoginResult doLogin(HttpServletRequest req) throws OXException {
            List<LoginListener> listeners = LoginListenerRegistryImpl.getInstance().getLoginListeners();
            HashMap<String, Object> properties = new HashMap<String, Object>(1);
            LoginRequestImpl request = null;
            try {
                Session session;
                Map additionals;
                if (!AbstractShareBasedLoginRequestHandler.this.checkAuthenticationMode(this.guest.getAuthentication())) {
                    throw LoginExceptionCodes.INVALID_CREDENTIALS.create();
                }
                BasicAuthenticationService basicService = Authentication.getBasicService();
                if (null == basicService) {
                    throw ServiceExceptionCode.absentService(BasicAuthenticationService.class);
                }
                LoginInfo loginInfo = AbstractShareBasedLoginRequestHandler.this.getLoginInfoFrom(this.httpRequest);
                ContextService contextService = ServerServiceRegistry.getInstance().getService(ContextService.class);
                if (null == contextService) {
                    throw ServiceExceptionCode.absentService(ContextService.class);
                }
                Context context = contextService.getContext(this.guest.getContextID());
                User user = AbstractShareBasedLoginRequestHandler.this.authenticateUser(this.guest, loginInfo, context);
                String[] additionalsForHash = new String[]{String.valueOf(context.getContextId()), String.valueOf(user.getId())};
                String client = LoginTools.parseClient(this.httpRequest, false, this.conf.getDefaultClient());
                request = LoginTools.parseLogin(this.httpRequest, loginInfo.getUsername(), loginInfo.getPassword(), false, client, this.conf.isCookieForceHTTPS(), false, additionalsForHash);
                LoginPerformer.sanityChecks(request);
                LoginPerformer.checkClient(request, user, context);
                for (LoginListener listener : listeners) {
                    listener.onBeforeAuthentication(request, properties);
                }
                Authenticated authenticated = basicService.handleLoginInfo(this.guest.getGuestID(), this.guest.getContextID());
                if (null == authenticated) {
                    return null;
                }
                AuthorizationService authService = Authorization.getService();
                if (null == authService) {
                    throw ServiceExceptionCode.absentService(AuthorizationService.class);
                }
                authService.authorizeUser(context, user);
                SessiondService sessiondService = (SessiondService)SessiondService.SERVICE_REFERENCE.get();
                if (null == sessiondService && null == (sessiondService = ServerServiceRegistry.getInstance().getService(SessiondService.class))) {
                    throw ServiceExceptionCode.absentService(SessiondService.class);
                }
                ConfigurationService service = ServerServiceRegistry.getInstance().getService(ConfigurationService.class);
                boolean tranzient = null == service || service.getBoolProperty("com.openexchange.share.transientSessions", true);
                request.setTransient(tranzient);
                AddSessionParameterImpl sessionToAdd = new AddSessionParameterImpl(loginInfo.getUsername(), request, user, context);
                Map map = additionals = null != this.targetPath ? this.targetPath.getAdditionals() : null;
                if (null != additionals && 0 < additionals.size()) {
                    sessionToAdd.setEnhancement(new SessionEnhancement(){

                        public void enhanceSession(Session session) {
                            for (Map.Entry entry : additionals.entrySet()) {
                                session.setParameter("com.openexchange.share." + (String)entry.getKey(), entry.getValue());
                            }
                        }
                    });
                }
                if (null == (session = sessiondService.addSession((AddSessionParameter)sessionToAdd))) {
                    throw LoginExceptionCodes.UNKNOWN.create(new Object[]{"Session could not be created."});
                }
                session.setParameter(Session.PARAM_GUEST, (Object)Boolean.TRUE);
                if (SessionEnhancement.class.isInstance(authenticated)) {
                    ((SessionEnhancement)authenticated).enhanceSession(session);
                }
                LogProperties.putSessionProperties((Session)session);
                AbstractJsonEnhancingLoginResult retval = new AbstractJsonEnhancingLoginResult(){

                    @Override
                    protected void doEnhanceJson(JSONObject jLoginResult) throws OXException, JSONException {
                        if (ShareLoginClosure.this.target.getModule() > 0) {
                            String folderModule = ServerServiceRegistry.getInstance().getService(ModuleSupport.class).getShareModule(ShareLoginClosure.this.target.getModule());
                            if ("infostore".equals(folderModule)) {
                                folderModule = "files";
                            }
                            jLoginResult.put("module", (Object)folderModule);
                        }
                        jLoginResult.putOpt("folder", (Object)ShareLoginClosure.this.target.getFolder());
                        jLoginResult.putOpt("item", (Object)ShareLoginClosure.this.target.getItem());
                    }
                };
                retval.setContext(context);
                retval.setUser(user);
                retval.setRequest(request);
                retval.setServerToken((String)session.getParameter("serverToken"));
                retval.setSession(session);
                if (authenticated instanceof ResponseEnhancement) {
                    ResponseEnhancement responseEnhancement = (ResponseEnhancement)authenticated;
                    retval.setHeaders(responseEnhancement.getHeaders());
                    retval.setCookies(responseEnhancement.getCookies());
                    retval.setRedirect(responseEnhancement.getRedirect());
                    ResultCode code = responseEnhancement.getCode();
                    retval.setCode(code);
                    if (ResultCode.REDIRECT.equals((Object)code) || ResultCode.FAILED.equals((Object)code)) {
                        if (ResultCode.FAILED.equals((Object)code)) {
                            for (LoginListener listener : listeners) {
                                listener.onFailedAuthentication(request, properties, null);
                            }
                        } else if (ResultCode.REDIRECT.equals((Object)code)) {
                            for (LoginListener listener : listeners) {
                                listener.onRedirectedAuthentication(request, properties, null);
                            }
                        }
                        return retval;
                    }
                }
                LoginPerformer.triggerLoginHandlers(retval);
                for (LoginListener listener : listeners) {
                    listener.onSucceededAuthentication(retval);
                }
                return retval;
            }
            catch (OXException e) {
                if (null != request) {
                    if (LoginExceptionCodes.REDIRECT.equals(e)) {
                        for (LoginListener listener : listeners) {
                            listener.onRedirectedAuthentication(request, properties, e);
                        }
                    } else {
                        for (LoginListener listener : listeners) {
                            listener.onFailedAuthentication(request, properties, e);
                        }
                    }
                }
                throw e;
            }
            catch (RuntimeException e) {
                OXException oxe = AjaxExceptionCodes.UNEXPECTED_ERROR.create(e, e.getMessage());
                if (null != request) {
                    for (LoginListener listener : listeners) {
                        listener.onFailedAuthentication(request, properties, oxe);
                    }
                }
                throw oxe;
            }
        }
    }
}

