/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.net;

import com.openexchange.junit.Warn;
import com.openexchange.tools.net.URIDefaults;
import com.openexchange.tools.net.URIParser;
import java.net.URI;
import java.net.URISyntaxException;
import org.junit.Assert;
import org.junit.Test;

public class URIParserTest {
    private static final boolean WARN = true;

    @Test
    public void testProtIPv6Port() throws URISyntaxException {
        URIParserTest.test("imap://[fc00::2]:143", "imap", "[fc00::2]", 143);
    }

    @Test
    public void testProtIPv6() throws URISyntaxException {
        URIParserTest.test("imap://[fc00::2]", "imap", "[fc00::2]", -1);
    }

    @Test
    public void testIPv6Port() throws URISyntaxException {
        URIParserTest.test("[fc00::2]:143", null, "[fc00::2]", 143);
    }

    @Test
    public void testIPv6() throws URISyntaxException {
        URIParserTest.test("fc00::2", null, "[fc00::2]", -1);
    }

    @Test
    public void testProtIPv4Port() throws URISyntaxException {
        URIParserTest.test("imap://192.168.32.134:143", "imap", "192.168.32.134", 143);
    }

    @Test
    public void testProtIPv4() throws URISyntaxException {
        URIParserTest.test("imap://192.168.32.134", "imap", "192.168.32.134", -1);
    }

    @Test
    public void testIPv4Port() throws URISyntaxException {
        URIParserTest.test("192.168.32.134:143", null, "192.168.32.134", 143);
    }

    @Test
    public void testIPv4() throws URISyntaxException {
        URIParserTest.test("192.168.32.134", null, "192.168.32.134", -1);
    }

    @Test
    public void testProtHostPort() throws URISyntaxException {
        URIParserTest.test("imap://devel-mail.example.org:143", "imap", "devel-mail.example.org", 143);
    }

    @Test
    public void testProtHost() throws URISyntaxException {
        URIParserTest.test("imap://devel-mail.example.org", "imap", "devel-mail.example.org", -1);
    }

    @Test
    public void testHostPort() throws URISyntaxException {
        URIParserTest.test("devel-mail.example.org:143", null, "devel-mail.example.org", 143);
    }

    @Test
    public void testHost() throws URISyntaxException {
        URIParserTest.test("devel-mail.example.org", null, "devel-mail.example.org", -1);
    }

    @Test
    public void imapProtIPv6Port() throws URISyntaxException {
        URIParserTest.test("imap://[fc00::2]:143", "imap", "[fc00::2]", 143, URIDefaults.IMAP);
    }

    @Test
    public void imapProtIPv6OtherPort() throws URISyntaxException {
        URIParserTest.test("imap://[fc00::2]:144", "imap", "[fc00::2]", 144, URIDefaults.IMAP);
    }

    @Test
    public void imapProtIPv6() throws URISyntaxException {
        URIParserTest.test("imap://[fc00::2]", "imap", "[fc00::2]", 143, URIDefaults.IMAP);
    }

    @Test
    public void imapIPv6Port() throws URISyntaxException {
        URIParserTest.test("[fc00::2]:143", "imap", "[fc00::2]", 143, URIDefaults.IMAP);
    }

    @Test
    public void imapIPv6OtherPort() throws URISyntaxException {
        URIParserTest.test("[fc00::2]:144", "imap", "[fc00::2]", 144, URIDefaults.IMAP);
    }

    @Test
    public void imapIPv6() throws URISyntaxException {
        URIParserTest.test("fc00::2", "imap", "[fc00::2]", 143, URIDefaults.IMAP);
    }

    @Test
    public void imapProtIPv4Port() throws URISyntaxException {
        URIParserTest.test("imap://192.168.32.134:143", "imap", "192.168.32.134", 143, URIDefaults.IMAP);
    }

    @Test
    public void imapProtIPv4therPort() throws URISyntaxException {
        URIParserTest.test("imap://192.168.32.134:144", "imap", "192.168.32.134", 144, URIDefaults.IMAP);
    }

    @Test
    public void imapProtIPv4() throws URISyntaxException {
        URIParserTest.test("imap://192.168.32.134", "imap", "192.168.32.134", 143, URIDefaults.IMAP);
    }

    @Test
    public void imapIPv4Port() throws URISyntaxException {
        URIParserTest.test("192.168.32.134:143", "imap", "192.168.32.134", 143, URIDefaults.IMAP);
    }

    @Test
    public void imapIPv4OtherPort() throws URISyntaxException {
        URIParserTest.test("192.168.32.134:144", "imap", "192.168.32.134", 144, URIDefaults.IMAP);
    }

    @Test
    public void imapIPv4() throws URISyntaxException {
        URIParserTest.test("192.168.32.134", "imap", "192.168.32.134", 143, URIDefaults.IMAP);
    }

    @Test
    public void imapProtHostPort() throws URISyntaxException {
        URIParserTest.test("imap://devel-mail.example.org:143", "imap", "devel-mail.example.org", 143, URIDefaults.IMAP);
    }

    @Test
    public void imapProtHostOtherPort() throws URISyntaxException {
        URIParserTest.test("imap://devel-mail.example.org:144", "imap", "devel-mail.example.org", 144, URIDefaults.IMAP);
    }

    @Test
    public void imapProtHost() throws URISyntaxException {
        URIParserTest.test("imap://devel-mail.example.org", "imap", "devel-mail.example.org", 143, URIDefaults.IMAP);
    }

    @Test
    public void imapHostPort() throws URISyntaxException {
        URIParserTest.test("devel-mail.example.org:143", "imap", "devel-mail.example.org", 143, URIDefaults.IMAP);
    }

    @Test
    public void imapHostOtherPort() throws URISyntaxException {
        URIParserTest.test("devel-mail.example.org:144", "imap", "devel-mail.example.org", 144, URIDefaults.IMAP);
    }

    @Test
    public void imapHost() throws URISyntaxException {
        URIParserTest.test("devel-mail.example.org", "imap", "devel-mail.example.org", 143, URIDefaults.IMAP);
    }

    @Test
    public void imapsProtIPv6Port() throws URISyntaxException {
        URIParserTest.test("imaps://[fc00::2]:993", "imaps", "[fc00::2]", 993, URIDefaults.IMAP);
    }

    @Test
    public void imapsProtIPv6OtherPort() throws URISyntaxException {
        URIParserTest.test("imaps://[fc00::2]:994", "imaps", "[fc00::2]", 994, URIDefaults.IMAP);
    }

    @Test
    public void imapsProtIPv6() throws URISyntaxException {
        URIParserTest.test("imaps://[fc00::2]", "imaps", "[fc00::2]", 993, URIDefaults.IMAP);
    }

    @Test
    public void imapsIPv6Port() throws URISyntaxException {
        URIParserTest.test("[fc00::2]:993", "imaps", "[fc00::2]", 993, URIDefaults.IMAP);
    }

    @Test
    public void imapsProtIPv4Port() throws URISyntaxException {
        URIParserTest.test("imaps://192.168.32.134:993", "imaps", "192.168.32.134", 993, URIDefaults.IMAP);
    }

    @Test
    public void imapsProtIPv4OtherPort() throws URISyntaxException {
        URIParserTest.test("imaps://192.168.32.134:994", "imaps", "192.168.32.134", 994, URIDefaults.IMAP);
    }

    @Test
    public void imapsProtIPv4() throws URISyntaxException {
        URIParserTest.test("imaps://192.168.32.134", "imaps", "192.168.32.134", 993, URIDefaults.IMAP);
    }

    @Test
    public void imapsIPv4Port() throws URISyntaxException {
        URIParserTest.test("192.168.32.134:993", "imaps", "192.168.32.134", 993, URIDefaults.IMAP);
    }

    @Test
    public void imapsProtHostPort() throws URISyntaxException {
        URIParserTest.test("imaps://devel-mail.example.org:993", "imaps", "devel-mail.example.org", 993, URIDefaults.IMAP);
    }

    @Test
    public void imapsProtHostOtherPort() throws URISyntaxException {
        URIParserTest.test("imaps://devel-mail.example.org:994", "imaps", "devel-mail.example.org", 994, URIDefaults.IMAP);
    }

    @Test
    public void imapsProtHost() throws URISyntaxException {
        URIParserTest.test("imaps://devel-mail.example.org", "imaps", "devel-mail.example.org", 993, URIDefaults.IMAP);
    }

    @Test
    public void imapsHostPort() throws URISyntaxException {
        URIParserTest.test("devel-mail.example.org:993", "imaps", "devel-mail.example.org", 993, URIDefaults.IMAP);
    }

    private static final void test(String s, String scheme, String host, int port) throws URISyntaxException {
        URIParserTest.test(s, scheme, host, port, URIDefaults.NULL);
    }

    private static final void test(String s, String scheme, String host, int port, URIDefaults defaults) throws URISyntaxException {
        URI uri = URIParser.parse((String)s, (URIDefaults)defaults);
        Assert.assertEquals((String)("Protocol not correctly detected: \"" + s + "\"."), (Object)scheme, (Object)uri.getScheme());
        Assert.assertEquals((String)("Host not correctly detected: \"" + s + "\"."), (Object)host, (Object)uri.getHost());
        Assert.assertEquals((String)("Port not correctly detected: \"" + s + "\"."), (long)port, (long)uri.getPort());
        String expected = new URI(scheme, null, host, port, null, null, null).toString();
        Assert.assertEquals((String)("toString does not work: \"" + s + "\"."), (Object)expected, (Object)uri.toString());
        try {
            uri = new URI(s);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        Warn.warnEquals((String)("Protocol not correctly detected: \"" + s + "\"."), (Object)scheme, (Object)uri.getScheme());
        Warn.warnEquals((String)("Host not correctly detected: \"" + s + "\"."), (Object)host, (Object)uri.getHost());
        Warn.warnEquals((String)"Port not correctly detected.", (long)port, (long)uri.getPort());
        Warn.warnEquals((String)("toString does not work: \"" + s + "\"."), (Object)expected, (Object)uri.toString());
    }
}

