/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.i18n.tools.replacement;

import com.openexchange.i18n.I18nService;
import com.openexchange.i18n.tools.TemplateToken;
import com.openexchange.i18n.tools.replacement.FormatLocalizedStringReplacement;
import com.openexchange.server.services.I18nServices;
import java.util.Locale;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={I18nServices.class})
public class FormatLocalizedStringReplacementTest {
    private FormatLocalizedStringReplacement formatLocalizedStringReplacement;
    private String format = "Priority: %1$s";
    private String formatTranslated = "Priorit\\u00e4t: %1$s";
    private String result = "Priorit\\u00e4t: Niedrig";
    private String replacement = "Low";
    private Locale locale = new Locale("de_DE");
    private TemplateToken templateToken = TemplateToken.TASK_PRIORITY;
    @Mock
    private I18nServices i18nServices;
    @Mock
    private I18nService i18nService;

    @Before
    public void setUp() throws Exception {
        this.formatLocalizedStringReplacement = new FormatLocalizedStringReplacement(this.templateToken, this.format, this.replacement);
        this.formatLocalizedStringReplacement.setChanged(false);
        this.formatLocalizedStringReplacement.setLocale(this.locale);
        PowerMockito.mockStatic(I18nServices.class, (Class[])new Class[0]);
        PowerMockito.when((Object)this.i18nServices.getService(this.locale)).thenReturn((Object)this.i18nService);
        PowerMockito.when((Object)this.i18nService.getLocalized(this.format)).thenReturn((Object)this.formatTranslated);
        PowerMockito.when((Object)this.i18nService.getLocalized(this.replacement)).thenReturn((Object)"Niedrig");
        PowerMockito.when((Object)I18nServices.getInstance()).thenReturn((Object)this.i18nServices);
    }

    @Test
    public void testGetReplacement_replacementObjectStateFine_returnTranslatedPrioritySentence() {
        String replacedString = this.formatLocalizedStringReplacement.getReplacement();
        Assert.assertEquals((String)"String not localized", (Object)this.result, (Object)replacedString);
    }
}

