/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.osgi.util;

import org.osgi.framework.ServiceReference;

public final class RankedService<S>
implements Comparable<RankedService<S>> {
    public final S service;
    public final int ranking;
    private final int hash;

    public RankedService(S service, int ranking) {
        this.service = service;
        this.ranking = ranking;
        this.hash = 31 + (service == null ? 0 : service.hashCode());
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof RankedService)) {
            return false;
        }
        RankedService other = (RankedService)obj;
        return !(this.service == null ? other.service != null : !this.service.equals(other.service));
    }

    @Override
    public int compareTo(RankedService<S> o) {
        int thisVal = this.ranking;
        int anotherVal = o.ranking;
        return thisVal < anotherVal ? 1 : (thisVal == anotherVal ? 0 : -1);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(128);
        builder.append("RankedService [");
        if (this.service != null) {
            builder.append("service=").append(this.service).append(", ");
        }
        builder.append("ranking=").append(this.ranking).append("]");
        return builder.toString();
    }

    public static <S> int getRanking(ServiceReference<S> reference) {
        return RankedService.getRanking(reference, 0);
    }

    public static <S> int getRanking(ServiceReference<S> reference, int defaultRanking) {
        int ranking = defaultRanking;
        Object oRanking = reference.getProperty("service.ranking");
        if (null != oRanking) {
            if (oRanking instanceof Integer) {
                ranking = (Integer)oRanking;
            } else {
                try {
                    ranking = Integer.parseInt(oRanking.toString().trim());
                }
                catch (NumberFormatException e) {
                    ranking = defaultRanking;
                }
            }
        }
        return ranking;
    }
}

