/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.osgi;

import com.openexchange.osgi.DeferredActivator;
import com.openexchange.osgi.ExceptionUtils;
import com.openexchange.osgi.Tools;
import com.openexchange.osgi.console.ServiceStateLookup;
import com.openexchange.server.ServiceLookup;
import com.openexchange.server.SimpleServiceLookup;
import java.util.ArrayList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DependentServiceStarter
extends ServiceTracker<Object, Object> {
    private static final Logger LOG = LoggerFactory.getLogger(DependentServiceStarter.class);
    private final Lock lock = new ReentrantLock();
    protected final BundleContext context;
    private final Class<?>[] neededServices;
    private final Class<?>[] optionalServices;
    private final Object[] foundServices;
    private SimpleServiceLookup serviceLookup = new SimpleServiceLookup();
    private boolean started = false;

    public DependentServiceStarter(BundleContext context, Class<?> ... neededServices) throws InvalidSyntaxException {
        super(context, Tools.generateServiceFilter(context, neededServices), null);
        this.context = context;
        this.neededServices = neededServices;
        this.optionalServices = new Class[0];
        this.foundServices = new Object[neededServices.length];
        this.setState();
    }

    public DependentServiceStarter(BundleContext context, Class<?>[] neededServices, Class<?>[] optionalServices) throws InvalidSyntaxException {
        super(context, Tools.generateServiceFilter(context, DependentServiceStarter.joinArrays(neededServices, optionalServices)), null);
        this.context = context;
        this.neededServices = neededServices;
        this.optionalServices = optionalServices;
        this.foundServices = new Object[neededServices.length];
        this.setState();
    }

    protected abstract void start(ServiceLookup var1) throws Exception;

    protected abstract void stop(ServiceLookup var1) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object addingService(ServiceReference<Object> reference) {
        Object service = this.context.getService(reference);
        if (service == null) {
            return null;
        }
        boolean needsStart = true;
        this.lock.lock();
        try {
            int i;
            for (i = 0; i < this.neededServices.length; ++i) {
                if (this.neededServices[i].isAssignableFrom(service.getClass())) {
                    this.foundServices[i] = service;
                }
                needsStart &= null != this.foundServices[i];
            }
            for (i = 0; i < this.optionalServices.length; ++i) {
                Class<?> clazz = this.optionalServices[i];
                if (!clazz.isAssignableFrom(service.getClass())) continue;
                this.serviceLookup.add(clazz, service);
            }
            if (needsStart &= !this.started) {
                for (i = 0; i < this.neededServices.length; ++i) {
                    if (service == null) continue;
                    this.serviceLookup.add(this.neededServices[i], this.foundServices[i]);
                }
                this.startSafe((ServiceLookup)this.serviceLookup);
            }
        }
        finally {
            this.lock.unlock();
        }
        this.setState();
        return service;
    }

    public void modifiedService(ServiceReference<Object> reference, Object service) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removedService(ServiceReference<Object> reference, Object service) {
        this.lock.lock();
        try {
            Class<?> clazz;
            int i;
            boolean someServiceMissing = false;
            for (i = 0; i < this.neededServices.length; ++i) {
                clazz = this.neededServices[i];
                if (clazz.isAssignableFrom(service.getClass())) {
                    this.foundServices[i] = null;
                    this.serviceLookup.add(clazz, service);
                }
                someServiceMissing |= null == this.foundServices[i];
            }
            for (i = 0; i < this.optionalServices.length; ++i) {
                clazz = this.optionalServices[i];
                if (!clazz.isAssignableFrom(service.getClass())) continue;
                this.serviceLookup.remove(clazz);
            }
            if (this.started && someServiceMissing) {
                this.stopSafe((ServiceLookup)this.serviceLookup);
                this.serviceLookup = new SimpleServiceLookup();
            }
        }
        finally {
            this.lock.unlock();
        }
        this.setState();
        this.context.ungetService(reference);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.lock.lock();
        try {
            if (this.started) {
                this.stopSafe((ServiceLookup)this.serviceLookup);
            }
        }
        finally {
            this.lock.unlock();
            super.close();
        }
    }

    private void startSafe(ServiceLookup services) {
        try {
            this.start(services);
            this.started = true;
        }
        catch (Throwable t) {
            ExceptionUtils.handleThrowable(t);
            LOG.error("start() failed for {}", (Object)((Object)((Object)this)).getClass().getName(), (Object)t);
        }
    }

    private void stopSafe(ServiceLookup services) {
        try {
            this.stop(services);
            this.started = false;
        }
        catch (Throwable t) {
            ExceptionUtils.handleThrowable(t);
            LOG.error("stop() failed for {}", (Object)((Object)((Object)this)).getClass().getName(), (Object)t);
        }
    }

    private void setState() {
        ServiceStateLookup lookup = DeferredActivator.getLookup();
        ArrayList<String> missing = new ArrayList<String>();
        ArrayList<String> present = new ArrayList<String>();
        for (int i = 0; i < this.neededServices.length; ++i) {
            String serviceName = this.neededServices[i].getName();
            if (null == this.foundServices[i]) {
                missing.add(serviceName);
                continue;
            }
            present.add(serviceName);
        }
        lookup.setState(this.context.getBundle().getSymbolicName(), missing, present);
    }

    private static Class<?>[] joinArrays(Class<?>[] neededServices, Class<?>[] optionalServices) {
        int j;
        Class[] allServices = new Class[neededServices.length + optionalServices.length];
        int i = 0;
        for (j = 0; j < neededServices.length; ++j) {
            allServices[i++] = neededServices[j];
        }
        for (j = 0; j < optionalServices.length; ++j) {
            allServices[i++] = optionalServices[j];
        }
        return allServices;
    }
}

