/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.java;

import com.openexchange.java.AbstractHashKeyCollection;
import com.openexchange.java.HashKey;
import com.openexchange.java.HashKeyEntrySet;
import com.openexchange.java.HashKeyGenerator;
import com.openexchange.java.HashKeySet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public final class HashKeyMap<V>
extends AbstractHashKeyCollection<HashKeyMap<V>>
implements Map<String, V> {
    private final Map<HashKey, V> map;

    public HashKeyMap() {
        this(new HashMap());
    }

    public HashKeyMap(int initialCapacity) {
        this(new HashMap(initialCapacity));
    }

    public HashKeyMap(Map<HashKey, V> map) {
        this.map = map;
    }

    @Override
    protected HashKeyMap<V> thisCollection() {
        return this;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(this.newKey(key.toString()));
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public V get(Object key) {
        return this.map.get(this.newKey(key.toString()));
    }

    @Override
    public V put(String key, V value) {
        return this.map.put(this.newKey(key), value);
    }

    @Override
    public V remove(Object key) {
        return this.map.remove(this.newKey(key.toString()));
    }

    @Override
    public void putAll(Map<? extends String, ? extends V> m) {
        if (null == m || m.isEmpty()) {
            return;
        }
        for (Map.Entry<String, V> e : m.entrySet()) {
            this.map.put(this.newKey(e.getKey()), e.getValue());
        }
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public Set<String> keySet() {
        return (Set)new HashKeySet(this.map.keySet()).setGenerator((HashKeyGenerator)this.generatorReference.get());
    }

    @Override
    public Collection<V> values() {
        return this.map.values();
    }

    @Override
    public Set<Map.Entry<String, V>> entrySet() {
        return (Set)new HashKeyEntrySet<V>(this.map.entrySet()).setGenerator((HashKeyGenerator)this.generatorReference.get());
    }

    @Override
    public boolean equals(Object o) {
        return this.map.equals(o);
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }

    public String toString() {
        return this.map.toString();
    }
}

