/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.java;

import java.util.AbstractQueue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.PriorityQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public class BufferingQueue<E>
extends AbstractQueue<E>
implements BlockingQueue<E> {
    final transient ReentrantLock lock = new ReentrantLock();
    final PriorityQueue<BufferedElement<E>> q = new PriorityQueue();
    private Thread leader = null;
    private final Condition available = this.lock.newCondition();
    private final long defaultDelayDuration;
    private final long defaultMaxDelayDuration;

    public BufferingQueue() {
        this(0L, 0L);
    }

    public BufferingQueue(long defaultDelayDuration) {
        this(defaultDelayDuration, 0L);
    }

    public BufferingQueue(long defaultDelayDuration, long defaultMaxDelayDuration) {
        this.defaultDelayDuration = defaultDelayDuration;
        this.defaultMaxDelayDuration = defaultMaxDelayDuration;
    }

    public BufferingQueue(Collection<? extends E> c) {
        this(c, 0L);
    }

    public BufferingQueue(Collection<? extends E> c, long defaultDelayDuration) {
        this(c, defaultDelayDuration, 0L);
    }

    public BufferingQueue(Collection<? extends E> c, long defaultDelayDuration, long defaultMaxDelayDuration) {
        this(defaultDelayDuration, defaultMaxDelayDuration);
        this.addAll(c);
    }

    @Override
    public boolean add(E e) {
        return this.offer(e);
    }

    @Override
    public boolean offer(E e) {
        return this.offer(e, this.defaultDelayDuration, this.defaultMaxDelayDuration);
    }

    public boolean offer(E e, long delayDuration) {
        return this.offer(e, delayDuration, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean offer(E e, long delayDuration, long maxDelayDuration) {
        BufferedElement<E> delayedE = new BufferedElement<E>(e, delayDuration, maxDelayDuration);
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            this.q.offer(delayedE);
            if (this.q.peek() == delayedE) {
                this.leader = null;
                this.available.signal();
            }
            boolean bl = true;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    public boolean offerImmediately(E e) {
        return this.offer(e, 0L, 0L);
    }

    public boolean offerIfAbsent(E e) {
        return this.offerIfAbsent(e, this.defaultDelayDuration, this.defaultMaxDelayDuration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean offerIfAbsent(E e, long delayDuration, long maxDelayDuration) {
        BufferedElement<E> delayedE = new BufferedElement<E>(e, delayDuration, maxDelayDuration);
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            if (this.contains(delayedE)) {
                boolean bl = false;
                return bl;
            }
            this.q.offer(delayedE);
            if (this.q.peek() == delayedE) {
                this.leader = null;
                this.available.signal();
            }
            boolean bl = true;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    public boolean offerIfAbsentElseReset(E e) {
        return this.offerIfAbsentElseReset(e, this.defaultDelayDuration, this.defaultMaxDelayDuration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean offerIfAbsentElseReset(E e, long delayDuration, long maxDelayDuration) {
        BufferedElement<E> delayedE = new BufferedElement<E>(e, delayDuration, maxDelayDuration);
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            BufferedElement<E> prev = null;
            Iterator<BufferedElement<E>> it = this.q.iterator();
            while (null == prev && it.hasNext()) {
                BufferedElement<E> next = it.next();
                if (!delayedE.equals(next)) continue;
                prev = next;
                it.remove();
            }
            if (null != prev) {
                prev.reset();
                this.q.offer(prev);
                boolean bl = false;
                return bl;
            }
            this.q.offer(delayedE);
            if (this.q.peek() == delayedE) {
                this.leader = null;
                this.available.signal();
            }
            boolean bl = true;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    public boolean offerIfAbsentElseReset(Collection<? extends E> c) {
        return this.offerIfAbsentElseReset(c, this.defaultDelayDuration, this.defaultMaxDelayDuration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean offerIfAbsentElseReset(Collection<? extends E> c, long delayDuration, long maxDelayDuration) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            ArrayList<E> elementsToAdd = new ArrayList<E>(c);
            block4: for (BufferedElement<E> bufferedElement : this.q) {
                Iterator elementsIterator = elementsToAdd.iterator();
                while (elementsIterator.hasNext()) {
                    Object element = elementsIterator.next();
                    if (!bufferedElement.equals(element)) continue;
                    bufferedElement.reset();
                    elementsIterator.remove();
                    continue block4;
                }
            }
            if (elementsToAdd.isEmpty()) {
                boolean bufferedElement = false;
                return bufferedElement;
            }
            boolean signal = false;
            for (Object e : elementsToAdd) {
                BufferedElement delayedE = new BufferedElement(e, delayDuration, maxDelayDuration);
                this.q.offer(delayedE);
                signal |= this.q.peek() == delayedE;
            }
            if (signal) {
                this.leader = null;
                this.available.signal();
            }
            boolean bl = true;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    public E offerOrReplaceImmediately(E e) {
        return this.offerOrReplace(e, 0L, 0L);
    }

    public E offerOrReplace(E e) {
        return this.offerOrReplace(e, this.defaultDelayDuration, this.defaultMaxDelayDuration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public E offerOrReplace(E e, long delayDuration, long maxDelayDuration) {
        BufferedElement<E> delayedE = new BufferedElement<E>(e, delayDuration, maxDelayDuration);
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            BufferedElement<E> prev = null;
            Iterator<BufferedElement<E>> it = this.q.iterator();
            while (null == prev && it.hasNext()) {
                BufferedElement<E> next = it.next();
                if (!delayedE.equals(next)) continue;
                prev = next;
                it.remove();
            }
            this.q.offer(delayedE);
            if (this.q.peek() == delayedE) {
                this.leader = null;
                this.available.signal();
            }
            E e2 = null == prev ? null : (E)prev.getElement();
            return e2;
        }
        finally {
            lock.unlock();
        }
    }

    public E offerOrReplaceAndReset(E e) {
        return this.offerOrReplaceAndReset(e, this.defaultDelayDuration, this.defaultMaxDelayDuration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public E offerOrReplaceAndReset(E e, long delayDuration, long maxDelayDuration) {
        BufferedElement<E> delayedE = new BufferedElement<E>(e, delayDuration, maxDelayDuration);
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            BufferedElement<E> prev = null;
            Iterator<BufferedElement<E>> it = this.q.iterator();
            while (null == prev && it.hasNext()) {
                BufferedElement<E> next = it.next();
                if (!delayedE.equals(next)) continue;
                prev = next;
                delayedE = new BufferedElement<E>(e, prev);
                delayedE.reset();
                it.remove();
            }
            this.q.offer(delayedE);
            if (this.q.peek() == delayedE) {
                this.leader = null;
                this.available.signal();
            }
            E e2 = null == prev ? null : (E)prev.getElement();
            return e2;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public void put(E e) {
        this.offer(e);
    }

    @Override
    public boolean offer(E e, long timeout, TimeUnit unit) {
        return this.offer(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E poll() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            BufferedElement<E> first = this.q.peek();
            E e = first == null || first.getDelay(TimeUnit.NANOSECONDS) > 0L ? null : (E)this.q.poll().getElement();
            return e;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public E take() throws InterruptedException {
        lock = this.lock;
        lock.lockInterruptibly();
        block7: while (true) {
            while (true) lbl-1000:
            // 4 sources

            {
                if ((first = this.q.peek()) == null) {
                    this.available.await();
                    continue block7;
                }
                delay = first.getDelay(TimeUnit.NANOSECONDS);
                if (delay <= 0L) {
                    var5_4 = this.q.poll().getElement();
                    return var5_4;
                }
                if (this.leader != null) {
                    this.available.await();
                    continue;
                }
                this.leader = thisThread = Thread.currentThread();
                try {
                    this.available.awaitNanos(delay);
                }
                finally {
                    if (this.leader != thisThread) continue;
                    this.leader = null;
                    continue;
                }
                break;
            }
            break;
        }
        ** GOTO lbl-1000
        finally {
            if (this.leader == null && this.q.peek() != null) {
                this.available.signal();
            }
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public E poll(long timeout, TimeUnit unit) throws InterruptedException {
        nanos = unit.toNanos(timeout);
        lock = this.lock;
        lock.lockInterruptibly();
        while (true) lbl-1000:
        // 5 sources

        {
            if ((first = this.q.peek()) == null) {
                if (nanos <= 0L) {
                    var8_7 = null;
                    return var8_7;
                }
                nanos = this.available.awaitNanos(nanos);
                continue;
            }
            delay = first.getDelay(TimeUnit.NANOSECONDS);
            if (delay <= 0L) {
                var10_8 = this.q.poll().getElement();
                return var10_8;
            }
            if (nanos <= 0L) {
                var10_8 = null;
                return var10_8;
            }
            if (nanos < delay || this.leader != null) {
                nanos = this.available.awaitNanos(nanos);
                continue;
            }
            this.leader = thisThread = Thread.currentThread();
            try {
                timeLeft = this.available.awaitNanos(delay);
                nanos -= delay - timeLeft;
            }
            finally {
                if (this.leader != thisThread) continue;
                this.leader = null;
                continue;
            }
            break;
        }
        ** GOTO lbl-1000
        finally {
            if (this.leader == null && this.q.peek() != null) {
                this.available.signal();
            }
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E peek() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            BufferedElement<E> delayedE = this.q.peek();
            E e = null != delayedE ? (E)delayedE.getElement() : null;
            return e;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            int n = this.q.size();
            return n;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public int drainTo(Collection<? super E> c) {
        return this.drainTo(c, Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int drainTo(Collection<? super E> c, int maxElements) {
        if (c == null) {
            throw new NullPointerException();
        }
        if (c == this) {
            throw new IllegalArgumentException();
        }
        if (maxElements <= 0) {
            return 0;
        }
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            BufferedElement<E> first;
            int n;
            for (n = 0; n < maxElements && (first = this.q.peek()) != null && first.getDelay(TimeUnit.NANOSECONDS) <= 0L; ++n) {
                c.add(this.q.poll().getElement());
            }
            int n2 = n;
            return n2;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            this.q.clear();
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public int remainingCapacity() {
        return Integer.MAX_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] toArray() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            Object[] delayedArray = this.q.toArray();
            Object[] array = new Object[delayedArray.length];
            for (int i = 0; i < delayedArray.length; ++i) {
                array[i] = ((BufferedElement)delayedArray[i]).getElement();
            }
            Object[] objectArray = array;
            return objectArray;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T[] toArray(T[] a) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            Object[] elements = this.toArray();
            int size = elements.length;
            if (a.length < size) {
                T[] TArray = Arrays.copyOf(elements, size, a.getClass());
                return TArray;
            }
            System.arraycopy(elements, 0, a, 0, size);
            if (a.length > size) {
                a[size] = null;
            }
            T[] TArray = a;
            return TArray;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object o) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            boolean bl = this.q.remove(o);
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public Iterator<E> iterator() {
        return new Itr(this.q.toArray());
    }

    private static class BufferedElement<T>
    implements Delayed {
        private volatile long stamp;
        private final long delayDuration;
        private final long maxStamp;
        private final T element;
        private final int hash;

        BufferedElement(T element, long delayDuration, long maxDelayDuration) {
            if (delayDuration > maxDelayDuration && 0L != maxDelayDuration) {
                throw new IllegalArgumentException("delayDuration is greater than maxDelayDuration.");
            }
            this.element = element;
            this.delayDuration = delayDuration;
            long now = System.currentTimeMillis();
            this.stamp = now + delayDuration;
            this.maxStamp = 0L == maxDelayDuration ? 0L : now + maxDelayDuration;
            this.hash = 31 + (element == null ? 0 : element.hashCode());
        }

        BufferedElement(T element, BufferedElement<T> source) {
            this.element = element;
            this.delayDuration = source.delayDuration;
            this.stamp = source.stamp;
            this.maxStamp = source.maxStamp;
            this.hash = source.hash;
        }

        @Override
        public int compareTo(Delayed o) {
            long thisStamp = this.stamp;
            long otherStamp = ((BufferedElement)o).stamp;
            return thisStamp < otherStamp ? -1 : (thisStamp == otherStamp ? 0 : 1);
        }

        @Override
        public long getDelay(TimeUnit unit) {
            long toGo = this.stamp - System.currentTimeMillis();
            return unit.convert(toGo, TimeUnit.MILLISECONDS);
        }

        public T getElement() {
            return this.element;
        }

        public void reset() {
            long stamp = System.currentTimeMillis() + this.delayDuration;
            this.stamp = 0L != this.maxStamp && stamp >= this.maxStamp ? this.maxStamp : stamp;
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (null == obj) {
                return false;
            }
            if (!(obj instanceof BufferedElement)) {
                return obj.equals(this.element);
            }
            BufferedElement other = (BufferedElement)obj;
            return !(this.element == null ? other.element != null : !this.element.equals(other.element));
        }

        public String toString() {
            return "BufferedElement [stamp=" + this.stamp + ", element=" + this.element + "]";
        }
    }

    private class Itr
    implements Iterator<E> {
        final Object[] array;
        int cursor;
        int lastRet = -1;

        Itr(Object[] array) {
            this.array = array;
        }

        @Override
        public boolean hasNext() {
            return this.cursor < this.array.length;
        }

        @Override
        public E next() {
            if (this.cursor >= this.array.length) {
                throw new NoSuchElementException();
            }
            this.lastRet = this.cursor;
            return ((BufferedElement)this.array[this.cursor++]).getElement();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove() {
            if (this.lastRet < 0) {
                throw new IllegalStateException();
            }
            Object x = this.array[this.lastRet];
            this.lastRet = -1;
            BufferingQueue.this.lock.lock();
            try {
                Iterator it = BufferingQueue.this.q.iterator();
                while (it.hasNext()) {
                    if (it.next() != x) continue;
                    it.remove();
                    return;
                }
            }
            finally {
                BufferingQueue.this.lock.unlock();
            }
        }
    }
}

