/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware;

import com.openexchange.exception.OXException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public abstract class ComparedPermissions<P, GP extends P> {
    private Collection<P> newPermissions;
    private Collection<P> originalPermissions;
    private List<GP> newGuests;
    private Map<Integer, P> addedGuests;
    private Map<Integer, P> addedUsers;
    private List<P> addedGroups;
    private List<P> removedGuests;
    private Map<Integer, P> modifiedGuests;
    private boolean hasChanges;

    protected ComparedPermissions(P[] newPermissions, P[] originalPermissions) throws OXException {
        this(newPermissions == null ? null : Arrays.asList(newPermissions), originalPermissions == null ? null : Arrays.asList(originalPermissions));
    }

    protected ComparedPermissions(Collection<P> newPermissions, Collection<P> originalPermissions) throws OXException {
        this.newPermissions = newPermissions;
        this.originalPermissions = originalPermissions;
    }

    protected abstract boolean isSystemPermission(P var1);

    protected abstract boolean isUnresolvedGuestPermission(P var1);

    protected abstract boolean isGuestUser(int var1) throws OXException;

    protected abstract boolean isGroupPermission(P var1);

    protected abstract int getEntityId(P var1);

    protected abstract boolean areEqual(P var1, P var2);

    protected void calc() throws OXException {
        if (this.newPermissions == null) {
            this.newGuests = Collections.emptyList();
            this.addedGuests = Collections.emptyMap();
            this.addedUsers = Collections.emptyMap();
            this.addedGroups = Collections.emptyList();
            this.removedGuests = Collections.emptyList();
            this.modifiedGuests = Collections.emptyMap();
            this.hasChanges = false;
            return;
        }
        this.newGuests = new LinkedList<GP>();
        this.addedGuests = new LinkedHashMap<Integer, P>();
        this.addedUsers = new LinkedHashMap<Integer, P>();
        this.addedGroups = new LinkedList<P>();
        this.removedGuests = new LinkedList<P>();
        this.modifiedGuests = new LinkedHashMap<Integer, P>();
        HashMap<Integer, P> newUsers = new HashMap<Integer, P>();
        HashMap<Integer, P> newGroups = new HashMap<Integer, P>();
        for (P permission : this.newPermissions) {
            if (this.isSystemPermission(permission)) continue;
            if (this.isUnresolvedGuestPermission(permission)) {
                this.newGuests.add(permission);
                continue;
            }
            if (this.isGroupPermission(permission)) {
                newGroups.put(this.getEntityId(permission), permission);
                continue;
            }
            newUsers.put(this.getEntityId(permission), permission);
        }
        HashMap<Integer, P> oldUsers = new HashMap<Integer, P>();
        HashMap<Integer, P> oldGroups = new HashMap<Integer, P>();
        if (null != this.originalPermissions) {
            for (P permission : this.originalPermissions) {
                if (this.isSystemPermission(permission)) continue;
                if (this.isGroupPermission(permission)) {
                    oldGroups.put(this.getEntityId(permission), permission);
                    continue;
                }
                oldUsers.put(this.getEntityId(permission), permission);
            }
        }
        boolean permissionsChanged = this.newGuests.size() > 0;
        HashSet addedUserIds = new HashSet(newUsers.keySet());
        addedUserIds.removeAll(oldUsers.keySet());
        permissionsChanged |= addedUserIds.size() > 0;
        HashSet addedGroupIds = new HashSet(newGroups.keySet());
        addedGroupIds.removeAll(oldGroups.keySet());
        permissionsChanged |= addedGroupIds.size() > 0;
        HashSet removedUserIds = new HashSet(oldUsers.keySet());
        removedUserIds.removeAll(newUsers.keySet());
        permissionsChanged |= removedUserIds.size() > 0;
        HashSet removedGroupIds = new HashSet(oldGroups.keySet());
        removedGroupIds.removeAll(newGroups.keySet());
        permissionsChanged |= removedGroupIds.size() > 0;
        for (Object newPermission : newUsers.values()) {
            int entityId;
            Object oldPermission;
            if (this.areEqual(newPermission, oldPermission = oldUsers.get(entityId = this.getEntityId(newPermission)))) continue;
            permissionsChanged = true;
            boolean isGuest = this.isGuestUser(entityId);
            if (oldPermission == null) {
                if (isGuest) {
                    this.addedGuests.put(entityId, newPermission);
                    continue;
                }
                this.addedUsers.put(entityId, newPermission);
                continue;
            }
            if (!isGuest) continue;
            this.modifiedGuests.put(entityId, newPermission);
        }
        for (Object newPermission : newGroups.values()) {
            Object oldPermission;
            if (this.areEqual(newPermission, oldPermission = oldGroups.get(this.getEntityId(newPermission)))) continue;
            permissionsChanged = true;
            this.addedGroups.add(newPermission);
        }
        for (Integer removed : removedUserIds) {
            if (!this.isGuestUser(removed)) continue;
            this.removedGuests.add(oldUsers.get(removed));
        }
        this.hasChanges = permissionsChanged;
    }

    public boolean hasChanges() {
        return this.hasChanges;
    }

    public boolean hasNewGuests() {
        return !this.newGuests.isEmpty();
    }

    public boolean hasAddedGuests() {
        return !this.addedGuests.isEmpty();
    }

    public boolean hasAddedUsers() {
        return !this.addedUsers.isEmpty();
    }

    public boolean hasAddedGroups() {
        return !this.addedGroups.isEmpty();
    }

    public boolean hasRemovedGuests() {
        return !this.removedGuests.isEmpty();
    }

    public boolean hasModifiedGuests() {
        return !this.modifiedGuests.isEmpty();
    }

    public List<GP> getNewGuestPermissions() {
        return this.newGuests;
    }

    public List<P> getAddedGuestPermissions() {
        return new ArrayList<P>(this.addedGuests.values());
    }

    public List<P> getAddedUserPermissions() {
        return new ArrayList<P>(this.addedUsers.values());
    }

    public List<P> getAddedGroupPermissions() {
        return this.addedGroups;
    }

    public List<P> getAddedPermissions() {
        ArrayList<P> permissions = new ArrayList<P>(this.addedGuests.size() + this.addedUsers.size() + this.addedGroups.size());
        permissions.addAll(this.addedGuests.values());
        permissions.addAll(this.addedUsers.values());
        permissions.addAll(this.addedGroups);
        return permissions;
    }

    public List<P> getRemovedGuestPermissions() {
        return this.removedGuests;
    }

    public List<P> getModifiedGuestPermissions() {
        return new ArrayList<P>(this.modifiedGuests.values());
    }

    public List<Integer> getAddedGuests() {
        return new ArrayList<Integer>(this.addedGuests.keySet());
    }

    public List<Integer> getAddedUsers() {
        return new ArrayList<Integer>(this.addedUsers.keySet());
    }

    public List<Integer> getModifiedGuests() {
        return new ArrayList<Integer>(this.modifiedGuests.keySet());
    }

    public P getAddedGuestPermission(Integer guestId) {
        return this.addedGuests.get(guestId);
    }

    public P getModifiedGuestPermission(Integer guestId) {
        return this.modifiedGuests.get(guestId);
    }

    public Collection<P> getOriginalPermissions() {
        return this.originalPermissions;
    }

    public Collection<P> getNewPermissions() {
        return this.newPermissions;
    }
}

