/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.file.storage.osgi;

import com.openexchange.exception.OXException;
import com.openexchange.file.storage.FileStorageExceptionCodes;
import com.openexchange.file.storage.FileStorageService;
import com.openexchange.file.storage.registry.FileStorageServiceRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OSGIFileStorageServiceRegistry
implements FileStorageServiceRegistry {
    final ConcurrentMap<String, FileStorageService> map = new ConcurrentHashMap<String, FileStorageService>(8, 0.9f, 1);
    private ServiceTracker<FileStorageService, FileStorageService> tracker;

    public void start(BundleContext context) {
        if (null == this.tracker) {
            this.tracker = new ServiceTracker(context, FileStorageService.class, (ServiceTrackerCustomizer)new Customizer(context));
            this.tracker.open();
        }
    }

    public void stop() {
        if (null != this.tracker) {
            this.tracker.close();
            this.tracker = null;
        }
    }

    @Override
    public List<FileStorageService> getAllServices() throws OXException {
        return new ArrayList<FileStorageService>(this.map.values());
    }

    @Override
    public FileStorageService getFileStorageService(String id) throws OXException {
        FileStorageService filestorageService = (FileStorageService)this.map.get(id);
        if (null == filestorageService) {
            throw FileStorageExceptionCodes.UNKNOWN_FILE_STORAGE_SERVICE.create(id);
        }
        return filestorageService;
    }

    @Override
    public boolean containsFileStorageService(String id) {
        return null == id ? false : this.map.containsKey(id);
    }

    private final class Customizer
    implements ServiceTrackerCustomizer<FileStorageService, FileStorageService> {
        private final BundleContext context;

        Customizer(BundleContext context) {
            this.context = context;
        }

        public FileStorageService addingService(ServiceReference<FileStorageService> reference) {
            FileStorageService service = (FileStorageService)this.context.getService(reference);
            if (service != null) {
                FileStorageService addMe = service;
                if (null == OSGIFileStorageServiceRegistry.this.map.putIfAbsent(addMe.getId(), addMe)) {
                    return service;
                }
                Logger logger = LoggerFactory.getLogger(Customizer.class);
                logger.warn(new StringBuilder(128).append("File storage service ").append(addMe.getDisplayName()).append(" could not be added to registry. Another service is already registered with identifier: ").append(addMe.getId()).toString());
            }
            this.context.ungetService(reference);
            return null;
        }

        public void modifiedService(ServiceReference<FileStorageService> reference, FileStorageService service) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removedService(ServiceReference<FileStorageService> reference, FileStorageService service) {
            if (null != service) {
                try {
                    FileStorageService removeMe = service;
                    OSGIFileStorageServiceRegistry.this.map.remove(removeMe.getId());
                }
                finally {
                    this.context.ungetService(reference);
                }
            }
        }
    }
}

