/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.file.storage;

public class Range {
    public final int from;
    public final int to;
    private final int hash;

    public static Range valueOf(int[] indexes) {
        return null == indexes || 2 != indexes.length ? null : new Range(indexes[0], indexes[1]);
    }

    public static Range valueOf(int from, int to) {
        return new Range(from, to);
    }

    private Range(int from, int to) {
        if (from < 0 || to < 0 || to < from) {
            throw new IllegalArgumentException("Invalid from/to positions. From=" + from + ", To=" + to);
        }
        this.from = from;
        this.to = to;
        int prime = 31;
        int result = prime * 1 + from;
        this.hash = result = prime * result + to;
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Range)) {
            return false;
        }
        Range other = (Range)obj;
        if (this.from != other.from) {
            return false;
        }
        return this.to == other.to;
    }
}

