/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.file.storage;

import com.openexchange.exception.OXException;
import com.openexchange.file.storage.FileStorageAccountAccess;
import com.openexchange.file.storage.FileStorageFileAccess;
import com.openexchange.file.storage.FileStorageFolder;
import com.openexchange.file.storage.FileStorageFolderAccess;
import com.openexchange.file.storage.FileStorageService;
import com.openexchange.file.storage.FileStorageServiceFactory;
import com.openexchange.session.Session;

public abstract class AbstractFileStorageAccountAccess
implements FileStorageAccountAccess {
    protected boolean connected = false;
    protected final Session session;
    protected final String accountId;
    protected final FileStorageServiceFactory factory;

    protected AbstractFileStorageAccountAccess(FileStorageServiceFactory factory, Session session, String accountId) {
        this.session = session;
        this.accountId = accountId;
        this.factory = factory;
    }

    @Override
    public void connect() throws OXException {
        this.connected = true;
    }

    @Override
    public boolean isConnected() {
        return false;
    }

    @Override
    public void close() {
        this.connected = false;
    }

    @Override
    public boolean ping() throws OXException {
        return true;
    }

    @Override
    public boolean cacheable() {
        return true;
    }

    @Override
    public String getAccountId() {
        return this.accountId;
    }

    public Session getSession() {
        return this.session;
    }

    @Override
    public FileStorageFileAccess getFileAccess() throws OXException {
        return this.factory.getFileAccess(this.session, this.accountId);
    }

    @Override
    public FileStorageFolderAccess getFolderAccess() throws OXException {
        return this.factory.getFolderAccess(this.session, this.accountId);
    }

    @Override
    public FileStorageFolder getRootFolder() throws OXException {
        return this.getFolderAccess().getRootFolder();
    }

    @Override
    public FileStorageService getService() {
        return this.factory.getFileStorageService();
    }
}

