/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.config;

import com.openexchange.config.Filter;
import com.openexchange.java.Strings;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;

public class WildcardFilter
implements Filter {
    private static final Pattern SPLIT = Pattern.compile(" *, *");
    private static final Filter DUMMY = new Filter(){

        @Override
        public boolean accepts(String value) {
            return true;
        }
    };
    private final Filter delegate;

    public WildcardFilter(String csvWildcards) {
        if (Strings.isEmpty((String)csvWildcards)) {
            this.delegate = DUMMY;
        } else {
            String[] wildcards = SPLIT.split(csvWildcards);
            HashSet<Pattern> patterns = new HashSet<Pattern>(wildcards.length);
            for (String s : wildcards) {
                if (s.indexOf(42) < 0 && s.indexOf(63) < 0) {
                    patterns.add(Pattern.compile(WildcardFilter.wildcardToRegex("*@" + s.trim()), 2));
                    continue;
                }
                patterns.add(Pattern.compile(WildcardFilter.wildcardToRegex(s.trim()), 2));
            }
            this.delegate = new PatternBasedFilter(patterns);
        }
    }

    @Override
    public boolean accepts(String value) {
        return this.delegate.accepts(value);
    }

    private static String wildcardToRegex(String wildcard) {
        StringBuilder s = new StringBuilder(wildcard.length());
        s.append('^');
        int len = wildcard.length();
        for (int i = 0; i < len; ++i) {
            char c = wildcard.charAt(i);
            if (c == '*') {
                s.append(".*");
                continue;
            }
            if (c == '?') {
                s.append('.');
                continue;
            }
            if (c == '(' || c == ')' || c == '[' || c == ']' || c == '$' || c == '^' || c == '.' || c == '{' || c == '}' || c == '|' || c == '\\') {
                s.append('\\');
                s.append(c);
                continue;
            }
            s.append(c);
        }
        s.append('$');
        return s.toString();
    }

    private static final class PatternBasedFilter
    implements Filter {
        private final Set<Pattern> patterns;

        PatternBasedFilter(Set<Pattern> patterns) {
            this.patterns = patterns;
        }

        @Override
        public boolean accepts(String value) {
            for (Pattern pattern : this.patterns) {
                if (!pattern.matcher(value).matches()) continue;
                return true;
            }
            return false;
        }
    }
}

