/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav.action;

import com.openexchange.webdav.action.ActionTestCase;
import com.openexchange.webdav.action.MockAction;
import com.openexchange.webdav.action.MockWebdavRequest;
import com.openexchange.webdav.action.MockWebdavResponse;
import com.openexchange.webdav.action.WebdavAction;
import com.openexchange.webdav.action.WebdavIfMatchAction;
import com.openexchange.webdav.action.WebdavRequest;
import com.openexchange.webdav.action.WebdavResponse;
import com.openexchange.webdav.protocol.WebdavPath;
import com.openexchange.webdav.protocol.WebdavProtocolException;

public class IfMatchTest
extends ActionTestCase {
    private MockAction mockAction;
    private WebdavPath INDEX_HTML_URL;

    public void testIfMatchWorks() throws Exception {
        String etag = this.factory.resolveResource(this.INDEX_HTML_URL).getETag();
        MockWebdavRequest req = new MockWebdavRequest(this.factory, "http://localhost/");
        MockWebdavResponse res = new MockWebdavResponse();
        req.setUrl(this.INDEX_HTML_URL);
        req.setHeader("If-Match", etag);
        WebdavIfMatchAction action = new WebdavIfMatchAction();
        action.setNext((WebdavAction)this.mockAction);
        action.perform((WebdavRequest)req, (WebdavResponse)res);
        IfMatchTest.assertTrue((boolean)this.mockAction.wasActivated());
    }

    public void testIfMatchFails() throws Exception {
        MockWebdavRequest req = new MockWebdavRequest(this.factory, "http://localhost");
        MockWebdavResponse res = new MockWebdavResponse();
        req.setUrl(this.INDEX_HTML_URL);
        req.setHeader("If-Match", "i_don_t_match");
        WebdavIfMatchAction action = new WebdavIfMatchAction();
        this.mockAction.setActivated(false);
        try {
            action.setNext((WebdavAction)this.mockAction);
            action.perform((WebdavRequest)req, (WebdavResponse)res);
            IfMatchTest.fail((String)"Expected precondition exception");
        }
        catch (WebdavProtocolException x) {
            IfMatchTest.assertEquals((int)412, (int)x.getStatus());
            IfMatchTest.assertFalse((boolean)this.mockAction.wasActivated());
        }
    }

    public void testIfMatchMany() throws Exception {
        String etag = this.factory.resolveResource(this.INDEX_HTML_URL).getETag();
        MockWebdavRequest req = new MockWebdavRequest(this.factory, "http://localhost/");
        MockWebdavResponse res = new MockWebdavResponse();
        req.setUrl(this.INDEX_HTML_URL);
        req.setHeader("If-Match", "bla-1, bla-2, " + etag + ", bla, bla2, bla3");
        WebdavIfMatchAction action = new WebdavIfMatchAction();
        action.setNext((WebdavAction)this.mockAction);
        action.perform((WebdavRequest)req, (WebdavResponse)res);
        IfMatchTest.assertTrue((boolean)this.mockAction.wasActivated());
    }

    public void testWildcardsIfMatchWorks() throws Exception {
        MockWebdavRequest req = new MockWebdavRequest(this.factory, "http://localhost/");
        MockWebdavResponse res = new MockWebdavResponse();
        req.setUrl(this.INDEX_HTML_URL);
        req.setHeader("If-Match", "*");
        WebdavIfMatchAction action = new WebdavIfMatchAction();
        action.setNext((WebdavAction)this.mockAction);
        action.perform((WebdavRequest)req, (WebdavResponse)res);
        IfMatchTest.assertTrue((boolean)this.mockAction.wasActivated());
    }

    public void testWildcardsIfMatchFails() throws Exception {
        MockWebdavRequest req = new MockWebdavRequest(this.factory, "http://localhost");
        MockWebdavResponse res = new MockWebdavResponse();
        req.setUrl(new WebdavPath((CharSequence)"doesntExist"));
        req.setHeader("If-Match", "*");
        WebdavIfMatchAction action = new WebdavIfMatchAction();
        this.mockAction.setActivated(false);
        try {
            action.setNext((WebdavAction)this.mockAction);
            action.perform((WebdavRequest)req, (WebdavResponse)res);
            IfMatchTest.fail((String)"Expected precondition exception");
        }
        catch (WebdavProtocolException x) {
            IfMatchTest.assertEquals((int)412, (int)x.getStatus());
            IfMatchTest.assertFalse((boolean)this.mockAction.wasActivated());
        }
    }

    public void testIfNoneMatchWorks() throws Exception {
        MockWebdavRequest req = new MockWebdavRequest(this.factory, "http://localhost/");
        MockWebdavResponse res = new MockWebdavResponse();
        req.setUrl(this.INDEX_HTML_URL);
        req.setHeader("If-None-Match", "i_don_t_match");
        WebdavIfMatchAction action = new WebdavIfMatchAction();
        action.setNext((WebdavAction)this.mockAction);
        action.perform((WebdavRequest)req, (WebdavResponse)res);
        IfMatchTest.assertTrue((boolean)this.mockAction.wasActivated());
    }

    public void testIfNoneMatchFails() throws Exception {
        String etag = this.factory.resolveResource(this.INDEX_HTML_URL).getETag();
        MockWebdavRequest req = new MockWebdavRequest(this.factory, "http://localhost");
        MockWebdavResponse res = new MockWebdavResponse();
        req.setUrl(this.INDEX_HTML_URL);
        req.setHeader("If-None-Match", etag);
        WebdavIfMatchAction action = new WebdavIfMatchAction();
        this.mockAction.setActivated(false);
        try {
            action.setNext((WebdavAction)this.mockAction);
            action.perform((WebdavRequest)req, (WebdavResponse)res);
            IfMatchTest.fail((String)"Expected precondition exception");
        }
        catch (WebdavProtocolException x) {
            IfMatchTest.assertEquals((int)412, (int)x.getStatus());
            IfMatchTest.assertFalse((boolean)this.mockAction.wasActivated());
        }
    }

    public void testIfNoneMatchMany() throws Exception {
        String etag = this.factory.resolveResource(this.INDEX_HTML_URL).getETag();
        MockWebdavRequest req = new MockWebdavRequest(this.factory, "http://localhost");
        MockWebdavResponse res = new MockWebdavResponse();
        req.setUrl(this.INDEX_HTML_URL);
        req.setHeader("If-None-Match", "bla-1, bla-2, " + etag + ", bla, bla2, bla3");
        WebdavIfMatchAction action = new WebdavIfMatchAction();
        this.mockAction.setActivated(false);
        try {
            action.setNext((WebdavAction)this.mockAction);
            action.perform((WebdavRequest)req, (WebdavResponse)res);
            IfMatchTest.fail((String)"Expected precondition exception");
        }
        catch (WebdavProtocolException x) {
            IfMatchTest.assertEquals((int)412, (int)x.getStatus());
            IfMatchTest.assertFalse((boolean)this.mockAction.wasActivated());
        }
    }

    public void testWildcardsIfNonMatchWorks() throws Exception {
        MockWebdavRequest req = new MockWebdavRequest(this.factory, "http://localhost");
        MockWebdavResponse res = new MockWebdavResponse();
        req.setUrl(new WebdavPath((CharSequence)"doesntExist"));
        req.setHeader("If-None-Match", "*");
        WebdavIfMatchAction action = new WebdavIfMatchAction();
        this.mockAction.setActivated(false);
        action.setNext((WebdavAction)this.mockAction);
        action.perform((WebdavRequest)req, (WebdavResponse)res);
        IfMatchTest.assertTrue((boolean)this.mockAction.wasActivated());
    }

    public void testWildcardsIfNonMatchFails() throws Exception {
        MockWebdavRequest req = new MockWebdavRequest(this.factory, "http://localhost");
        MockWebdavResponse res = new MockWebdavResponse();
        req.setUrl(this.INDEX_HTML_URL);
        req.setHeader("If-None-Match", "*");
        WebdavIfMatchAction action = new WebdavIfMatchAction();
        this.mockAction.setActivated(false);
        try {
            action.setNext((WebdavAction)this.mockAction);
            action.perform((WebdavRequest)req, (WebdavResponse)res);
            IfMatchTest.fail((String)"Expected precondition exception");
        }
        catch (WebdavProtocolException x) {
            IfMatchTest.assertEquals((int)412, (int)x.getStatus());
            IfMatchTest.assertFalse((boolean)this.mockAction.wasActivated());
        }
    }

    public void testNoneSet() throws Exception {
        MockWebdavRequest req = new MockWebdavRequest(this.factory, "http://localhost/");
        MockWebdavResponse res = new MockWebdavResponse();
        req.setUrl(this.INDEX_HTML_URL);
        WebdavIfMatchAction action = new WebdavIfMatchAction();
        action.setNext((WebdavAction)this.mockAction);
        action.perform((WebdavRequest)req, (WebdavResponse)res);
        IfMatchTest.assertTrue((boolean)this.mockAction.wasActivated());
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.mockAction = new MockAction();
        this.INDEX_HTML_URL = this.testCollection.dup().append(new String[]{"index.html"});
    }
}

