/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.file;

import com.openexchange.database.Assignment;
import com.openexchange.database.DatabaseService;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.impl.ContextImpl;
import com.openexchange.java.Charsets;
import com.openexchange.tools.RandomString;
import com.openexchange.tools.file.external.FileStorage;
import com.openexchange.tools.file.internal.DBQuotaFileStorage;
import com.openexchange.tools.file.internal.LocalFileStorage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.net.URI;
import java.sql.Connection;
import junit.framework.TestCase;

public class QuotaFileStorageTest
extends TestCase {
    private FileStorage fs;

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testBasic() throws Exception {
        File tempFile = File.createTempFile("filestorage", ".tmp");
        tempFile.deleteOnExit();
        tempFile.delete();
        this.fs = new LocalFileStorage(new URI("file:" + tempFile.getAbsolutePath()));
        TestQuotaFileStorage quotaStorage = new TestQuotaFileStorage((Context)new ContextImpl(1), this.fs, new DummyDatabaseService());
        quotaStorage.setQuota(10000L);
        String fileContent = RandomString.generateLetter(100);
        ByteArrayInputStream bais = new ByteArrayInputStream(fileContent.getBytes(Charsets.UTF_8));
        String id = quotaStorage.saveNewFile(bais);
        QuotaFileStorageTest.assertEquals((long)fileContent.getBytes(Charsets.UTF_8).length, (long)quotaStorage.getUsage());
        QuotaFileStorageTest.assertEquals((long)fileContent.getBytes(Charsets.UTF_8).length, (long)quotaStorage.getFileSize(id));
        quotaStorage.deleteFile(id);
        QuotaFileStorageTest.assertEquals((long)0L, (long)quotaStorage.getUsage());
        QuotaFileStorageTest.rmdir(tempFile);
    }

    public void testFull() throws Exception {
        File tempFile = File.createTempFile("filestorage", ".tmp");
        tempFile.deleteOnExit();
        tempFile.delete();
        this.fs = new LocalFileStorage(new URI("file://" + tempFile.getAbsolutePath()));
        TestQuotaFileStorage quotaStorage = new TestQuotaFileStorage((Context)new ContextImpl(1), this.fs, new DummyDatabaseService());
        quotaStorage.setQuota(10000L);
        String fileContent = RandomString.generateLetter(100);
        quotaStorage.setQuota(fileContent.getBytes(Charsets.UTF_8).length - 2);
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(fileContent.getBytes(Charsets.UTF_8));
            quotaStorage.saveNewFile(bais);
            QuotaFileStorageTest.fail((String)"Managed to exceed quota");
        }
        catch (OXException x) {
            QuotaFileStorageTest.assertTrue((boolean)true);
        }
        QuotaFileStorageTest.rmdir(tempFile);
    }

    private static void rmdir(File tempFile) {
        if (tempFile.isDirectory()) {
            for (File f : tempFile.listFiles()) {
                QuotaFileStorageTest.rmdir(f);
            }
        }
        tempFile.delete();
    }

    static final class DummyDatabaseService
    implements DatabaseService {
        DummyDatabaseService() {
        }

        public void back(int poolId, Connection con) {
        }

        public void backForUpdateTask(int contextId, Connection con) {
        }

        public void backReadOnly(Context ctx, Connection con) {
        }

        public void backReadOnly(int contextId, Connection con) {
        }

        public void backWritable(Context ctx, Connection con) {
        }

        public void backWritable(int contextId, Connection con) {
        }

        public void backWritableAfterReading(Context ctx, Connection con) {
        }

        public void backWritableAfterReading(int contextId, Connection con) {
        }

        public Connection get(int poolId, String schema) {
            return null;
        }

        public int[] getContextsInSameSchema(int contextId) {
            return null;
        }

        public int[] getContextsInSameSchema(Connection con, int contextId) {
            return null;
        }

        public int[] getContextsInSchema(Connection con, int poolId, String schema) {
            return null;
        }

        public String[] getUnfilledSchemas(Connection con, int poolId, int maxContexts) {
            return null;
        }

        public void lock(Connection con) {
        }

        public Connection getForUpdateTask(int contextId) {
            return null;
        }

        public Connection getReadOnly(Context ctx) {
            return null;
        }

        public Connection getReadOnly(int contextId) {
            return null;
        }

        public String getSchemaName(int contextId) {
            return null;
        }

        public Connection getWritable(Context ctx) {
            return null;
        }

        public Connection getWritable(int contextId) {
            return null;
        }

        public int getWritablePool(int contextId) {
            return 0;
        }

        public void invalidate(int contextId) {
        }

        public void backReadOnly(Connection con) {
        }

        public void backWritable(Connection con) {
        }

        public Connection getReadOnly() {
            return null;
        }

        public Connection getWritable() {
            return null;
        }

        public int[] listContexts(int poolId) {
            return null;
        }

        public Connection getNoTimeout(int poolId, String schema) {
            return null;
        }

        public void backNoTimeoout(int poolId, Connection con) {
        }

        public int getServerId() {
            return 0;
        }

        public String getServerName() {
            return null;
        }

        public void writeAssignment(Connection con, Assignment assignment) throws OXException {
        }

        public void deleteAssignment(Connection con, int contextId) {
        }

        public void backForUpdateTaskAfterReading(int contextId, Connection con) {
        }

        public Connection getReadOnlyMonitored(int readPoolId, int writePoolId, String schema, int partitionId) throws OXException {
            return null;
        }

        public Connection getWritableMonitored(int readPoolId, int writePoolId, String schema, int partitionId) throws OXException {
            return null;
        }

        public Connection getWritableMonitoredForUpdateTask(int readPoolId, int writePoolId, String schema, int partitionId) throws OXException {
            return null;
        }

        public void backReadOnlyMonitored(int readPoolId, int writePoolId, String schema, int partitionId, Connection con) {
        }

        public void backWritableMonitored(int readPoolId, int writePoolId, String schema, int partitionId, Connection con) {
        }

        public void backWritableMonitoredForUpdateTask(int readPoolId, int writePoolId, String schema, int partitionId, Connection con) {
        }

        public void initMonitoringTables(int writePoolId, String schema) throws OXException {
        }

        public void initPartitions(int writePoolId, String schema, int ... partitions) throws OXException {
        }

        public Connection getForUpdateTask() throws OXException {
            return null;
        }

        public void backForUpdateTask(Connection con) {
        }
    }

    public static final class TestQuotaFileStorage
    extends DBQuotaFileStorage {
        private long usage;
        private long quota;

        public TestQuotaFileStorage(Context ctx, FileStorage fs, DatabaseService dbs) throws OXException {
            super(ctx, fs, dbs);
        }

        public void setQuota(long quota) {
            this.quota = quota;
        }

        public long getQuota() {
            return this.quota;
        }

        public long getUsage() {
            return this.usage;
        }

        protected void setUsage(long usage) {
            this.usage = usage;
        }

        protected boolean incUsage(long added) {
            boolean full = false;
            if (this.usage + added <= this.quota) {
                this.usage += added;
            } else {
                full = true;
            }
            return full;
        }

        protected void decUsage(long removed) {
            this.usage -= removed;
        }
    }
}

