/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.infostore;

import com.openexchange.groupware.infostore.AbstractInfostoreActionTest;
import com.openexchange.groupware.infostore.DocumentMetadata;
import com.openexchange.groupware.infostore.database.impl.CreateDocumentAction;
import com.openexchange.groupware.infostore.database.impl.CreateVersionAction;
import com.openexchange.groupware.infostore.database.impl.DeleteVersionAction;
import com.openexchange.groupware.infostore.database.impl.DocumentMetadataImpl;
import com.openexchange.tx.UndoableAction;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class DeleteVersionActionTest
extends AbstractInfostoreActionTest {
    private final CreateDocumentAction create = new CreateDocumentAction();
    private final CreateVersionAction create2 = new CreateVersionAction();

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.create.setProvider(this.getProvider());
        this.create.setContext(this.getContext());
        this.create.setDocuments(this.getDocuments());
        this.create.setQueryCatalog(this.getQueryCatalog());
        this.create.perform();
        this.create2.setProvider(this.getProvider());
        this.create2.setContext(this.getContext());
        this.create2.setDocuments(this.getDocuments());
        this.create2.setQueryCatalog(this.getQueryCatalog());
        this.create2.perform();
    }

    @Override
    public void tearDown() throws Exception {
        this.create2.undo();
        this.create.undo();
        super.tearDown();
    }

    @Override
    protected UndoableAction getAction() throws Exception {
        DeleteVersionAction deleteAction = new DeleteVersionAction();
        deleteAction.setProvider(this.getProvider());
        deleteAction.setContext(this.getContext());
        deleteAction.setDocuments(this.getDocuments());
        deleteAction.setQueryCatalog(this.getQueryCatalog());
        return deleteAction;
    }

    @Override
    protected void verifyPerformed() throws Exception {
        for (DocumentMetadata doc : this.getDocuments()) {
            this.assertNoResult("SELECT 1 FROM infostore_document WHERE cid = ? and infostore_id = ? and version_number = ?", this.getContext().getContextId(), doc.getId(), doc.getVersion());
        }
    }

    @Override
    protected void verifyUndone() throws Exception {
        for (DocumentMetadata doc : this.getDocuments()) {
            this.assertResult("SELECT 1 FROM infostore_document WHERE cid = ? and infostore_id = ? and version_number = ?", this.getContext().getContextId(), doc.getId(), doc.getVersion());
        }
    }

    public void testPossibleToTryMoreThanOnce() throws Exception {
        UndoableAction action = this.getAction();
        action.perform();
        action.perform();
    }

    public void testBatching() throws Exception {
        DeleteVersionAction action = (DeleteVersionAction)this.getAction();
        action.setBatchSize(3);
        action.perform();
        this.verifyPerformed();
        ArrayList<DocumentMetadata> documents = new ArrayList<DocumentMetadata>();
        for (int i = 0; i < 1001; ++i) {
            DocumentMetadataImpl document = new DocumentMetadataImpl();
            document.setTitle("doc " + i);
            documents.add((DocumentMetadata)document);
        }
        this.trySlicing(action, documents, 1000);
        this.trySlicing(action, documents, 1001);
        this.trySlicing(action, documents, 1002);
        this.trySlicing(action, documents, 10);
        this.trySlicing(action, documents, 11);
    }

    private void trySlicing(DeleteVersionAction action, List<DocumentMetadata> documents, int batchSize) {
        List[] slices;
        HashSet<String> titles = new HashSet<String>();
        for (DocumentMetadata document : documents) {
            titles.add(document.getTitle());
        }
        for (List slice : slices = action.getSlices(batchSize, documents)) {
            DeleteVersionActionTest.assertTrue((slice.size() <= batchSize ? 1 : 0) != 0);
            for (DocumentMetadata documentMetadata : slice) {
                DeleteVersionActionTest.assertTrue((boolean)titles.remove(documentMetadata.getTitle()));
            }
        }
        DeleteVersionActionTest.assertTrue((boolean)titles.isEmpty());
    }
}

