/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.calendar.calendarsqltests;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.calendar.CalendarDataObject;
import com.openexchange.groupware.calendar.calendarsqltests.CalendarSqlTest;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class Bug12072Test
extends CalendarSqlTest {
    public void testShouldNotIndicateConflictingResources() throws OXException {
        long today = this.getTools().normalizeLong(System.currentTimeMillis());
        Calendar cal = GregorianCalendar.getInstance(TimeZone.getTimeZone("UTC"));
        cal.setTimeInMillis(today);
        int weekDayOfToday = cal.get(7);
        Date start = new Date(today + 36000000L);
        Date end = new Date(today + 39600000L);
        CalendarDataObject appointment = this.appointments.buildAppointmentWithResourceParticipants(this.resource1);
        appointment.setParentFolderID(this.appointments.getPrivateFolder());
        appointment.setIgnoreConflicts(true);
        appointment.setStartDate(start);
        appointment.setEndDate(end);
        appointment.setContext(this.ctx);
        appointment.setTimezone("utc");
        appointment.setRecurrenceType(2);
        appointment.setDays(Bug12072Test.convertCalendarDAY_OF_WEEK2CalendarDataObjectDAY_OF_WEEK(weekDayOfToday));
        appointment.setTitle("Everything can happen on a X-day");
        appointment.setInterval(1);
        appointment.setOccurrence(5);
        this.appointments.save(appointment);
        this.clean.add(appointment);
        start = new Date(start.getTime() + 86400000L);
        end = new Date(end.getTime() + 86400000L);
        CalendarDataObject update = this.appointments.buildAppointmentWithResourceParticipants(this.resource1);
        update.setParentFolderID(this.appointments.getPrivateFolder());
        update.setIgnoreConflicts(true);
        update.setStartDate(start);
        update.setEndDate(end);
        update.setContext(this.ctx);
        update.setTimezone("utc");
        update.setRecurrenceType(2);
        update.setDays(Bug12072Test.convertCalendarDAY_OF_WEEK2CalendarDataObjectDAY_OF_WEEK(weekDayOfToday + 1));
        update.setTitle("Everything can happen on a X1-day");
        update.setInterval(1);
        update.setOccurrence(5);
        CalendarDataObject[] conflicts = this.appointments.save(update);
        this.clean.add(update);
        Bug12072Test.assertTrue((String)"", (conflicts == null || conflicts.length == 0 ? 1 : 0) != 0);
    }
}

