/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.dav.carddav.tests;

import com.openexchange.dav.SyncToken;
import com.openexchange.dav.ThrowableHolder;
import com.openexchange.dav.carddav.CardDAVTest;
import com.openexchange.dav.carddav.VCardResource;
import com.openexchange.dav.reports.SyncCollectionResponse;
import com.openexchange.groupware.container.Contact;
import java.util.Date;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;

public class UpgradeTest
extends CardDAVTest {
    public UpgradeTest(String name) {
        super(name);
    }

    public void testUpgradeWithGAB_10_6() throws Throwable {
        super.getWebDAVClient().setUserAgent("Address%20Book/883 CFNetwork/454.12.4 Darwin/10.8.0 (i386)");
        String contactsGroupUid = "f" + super.getClient().getValues().getContextId() + "_" + super.getDefaultFolderID();
        String gabGroupUid = "f" + super.getClient().getValues().getContextId() + "_" + super.getGABFolderID();
        String cTag = super.getCTag();
        final String contactUidPath = UpgradeTest.randomUID() + "-ABSPlugin";
        String contactUid = UpgradeTest.randomUID() + "-ABSPlugin";
        String firstName = "upgrade";
        String lastName = "test";
        String email = "upgrader@example.com";
        final String contactVCard = "BEGIN:VCARD\r\nVERSION:3.0\r\nN:" + lastName + ";" + firstName + ";;;" + "\r\n" + "FN:" + firstName + " " + lastName + "\r\n" + "ORG:test88;" + "\r\n" + "EMAIL;type=INTERNET;type=WORK;type=pref:" + email + "\r\n" + "TEL;type=WORK;type=pref:24235423" + "\r\n" + "TEL;type=CELL:352-3534" + "\r\n" + "TEL;type=HOME:547547" + "\r\n" + "UID:" + contactUid + "\r\n" + "REV:" + CardDAVTest.formatAsUTC(new Date()) + "\r\n" + "PRODID:-//Apple Inc.//AddressBook 6.0//EN" + "\r\n" + "END:VCARD" + "\r\n";
        String groupVCard = "BEGIN:VCARD\r\nVERSION:3.0\r\nPRODID:-//Apple Inc.//AddressBook 6.0//EN\r\nN: Contacts\r\nFN: Contacts\r\nX-ADDRESSBOOKSERVER-MEMBER:urn:uuid:B1A4E8BE-F6AA-4193-932B-14BF7500D76A-ABSPlugin\r\nX-ADDRESSBOOKSERVER-MEMBER:urn:uuid:4d90f3ef-b438-4878-b977-16550809312d\r\nX-ADDRESSBOOKSERVER-MEMBER:urn:uuid:333e8382-2641-4ee4-9c2a-cd8a7fd8bb2d\r\nX-ADDRESSBOOKSERVER-MEMBER:urn:uuid:fe0c922a-aaa0-43d2-9412-edaba49ba683\r\nX-ADDRESSBOOKSERVER-MEMBER:urn:uuid:f0597cf8-e59a-4e7c-a925-9244b141d6e3\r\nX-ADDRESSBOOKSERVER-MEMBER:urn:uuid:e4e1c694-da0f-4dc2-b220-5d8b7801beae\r\nX-ADDRESSBOOKSERVER-MEMBER:urn:uuid:78D1A52B-8069-4008-A780-815EDA87424C-ABSPlugin\r\nX-ADDRESSBOOKSERVER-MEMBER:urn:uuid:0b3163b5-9de3-4664-a549-557ec7b0fcc7\r\nX-ADDRESSBOOKSERVER-MEMBER:urn:uuid:450abb55-bc9c-4106-8a2d-1f6dc6afbae9\r\nX-ADDRESSBOOKSERVER-MEMBER:urn:uuid:93da65d4-ec6c-4211-9bca-8648deebe3e4\r\nX-ADDRESSBOOKSERVER-MEMBER:urn:uuid:" + contactUid + "\r\n" + "X-ADDRESSBOOKSERVER-MEMBER:urn:uuid:4c9ed4a2-bb4b-4947-919b-5078ebddccb4" + "\r\n" + "X-ADDRESSBOOKSERVER-MEMBER:urn:uuid:0067e70e-cbc0-4040-a1cb-8928e7cdf9f9" + "\r\n" + "X-ADDRESSBOOKSERVER-MEMBER:urn:uuid:e5c4f3d5-d668-4797-a0c3-0441fbb50cf9" + "\r\n" + "X-ADDRESSBOOKSERVER-MEMBER:urn:uuid:d817a3e0-6c6f-4888-85c2-6442bfc05412" + "\r\n" + "X-ADDRESSBOOKSERVER-KIND:group" + "\r\n" + "REV:" + CardDAVTest.formatAsUTC(new Date()) + "\r\n" + "UID:" + contactsGroupUid + "\r\n" + "X-ABUID:05358928-0808-4FAD-A86F-1D9B517C9F78\\:ABGroup" + "\r\n" + "END:VCARD" + "\r\n";
        final ThrowableHolder throwableHolder = new ThrowableHolder();
        Thread createThread = new Thread(){

            @Override
            public void run() {
                try {
                    TestCase.assertEquals((String)"response code wrong", (int)201, (int)UpgradeTest.this.putVCard(contactUidPath, contactVCard));
                }
                catch (Throwable t) {
                    throwableHolder.setThrowable(t);
                }
            }
        };
        createThread.start();
        super.putVCardUpdate(contactsGroupUid, groupVCard);
        createThread.join();
        throwableHolder.reThrowIfSet();
        Contact contact = super.getContact(contactUid);
        super.rememberForCleanUp(contact);
        UpgradeTest.assertEquals((String)"uid wrong", (String)contactUid, (String)contact.getUid());
        UpgradeTest.assertEquals((String)"firstname wrong", (String)firstName, (String)contact.getGivenName());
        UpgradeTest.assertEquals((String)"lastname wrong", (String)lastName, (String)contact.getSurName());
        String cTag2 = super.getCTag();
        UpgradeTest.assertFalse((String)"No changes indicated by CTag", (boolean)cTag.equals(cTag2));
        Map<String, String> eTags = super.getAllETags();
        List<VCardResource> vCards = super.addressbookMultiget(eTags.keySet());
        UpgradeTest.assertNotContains(contactsGroupUid, vCards);
        UpgradeTest.assertNotContains(gabGroupUid, vCards);
        UpgradeTest.assertContains(contactUid, vCards);
    }

    public void testUpgradeWithGAB_10_7() throws Throwable {
        super.getWebDAVClient().setUserAgent("AddressBook/6.1 (1062) CardDAVPlugin/196 CFNetwork/520.2.5 Mac_OS_X/10.7.2 (11C74)");
        SyncToken syncToken = new SyncToken(super.fetchSyncToken());
        String contactsGroupUid = "f" + super.getClient().getValues().getContextId() + "_" + super.getDefaultFolderID();
        String contactsGroupHRef = "http://www.open-xchange.com/carddav/" + contactsGroupUid + ".vcf";
        String contactsGroupETag = "http://www.open-xchange.com/carddav/" + contactsGroupUid + "_" + new Date().getTime();
        String gabGroupUid = "f" + super.getClient().getValues().getContextId() + "_" + super.getGABFolderID();
        String gabGroupHRef = "http://www.open-xchange.com/carddav/" + gabGroupUid + ".vcf";
        final String contactUid = UpgradeTest.randomUID();
        String firstName = "upgrade";
        String lastName = "test2";
        String email = "upgrader2@example.com";
        final String contactVCard = "BEGIN:VCARD\r\nVERSION:3.0\r\nN:" + lastName + ";" + firstName + ";;;" + "\r\n" + "FN:" + firstName + " " + lastName + "\r\n" + "ORG:test88;" + "\r\n" + "EMAIL;type=INTERNET;type=WORK;type=pref:" + email + "\r\n" + "TEL;type=WORK;type=pref:24235423" + "\r\n" + "TEL;type=CELL:352-3534" + "\r\n" + "TEL;type=HOME:547547" + "\r\n" + "UID:" + contactUid + "\r\n" + "REV:" + CardDAVTest.formatAsUTC(new Date()) + "\r\n" + "PRODID:-//Apple Inc.//AddressBook 6.0//EN" + "\r\n" + "END:VCARD" + "\r\n";
        String groupVCard = "BEGIN:VCARD\r\nVERSION:3.0\r\nPRODID:-//Apple Inc.//AddressBook 6.0//EN\r\nN: Contacts\r\nFN: Contacts\r\nX-ADDRESSBOOKSERVER-MEMBER:urn:uuid:4d90f3ef-b438-4878-b977-16550809312d\r\nX-ADDRESSBOOKSERVER-MEMBER:urn:uuid:333e8382-2641-4ee4-9c2a-cd8a7fd8bb2d\r\nX-ADDRESSBOOKSERVER-MEMBER:urn:uuid:fe0c922a-aaa0-43d2-9412-edaba49ba683\r\nX-ADDRESSBOOKSERVER-MEMBER:urn:uuid:f0597cf8-e59a-4e7c-a925-9244b141d6e3\r\nX-ADDRESSBOOKSERVER-MEMBER:urn:uuid:e4e1c694-da0f-4dc2-b220-5d8b7801beae\r\nX-ADDRESSBOOKSERVER-MEMBER:urn:uuid:0b3163b5-9de3-4664-a549-557ec7b0fcc7\r\nX-ADDRESSBOOKSERVER-MEMBER:urn:uuid:450abb55-bc9c-4106-8a2d-1f6dc6afbae9\r\nX-ADDRESSBOOKSERVER-MEMBER:urn:uuid:93da65d4-ec6c-4211-9bca-8648deebe3e4\r\nX-ADDRESSBOOKSERVER-MEMBER:urn:uuid:" + contactUid + "\r\n" + "X-ADDRESSBOOKSERVER-MEMBER:urn:uuid:4c9ed4a2-bb4b-4947-919b-5078ebddccb4" + "\r\n" + "X-ADDRESSBOOKSERVER-MEMBER:urn:uuid:0067e70e-cbc0-4040-a1cb-8928e7cdf9f9" + "\r\n" + "X-ADDRESSBOOKSERVER-MEMBER:urn:uuid:e5c4f3d5-d668-4797-a0c3-0441fbb50cf9" + "\r\n" + "X-ADDRESSBOOKSERVER-MEMBER:urn:uuid:d817a3e0-6c6f-4888-85c2-6442bfc05412" + "\r\n" + "X-ADDRESSBOOKSERVER-KIND:group" + "\r\n" + "REV:" + CardDAVTest.formatAsUTC(new Date()) + "\r\n" + "UID:" + contactsGroupUid + "\r\n" + "X-ABUID:05358928-0808-4FAD-A86F-1D9B517C9F78\\:ABGroup" + "\r\n" + "END:VCARD" + "\r\n";
        final ThrowableHolder throwableHolder = new ThrowableHolder();
        Thread createThread = new Thread(){

            @Override
            public void run() {
                try {
                    TestCase.assertEquals((String)"response code wrong", (int)201, (int)UpgradeTest.this.putVCard(contactUid, contactVCard));
                }
                catch (Throwable t) {
                    throwableHolder.setThrowable(t);
                }
            }
        };
        createThread.start();
        super.putVCardUpdate(contactsGroupUid, groupVCard, contactsGroupETag);
        createThread.join();
        throwableHolder.reThrowIfSet();
        Contact contact = super.getContact(contactUid);
        super.rememberForCleanUp(contact);
        UpgradeTest.assertEquals((String)"uid wrong", (String)contactUid, (String)contact.getUid());
        UpgradeTest.assertEquals((String)"firstname wrong", (String)firstName, (String)contact.getGivenName());
        UpgradeTest.assertEquals((String)"lastname wrong", (String)lastName, (String)contact.getSurName());
        SyncCollectionResponse syncCollection = super.syncCollection(syncToken);
        Map<String, String> eTagsOK = syncCollection.getETagsStatusOK();
        UpgradeTest.assertTrue((String)"no resource changes reported on sync collection", (0 < eTagsOK.size() ? 1 : 0) != 0);
        List<VCardResource> addressData = super.addressbookMultiget(eTagsOK.keySet());
        VCardResource card = UpgradeTest.assertContains(contactUid, addressData);
        UpgradeTest.assertEquals((String)"N wrong", (String)firstName, (String)card.getGivenName());
        UpgradeTest.assertEquals((String)"N wrong", (String)lastName, (String)card.getFamilyName());
        UpgradeTest.assertEquals((String)"FN wrong", (String)(firstName + " " + lastName), (String)card.getFN());
        List<String> hrefsNotFound = syncCollection.getHrefsStatusNotFound();
        UpgradeTest.assertTrue((String)"no resource deletions reported on sync collection", (0 < hrefsNotFound.size() ? 1 : 0) != 0);
        UpgradeTest.assertFalse((String)"contacts group not reported as deleted", (boolean)hrefsNotFound.contains(gabGroupHRef));
        UpgradeTest.assertFalse((String)"contacts group not reported as deleted", (boolean)hrefsNotFound.contains(contactsGroupHRef));
    }
}

