/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.dav.caldav.bugs;

import com.openexchange.dav.PropertyNames;
import com.openexchange.dav.caldav.CalDAVTest;
import com.openexchange.java.Strings;
import org.apache.jackrabbit.webdav.MultiStatusResponse;
import org.apache.jackrabbit.webdav.client.methods.PropFindMethod;
import org.apache.jackrabbit.webdav.property.DavPropertyNameSet;
import org.w3c.dom.Node;

public class Bug32897Test
extends CalDAVTest {
    public Bug32897Test(String name) {
        super(name);
    }

    public void testDefaultAlarms() throws Exception {
        DavPropertyNameSet props = new DavPropertyNameSet();
        props.add(PropertyNames.DEFAULT_ALARM_VEVENT_DATE);
        props.add(PropertyNames.DEFAULT_ALARM_VEVENT_DATETIME);
        props.add(PropertyNames.SUPPORTED_CALENDAR_COMPONENT_SET);
        PropFindMethod propFind = new PropFindMethod(this.getWebDAVClient().getBaseURI() + "/caldav/", 0, props, 1);
        MultiStatusResponse[] responses = this.getWebDAVClient().doPropFind(propFind);
        Bug32897Test.assertNotNull((String)"got no response", (Object)responses);
        Bug32897Test.assertTrue((String)"got no responses", (0 < responses.length ? 1 : 0) != 0);
        for (MultiStatusResponse response : responses) {
            Node node;
            if (!response.getProperties(200).contains(PropertyNames.SUPPORTED_CALENDAR_COMPONENT_SET) || null == (node = this.extractNodeValue(PropertyNames.SUPPORTED_CALENDAR_COMPONENT_SET, response)) || null == node.getAttributes() || null == node.getAttributes().getNamedItem("name") || !"VEVENT".equals(node.getAttributes().getNamedItem("name").getTextContent())) continue;
            Object defaultAlarmVEventDate = response.getProperties(200).get(PropertyNames.DEFAULT_ALARM_VEVENT_DATE).getValue();
            Bug32897Test.assertTrue((String)"wrong default alarm", (null == defaultAlarmVEventDate || Strings.isEmpty((String)String.valueOf(defaultAlarmVEventDate)) ? 1 : 0) != 0);
            Object defaultAlarmVEventDatetime = response.getProperties(200).get(PropertyNames.DEFAULT_ALARM_VEVENT_DATETIME).getValue();
            Bug32897Test.assertTrue((String)"wrong default alarm", (null == defaultAlarmVEventDatetime || Strings.isEmpty((String)String.valueOf(defaultAlarmVEventDatetime)) ? 1 : 0) != 0);
        }
    }
}

